/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.style.advanced.points.widgets;

import eu.udig.style.advanced.common.IStyleChangesListener;
import eu.udig.style.advanced.common.ParameterComposite;
import eu.udig.style.advanced.common.styleattributeclasses.PointSymbolizerWrapper;
import eu.udig.style.advanced.common.styleattributeclasses.RuleWrapper;
import eu.udig.style.advanced.internal.Messages;
import java.awt.Font;
import java.util.HashSet;
import java.util.TreeSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.custom.TableCursor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.geotools.renderer.style.FontCache;

public class PointCharacterChooserComposite
extends ParameterComposite
implements SelectionListener {
    private static final String TTF_PREFIX = "ttf://";
    private static final String HEX_PREFIX = "#0x";
    private static final String LABEL_PREFIX = "Character Code: 0x";
    private static final int FIRST_CHAR = 33;
    private static final int CHARACTERS = 65536;
    private static final int PLUS_SIGN = 43;
    private static final int COLUMNS = 8;
    private static final int FONT_SIZE = 12;
    private Combo fontCombo;
    private Table table;
    private Label characterLabel;
    private TableCursor tableCursor;
    private String fontName;
    private String characterCode;
    private String[] characterString;
    private final Composite parent;
    private Composite mainComposite;

    public PointCharacterChooserComposite(Composite parent) {
        this.parent = parent;
    }

    @Override
    public Composite getComposite() {
        return this.mainComposite;
    }

    public void init(RuleWrapper ruleWrapper) {
        PointSymbolizerWrapper pointSymbolizerWrapper = ruleWrapper.getGeometrySymbolizersWrapper().adapt(PointSymbolizerWrapper.class);
        this.mainComposite = new Composite(this.parent, 16);
        this.mainComposite.setLayout((Layout)new GridLayout(2, false));
        this.mainComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        Label fontLabel = new Label(this.mainComposite, 0);
        fontLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        fontLabel.setText("Font:");
        this.fontCombo = new Combo(this.mainComposite, 12);
        this.fontCombo.setItems(this.getScalableFonts());
        this.fontCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        String characterPath = pointSymbolizerWrapper.getMarkName();
        if (characterPath != null && characterPath.matches("ttf://.+#.+")) {
            String[] fontElements = characterPath.substring(6).split("#");
            int index = this.fontCombo.indexOf(fontElements[0]);
            if (index != -1) {
                this.fontCombo.select(index);
                this.characterCode = fontElements[1].substring(2);
            } else {
                this.fontCombo.select(0);
                this.characterCode = Integer.toHexString(43);
            }
        } else {
            this.fontCombo.select(0);
            this.characterCode = Integer.toHexString(43);
        }
        this.fontCombo.addSelectionListener((SelectionListener)this);
        this.fontName = this.fontCombo.getItem(this.fontCombo.getSelectionIndex());
        this.table = new Table(this.mainComposite, 268438080);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = 2;
        gridData.heightHint = 300;
        this.table.setLayoutData((Object)gridData);
        this.table.setLinesVisible(true);
        this.table.setRedraw(false);
        org.eclipse.swt.graphics.Font font = new org.eclipse.swt.graphics.Font((Device)Display.getCurrent(), this.fontName, 12, 0);
        this.table.setFont(font);
        this.table.addListener(36, new Listener(){
            Font awtFont;
            {
                this.awtFont = new Font(PointCharacterChooserComposite.this.fontName, 0, 12);
            }

            public void handleEvent(Event event) {
                final TableItem item = (TableItem)event.item;
                final int index = PointCharacterChooserComposite.this.table.indexOf(item);
                item.setText(0, "...");
                Job load = new Job(Messages.PointCharacterChooserComposite_0){

                    protected IStatus run(IProgressMonitor monitor) {
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                int character = 33 + index * 8;
                                int cel = 0;
                                while (cel < 8) {
                                    if (character < 65536) {
                                        if (character > 255 && !awtFont.canDisplay(character)) {
                                            item.setText(cel, "");
                                        } else {
                                            item.setText(cel, PointCharacterChooserComposite.this.characterString[character]);
                                        }
                                    }
                                    ++character;
                                    ++cel;
                                }
                            }
                        });
                        return Status.OK_STATUS;
                    }
                };
                load.schedule();
            }
        });
        int i = 0;
        while (i < 8) {
            new TableColumn(this.table, 0);
            ++i;
        }
        this.initializeCharacterStringArray();
        this.table.setItemCount(8192);
        this.table.getColumn(0).pack();
        int width = this.table.getColumn(0).getWidth();
        int i2 = 1;
        while (i2 < 8) {
            this.table.getColumn(i2).setWidth(width);
            ++i2;
        }
        this.table.setRedraw(true);
        this.tableCursor = new TableCursor(this.table, 0);
        this.tableCursor.setBackground(Display.getCurrent().getSystemColor(19));
        int index = Integer.parseInt(this.characterCode, 16);
        int row = index / 8 - 4;
        int col = index % 8;
        this.tableCursor.setSelection(row, col);
        this.tableCursor.setFont(font);
        this.tableCursor.addSelectionListener((SelectionListener)this);
        this.characterLabel = new Label(this.mainComposite, 0);
        this.characterLabel.setText(LABEL_PREFIX + this.characterCode + "      ");
    }

    public String getCharacterPath() {
        if (this.fontName == null || this.characterCode == null) {
            return null;
        }
        return TTF_PREFIX + this.fontName + HEX_PREFIX + this.characterCode;
    }

    private String[] getScalableFonts() {
        FontData[] fontData = Display.getCurrent().getFontList(null, true);
        HashSet<String> fontSet = new HashSet<String>();
        FontData[] fontDataArray = fontData;
        int n = fontData.length;
        int n2 = 0;
        while (n2 < n) {
            FontData fd = fontDataArray[n2];
            fontSet.add(fd.getName());
            ++n2;
        }
        TreeSet fontCache = new TreeSet(new FontCache().getAvailableFonts());
        fontCache.retainAll(fontSet);
        return fontCache.toArray(new String[0]);
    }

    public void widgetSelected(SelectionEvent e) {
        Object source = e.getSource();
        if (source.equals(this.fontCombo)) {
            this.fontName = this.fontCombo.getItem(this.fontCombo.getSelectionIndex());
            this.update();
            this.notifyListeners(this.getCharacterPath(), false, IStyleChangesListener.STYLEEVENTTYPE.MARKNAME);
        } else if (source.equals(this.tableCursor)) {
            TableItem[] tableItem = new TableItem[]{this.tableCursor.getRow()};
            this.table.setSelection(tableItem);
            int index = (this.table.getSelectionIndex() + 4) * 8 + this.tableCursor.getColumn();
            this.table.deselect(this.table.getSelectionIndex());
            if (index >= 33) {
                this.characterCode = Integer.toHexString(index);
                this.characterLabel.setText(LABEL_PREFIX + this.characterCode);
            }
            this.notifyListeners(this.getCharacterPath(), false, IStyleChangesListener.STYLEEVENTTYPE.MARKNAME);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private void update() {
        this.table.setRedraw(false);
        org.eclipse.swt.graphics.Font font = new org.eclipse.swt.graphics.Font((Device)Display.getCurrent(), this.fontName, 12, 0);
        this.table.setFont(font);
        this.table.setItemCount(8192);
        this.table.setRedraw(true);
    }

    private void initializeCharacterStringArray() {
        this.characterString = new String[65536];
        int i = 0;
        while (i < 65536) {
            this.characterString[i] = Character.toString((char)i);
            ++i;
        }
    }
}

