/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.style.advanced.points;

import eu.udig.style.advanced.common.GroupRulesTreeContentProvider;
import eu.udig.style.advanced.common.GroupRulesTreeLabelProvider;
import eu.udig.style.advanced.common.PropertiesEditor;
import eu.udig.style.advanced.common.styleattributeclasses.FeatureTypeStyleWrapper;
import eu.udig.style.advanced.common.styleattributeclasses.PointSymbolizerWrapper;
import eu.udig.style.advanced.common.styleattributeclasses.RuleWrapper;
import eu.udig.style.advanced.common.styleattributeclasses.StyleWrapper;
import eu.udig.style.advanced.internal.Messages;
import eu.udig.style.advanced.points.PointPropertiesComposite;
import eu.udig.style.advanced.points.PointStyleManager;
import eu.udig.style.advanced.utils.ImageCache;
import eu.udig.style.advanced.utils.Utilities;
import java.io.File;
import java.io.IOException;
import java.util.List;
import net.refractions.udig.catalog.ID;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.style.internal.StyleLayer;
import net.refractions.udig.style.sld.SLD;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Style;

public class PointPropertiesEditor
extends PropertiesEditor {
    private Composite propertiesComposite;
    private StackLayout propertiesStackLayout;
    private PointStyleManager pointStyleManager;

    public PointPropertiesEditor(StyleLayer layer) {
        super(layer);
    }

    @Override
    protected void createGui(Composite parent) {
        this.mainComposite = new Composite(parent, 0);
        this.mainComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.mainComposite.setLayout((Layout)new GridLayout(2, true));
        Composite leftComposite = new Composite(this.mainComposite, 0);
        leftComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        leftComposite.setLayout((Layout)new GridLayout(1, false));
        Group rulesAndPreviewGroup = new Group(leftComposite, 64);
        rulesAndPreviewGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout rulesAndPreviewGroupLayout = new GridLayout(2, false);
        rulesAndPreviewGroupLayout.marginTop = 0;
        rulesAndPreviewGroup.setLayout((Layout)rulesAndPreviewGroupLayout);
        rulesAndPreviewGroup.setText(Messages.PointPropertiesEditor_0);
        Composite canvasComposite = new Composite((Composite)rulesAndPreviewGroup, 0);
        canvasComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        canvasComposite.setLayout((Layout)new GridLayout(1, false));
        this.previewCanvas = new Canvas(canvasComposite, 2048);
        GridData previewCanvasGD = new GridData(1, 128, true, true);
        previewCanvasGD.minimumHeight = 150;
        previewCanvasGD.minimumWidth = 150;
        this.previewCanvas.setSize(150, 150);
        this.previewCanvas.setBackground(this.white);
        this.previewCanvas.setLayoutData((Object)previewCanvasGD);
        this.previewCanvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (PointPropertiesEditor.this.previewImage == null) {
                    Display display = Display.getDefault();
                    PointPropertiesEditor.this.previewImage = new Image((Device)display, 150, 150);
                }
                e.gc.drawImage(PointPropertiesEditor.this.previewImage, 0, 0);
                e.gc.setLineWidth(1);
                e.gc.setLineStyle(3);
                e.gc.setForeground(PointPropertiesEditor.this.gray);
                e.gc.drawLine(75, 0, 75, 150);
                e.gc.drawLine(0, 75, 150, 75);
            }
        });
        Composite rulesComposite = new Composite((Composite)rulesAndPreviewGroup, 0);
        GridData rulesCompositeGD = new GridData(4, 4, true, false);
        rulesComposite.setLayoutData((Object)rulesCompositeGD);
        GridLayout rulesCompositeLayout = new GridLayout(6, true);
        rulesComposite.setLayout((Layout)rulesCompositeLayout);
        this.groupRulesTreeViewer = this.createGroupRulesTreeViewer(rulesComposite);
        this.createRulesButtons(rulesComposite);
        this.groupRulesTreeViewer.setInput(this.styleWrapper.getFeatureTypeStylesWrapperList());
        Group styleViewerGroup = new Group(leftComposite, 0);
        GridData styleViewerGroupGD = new GridData(4, 4, true, true);
        styleViewerGroup.setLayoutData((Object)styleViewerGroupGD);
        styleViewerGroup.setLayout((Layout)new GridLayout(10, false));
        styleViewerGroup.setText(Messages.PointPropertiesEditor_1);
        Composite styleManagerComposite = new Composite((Composite)styleViewerGroup, 0);
        GridData styleManagerCompositeGD = new GridData(4, 4, true, true);
        styleManagerCompositeGD.horizontalSpan = 10;
        styleManagerComposite.setLayoutData((Object)styleManagerCompositeGD);
        styleManagerComposite.setLayout((Layout)new GridLayout(1, false));
        this.pointStyleManager = new PointStyleManager();
        this.pointStyleManager.init(styleManagerComposite);
        this.createStyleButtons((Composite)styleViewerGroup);
        Composite rightComposite = new Composite(this.mainComposite, 0);
        rightComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        rightComposite.setLayout((Layout)new GridLayout(1, false));
        this.propertiesComposite = new Composite(rightComposite, 0);
        this.propertiesStackLayout = new StackLayout();
        this.propertiesComposite.setLayout((Layout)this.propertiesStackLayout);
        GridData propertiesCompositeGD = new GridData(4, 4, true, true);
        this.propertiesComposite.setLayoutData((Object)propertiesCompositeGD);
        RuleWrapper ruleWrapper = this.styleWrapper.getFirstRule();
        if (ruleWrapper != null) {
            this.setRuleToSelected(ruleWrapper);
        } else {
            Label l = new Label(this.propertiesComposite, 16);
            l.setText(Messages.PointPropertiesEditor_2);
            this.propertiesStackLayout.topControl = l;
        }
    }

    private TreeViewer createGroupRulesTreeViewer(Composite rulesGroup) {
        TreeViewer rulesViewer = new TreeViewer(rulesGroup, 2052);
        Control treeControl = rulesViewer.getControl();
        GridData treeGD = new GridData(4, 128, true, false);
        treeGD.horizontalSpan = 6;
        treeGD.heightHint = 100;
        treeControl.setLayoutData((Object)treeGD);
        rulesViewer.setContentProvider((IContentProvider)new GroupRulesTreeContentProvider());
        rulesViewer.setLabelProvider((IBaseLabelProvider)new GroupRulesTreeLabelProvider(SLD.POINT));
        rulesViewer.addSelectionChangedListener(new ISelectionChangedListener(){
            private PointPropertiesComposite pointPropertieComposite;

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (!(selection instanceof IStructuredSelection)) {
                    return;
                }
                IStructuredSelection sel = (IStructuredSelection)selection;
                if (sel.isEmpty()) {
                    this.showEmptyLabel();
                    return;
                }
                Object selectedItem = sel.getFirstElement();
                if (selectedItem == null) {
                    return;
                }
                if (selectedItem instanceof FeatureTypeStyleWrapper) {
                    this.showEmptyLabel();
                }
                if (selectedItem instanceof RuleWrapper) {
                    RuleWrapper currentSelectedRule = (RuleWrapper)selectedItem;
                    if (PointPropertiesEditor.this.propertiesComposite != null) {
                        if (this.pointPropertieComposite == null) {
                            this.pointPropertieComposite = new PointPropertiesComposite(PointPropertiesEditor.this, PointPropertiesEditor.this.propertiesComposite);
                        }
                        this.pointPropertieComposite.setRule(currentSelectedRule);
                        ((PointPropertiesEditor)PointPropertiesEditor.this).propertiesStackLayout.topControl = this.pointPropertieComposite.getComposite();
                        PointPropertiesEditor.this.propertiesComposite.layout();
                    }
                }
            }

            private void showEmptyLabel() {
                Label emptyLabel = new Label(PointPropertiesEditor.this.propertiesComposite, 0);
                emptyLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
                emptyLabel.setText(Messages.PointPropertiesEditor_3);
                ((PointPropertiesEditor)PointPropertiesEditor.this).propertiesStackLayout.topControl = emptyLabel;
                PointPropertiesEditor.this.propertiesComposite.layout();
            }
        });
        return rulesViewer;
    }

    private void createRulesButtons(Composite rulesGroup) {
        Image addGroupImg = ImageCache.getInstance().getImage("icons/addgroup.gif");
        Image addImg = ImageCache.getInstance().getImage("icons/add.gif");
        Image delImg = ImageCache.getInstance().getImage("icons/delete.gif");
        Image delAllImg = ImageCache.getInstance().getImage("icons/deleteall.gif");
        Image upImg = ImageCache.getInstance().getImage("icons/up.gif");
        Image downImg = ImageCache.getInstance().getImage("icons/down.gif");
        Button addGroupButton = new Button(rulesGroup, 8);
        addGroupButton.setLayoutData((Object)new GridData(4, 4, true, false));
        addGroupButton.setImage(addGroupImg);
        addGroupButton.setToolTipText(Messages.PointPropertiesEditor_4);
        addGroupButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FeatureTypeStyle featureTypeStyle = Utilities.sf.createFeatureTypeStyle();
                FeatureTypeStyleWrapper addedFeatureTypeStyle = PointPropertiesEditor.this.styleWrapper.addFeatureTypeStyle(featureTypeStyle);
                String tmpName = Messages.PointPropertiesEditor_5;
                tmpName = Utilities.checkSameNameFeatureTypeStyle(PointPropertiesEditor.this.styleWrapper.getFeatureTypeStylesWrapperList(), tmpName);
                addedFeatureTypeStyle.setName(tmpName);
                PointPropertiesEditor.this.reloadGroupsAndRules();
                PointPropertiesEditor.this.refreshPreviewCanvasOnStyle();
            }
        });
        final Button addButton = new Button(rulesGroup, 8);
        addButton.setLayoutData((Object)new GridData(4, 4, true, false));
        addButton.setImage(addImg);
        addButton.setToolTipText(Messages.PointPropertiesEditor_6);
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RuleWrapper selectedRule;
                FeatureTypeStyleWrapper selectedFtsw = PointPropertiesEditor.this.getSelectedFtsw();
                if (selectedFtsw == null && (selectedRule = PointPropertiesEditor.this.getSelectedRule()) != null) {
                    selectedFtsw = selectedRule.getParent();
                }
                if (selectedFtsw == null) {
                    MessageDialog.openWarning((Shell)addButton.getShell(), (String)Messages.PointPropertiesEditor_7, (String)Messages.PointPropertiesEditor_8);
                    return;
                }
                RuleWrapper addedRuleWrapper = selectedFtsw.addRule(null, PointSymbolizerWrapper.class);
                String tmpName = Messages.PointPropertiesEditor_9;
                tmpName = Utilities.checkSameNameRule(addedRuleWrapper.getParent().getRulesWrapperList(), tmpName);
                addedRuleWrapper.setName(tmpName);
                PointPropertiesEditor.this.reloadGroupsAndRules();
                PointPropertiesEditor.this.refreshPreviewCanvasOnStyle();
                PointPropertiesEditor.this.setRuleToSelected(addedRuleWrapper);
            }
        });
        Button deleteButton = new Button(rulesGroup, 8);
        deleteButton.setLayoutData((Object)new GridData(4, 4, true, false));
        deleteButton.setImage(delImg);
        deleteButton.setToolTipText(Messages.PointPropertiesEditor_10);
        deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FeatureTypeStyleWrapper selectedFtsw = PointPropertiesEditor.this.getSelectedFtsw();
                RuleWrapper selectedRule = PointPropertiesEditor.this.getSelectedRule();
                if (selectedFtsw != null) {
                    PointPropertiesEditor.this.styleWrapper.removeFeatureTypeStyle(selectedFtsw);
                } else if (selectedRule != null) {
                    selectedRule.getParent().removeRule(selectedRule);
                } else {
                    MessageDialog.openWarning((Shell)addButton.getShell(), (String)Messages.PointPropertiesEditor_11, (String)Messages.PointPropertiesEditor_12);
                    return;
                }
                PointPropertiesEditor.this.reloadGroupsAndRules();
                PointPropertiesEditor.this.refreshPreviewCanvasOnStyle();
            }
        });
        Button deleteAllButton = new Button(rulesGroup, 8);
        deleteAllButton.setLayoutData((Object)new GridData(4, 4, true, false));
        deleteAllButton.setImage(delAllImg);
        deleteAllButton.setToolTipText(Messages.PointPropertiesEditor_13);
        deleteAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PointPropertiesEditor.this.styleWrapper.clear();
                PointPropertiesEditor.this.reloadGroupsAndRules();
                PointPropertiesEditor.this.refreshPreviewCanvasOnStyle();
            }
        });
        Button upButton = new Button(rulesGroup, 8);
        upButton.setLayoutData((Object)new GridData(4, 4, true, false));
        upButton.setImage(upImg);
        upButton.setToolTipText(Messages.PointPropertiesEditor_14);
        upButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PointPropertiesEditor.this.swap(true);
            }
        });
        Button downButton = new Button(rulesGroup, 8);
        downButton.setLayoutData((Object)new GridData(4, 4, true, false));
        downButton.setImage(downImg);
        downButton.setToolTipText(Messages.PointPropertiesEditor_15);
        downButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PointPropertiesEditor.this.swap(false);
            }
        });
    }

    private void createStyleButtons(Composite rulesGroup) {
        Image saveImg = ImageCache.getInstance().getImage("icons/save.gif");
        Image saveAllImg = ImageCache.getInstance().getImage("icons/saveall.gif");
        Image delImg = ImageCache.getInstance().getImage("icons/delete.gif");
        Image loadImg = ImageCache.getInstance().getImage("icons/apply.gif");
        Image importImg = ImageCache.getInstance().getImage("icons/import.gif");
        Image exportImg = ImageCache.getInstance().getImage("icons/export.gif");
        Image openImg = ImageCache.getInstance().getImage("icons/open.gif");
        Button saveButton = new Button(rulesGroup, 8);
        saveButton.setLayoutData((Object)new GridData(4, 4, true, false));
        saveButton.setImage(saveImg);
        saveButton.setToolTipText(Messages.PointPropertiesEditor_16);
        saveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RuleWrapper selectedRule = PointPropertiesEditor.this.getSelectedRule();
                FeatureTypeStyle featureTypeStyle = Utilities.sf.createFeatureTypeStyle();
                featureTypeStyle.rules().add(selectedRule.getRule());
                Style namedStyle = Utilities.sf.createStyle();
                namedStyle.featureTypeStyles().add(featureTypeStyle);
                namedStyle.setName(selectedRule.getName());
                try {
                    PointPropertiesEditor.this.pointStyleManager.addStyle(new StyleWrapper(namedStyle));
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        final Button saveAllButton = new Button(rulesGroup, 8);
        saveAllButton.setLayoutData((Object)new GridData(4, 4, true, false));
        saveAllButton.setImage(saveAllImg);
        saveAllButton.setToolTipText(Messages.PointPropertiesEditor_17);
        saveAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String newStyleName = Messages.PointPropertiesEditor_18;
                InputDialog iDialog = new InputDialog(saveAllButton.getShell(), Messages.PointPropertiesEditor_19, Messages.PointPropertiesEditor_20, newStyleName, null);
                iDialog.setBlockOnOpen(true);
                int open = iDialog.open();
                if (open == 256) {
                    return;
                }
                String name = iDialog.getValue();
                if (name == null || name.length() == 0) {
                    name = newStyleName;
                }
                PointPropertiesEditor.this.styleWrapper.setName(name);
                try {
                    PointPropertiesEditor.this.pointStyleManager.addStyle(PointPropertiesEditor.this.styleWrapper);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        Button deleteButton = new Button(rulesGroup, 8);
        deleteButton.setLayoutData((Object)new GridData(4, 4, true, false));
        deleteButton.setImage(delImg);
        deleteButton.setToolTipText(Messages.PointPropertiesEditor_21);
        deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StyleWrapper styleWrapper = PointPropertiesEditor.this.pointStyleManager.getCurrentSelectedStyle();
                if (styleWrapper == null) {
                    return;
                }
                try {
                    PointPropertiesEditor.this.pointStyleManager.removeStyle(styleWrapper);
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        });
        Button loadButton = new Button(rulesGroup, 8);
        loadButton.setLayoutData((Object)new GridData(4, 4, true, false));
        loadButton.setImage(loadImg);
        loadButton.setToolTipText(Messages.PointPropertiesEditor_22);
        loadButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StyleWrapper styleWrapperToLoad = PointPropertiesEditor.this.pointStyleManager.getCurrentSelectedStyle();
                if (styleWrapperToLoad == null) {
                    return;
                }
                List<FeatureTypeStyleWrapper> featureTypeStylesWrapperList = styleWrapperToLoad.getFeatureTypeStylesWrapperList();
                for (FeatureTypeStyleWrapper featureTypeStyleWrapper : featureTypeStylesWrapperList) {
                    PointPropertiesEditor.this.styleWrapper.addFeatureTypeStyle(featureTypeStyleWrapper.getFeatureTypeStyle());
                }
                PointPropertiesEditor.this.reloadGroupsAndRules();
                PointPropertiesEditor.this.refreshPreviewCanvasOnStyle();
            }
        });
        final Button importButton = new Button(rulesGroup, 8);
        importButton.setLayoutData((Object)new GridData(4, 4, true, false));
        importButton.setImage(importImg);
        importButton.setToolTipText(Messages.PointPropertiesEditor_23);
        importButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDialog = new FileDialog(importButton.getShell(), 4098);
                String path = fileDialog.open();
                if (path == null || path.length() < 1) {
                    return;
                }
                File firstFile = new File(path);
                if (!firstFile.exists()) {
                    throw new IllegalArgumentException();
                }
                File folder = firstFile.getParentFile();
                String[] fileNames = fileDialog.getFileNames();
                File[] files = new File[fileNames.length];
                int i = 0;
                while (i < files.length) {
                    files[i] = new File(folder, fileNames[i]);
                    ++i;
                }
                try {
                    PointPropertiesEditor.this.pointStyleManager.importToStyle(files);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        final Button exportButton = new Button(rulesGroup, 8);
        exportButton.setLayoutData((Object)new GridData(4, 4, true, false));
        exportButton.setImage(exportImg);
        exportButton.setToolTipText(Messages.PointPropertiesEditor_24);
        exportButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IGeoResource geoResource = PointPropertiesEditor.this.layer.getGeoResource();
                ID id = geoResource.getID();
                if (id.isFile()) {
                    try {
                        File file = id.toFile();
                        PointPropertiesEditor.this.pointStyleManager.exportStyle(PointPropertiesEditor.this.styleWrapper, file);
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                } else {
                    MessageDialog.openWarning((Shell)exportButton.getShell(), (String)Messages.PointPropertiesEditor_25, (String)Messages.PointPropertiesEditor_26);
                }
            }
        });
        Button openFolderButton = new Button(rulesGroup, 8);
        openFolderButton.setLayoutData((Object)new GridData(4, 4, true, false));
        openFolderButton.setImage(openImg);
        openFolderButton.setToolTipText(Messages.PointPropertiesEditor_27);
        openFolderButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                File pointStyleFolderFile = PointPropertiesEditor.this.pointStyleManager.getStyleFolderFile();
                Program.launch((String)pointStyleFolderFile.getAbsolutePath());
            }
        });
    }
}

