/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.style.advanced.lines;

import eu.udig.style.advanced.StylePlugin;
import eu.udig.style.advanced.common.StyleFilter;
import eu.udig.style.advanced.common.StyleManager;
import eu.udig.style.advanced.common.styleattributeclasses.FeatureTypeStyleWrapper;
import eu.udig.style.advanced.common.styleattributeclasses.RuleWrapper;
import eu.udig.style.advanced.common.styleattributeclasses.StyleWrapper;
import eu.udig.style.advanced.utils.Utilities;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.List;
import net.refractions.udig.ui.graphics.AWTSWTImageUtils;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public class LineStyleManager
extends StyleManager {
    public LineStyleManager() {
        IPath stateLocation = StylePlugin.getDefault().getStateLocation();
        File stateLocationFile = stateLocation.toFile();
        this.styleFolderFile = new File(stateLocationFile, LINESTYLEFOLDER);
        if (!this.styleFolderFile.exists()) {
            this.styleFolderFile.mkdirs();
        }
    }

    public void init(Composite parent) {
        this.createStylesTableViewer(parent);
        this.reloadStyleFolder();
    }

    private TableViewer createStylesTableViewer(Composite parent) {
        final StyleFilter filter = new StyleFilter();
        final Text searchText = new Text(parent, 2176);
        searchText.setLayoutData((Object)new GridData(768));
        searchText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent ke) {
                filter.setSearchText(searchText.getText());
                LineStyleManager.this.stylesViewer.refresh();
            }
        });
        this.stylesViewer = new TableViewer(parent, 2052);
        Table table = this.stylesViewer.getTable();
        GridData tableGD = new GridData(4, 4, true, true);
        tableGD.heightHint = 200;
        table.setLayoutData((Object)tableGD);
        this.stylesViewer.addFilter((ViewerFilter)filter);
        this.stylesViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof List) {
                    List styles = (List)inputElement;
                    Object[] array = styles.toArray(new StyleWrapper[styles.size()]);
                    return array;
                }
                return null;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.stylesViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public org.eclipse.swt.graphics.Image getImage(Object element) {
                if (element instanceof StyleWrapper) {
                    StyleWrapper styleWrapper = (StyleWrapper)element;
                    List<FeatureTypeStyleWrapper> featureTypeStylesWrapperList = styleWrapper.getFeatureTypeStylesWrapperList();
                    int iconSize = 48;
                    BufferedImage image = new BufferedImage(iconSize, iconSize, 2);
                    Graphics2D g2d = image.createGraphics();
                    g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    for (FeatureTypeStyleWrapper featureTypeStyle : featureTypeStylesWrapperList) {
                        List<RuleWrapper> rulesWrapperList = featureTypeStyle.getRulesWrapperList();
                        BufferedImage tmpImage = Utilities.lineRulesWrapperToImage(rulesWrapperList, iconSize, iconSize);
                        g2d.drawImage((Image)tmpImage, 0, 0, null);
                    }
                    g2d.dispose();
                    org.eclipse.swt.graphics.Image convertToSWTImage = AWTSWTImageUtils.convertToSWTImage((BufferedImage)image);
                    return convertToSWTImage;
                }
                return null;
            }

            public String getText(Object element) {
                if (element instanceof StyleWrapper) {
                    StyleWrapper styleWrapper = (StyleWrapper)element;
                    String styleName = styleWrapper.getName();
                    if (styleName == null || styleName.length() == 0) {
                        styleName = "default style";
                        styleName = Utilities.checkSameNameStyle(LineStyleManager.this.getStyles(), styleName);
                        styleWrapper.setName(styleName);
                    }
                    return styleName;
                }
                return "";
            }
        });
        this.stylesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (!(selection instanceof IStructuredSelection)) {
                    return;
                }
                IStructuredSelection sel = (IStructuredSelection)selection;
                if (sel.isEmpty()) {
                    return;
                }
                Object selectedItem = sel.getFirstElement();
                if (selectedItem == null) {
                    return;
                }
                if (selectedItem instanceof StyleWrapper) {
                    LineStyleManager.this.currentSelectedStyleWrapper = (StyleWrapper)selectedItem;
                }
            }
        });
        return this.stylesViewer;
    }
}

