/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.style.advanced.editorpages;

import eu.udig.style.advanced.internal.Messages;
import eu.udig.style.advanced.points.PointPropertiesEditor;
import eu.udig.style.advanced.utils.Utilities;
import java.util.List;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.project.internal.StyleBlackboard;
import net.refractions.udig.style.internal.StyleLayer;
import net.refractions.udig.style.sld.editor.StyleEditorDialog;
import net.refractions.udig.style.sld.editor.StyleEditorPage;
import net.refractions.udig.ui.graphics.SLDs;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.geotools.data.FeatureSource;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.Style;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.visitor.DuplicatingStyleVisitor;

public class SimplePointEditorPage
extends StyleEditorPage {
    public static final String ID = "eu.udig.style.advanced.editorpages.SimplePointEditorPage";
    private Style style = null;
    private PointPropertiesEditor propertiesEditor;
    private StackLayout stackLayout;
    private Label noFeatureLabel;
    private Composite mainComposite;
    private Style oldStyle;

    public SimplePointEditorPage() {
        this.setSize(new Point(740, 500));
    }

    public void createPageContent(Composite parent) {
        this.mainComposite = new Composite(parent, 0);
        this.mainComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.stackLayout = new StackLayout();
        this.mainComposite.setLayout((Layout)this.stackLayout);
        this.noFeatureLabel = new Label(this.mainComposite, 0);
        this.noFeatureLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.noFeatureLabel.setText(Messages.SimplePointEditorPage_0);
        StyleLayer layer = this.getSelectedLayer();
        IGeoResource resource = layer.getGeoResource();
        if (resource.canResolve(FeatureSource.class)) {
            StyleBlackboard styleBlackboard = layer.getStyleBlackboard();
            this.oldStyle = (Style)styleBlackboard.get("net.refractions.udig.style.sld");
            if (this.oldStyle == null) {
                this.oldStyle = Utilities.createDefaultPointStyle();
            }
            DuplicatingStyleVisitor dsv = new DuplicatingStyleVisitor();
            dsv.visit(this.oldStyle);
            this.style = (Style)dsv.getCopy();
            if (this.isPointStyle(this.style)) {
                this.propertiesEditor = new PointPropertiesEditor(layer);
                this.propertiesEditor.open(this.mainComposite, this.style);
                this.stackLayout.topControl = this.propertiesEditor.getControl();
            } else {
                this.stackLayout.topControl = this.noFeatureLabel;
            }
        } else {
            this.stackLayout.topControl = this.noFeatureLabel;
        }
    }

    private boolean isPointStyle(Style style) {
        Symbolizer[] symbolizers;
        Symbolizer[] symbolizerArray = symbolizers = SLDs.symbolizers((Style)style);
        int n = symbolizers.length;
        int n2 = 0;
        while (n2 < n) {
            Symbolizer symbolizer = symbolizerArray[n2];
            if (symbolizer instanceof PointSymbolizer) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public String getErrorMessage() {
        return null;
    }

    public String getLabel() {
        return null;
    }

    public void gotFocus() {
        this.refresh();
    }

    public boolean performCancel() {
        return true;
    }

    public void styleChanged(Object source) {
    }

    public boolean okToLeave() {
        return true;
    }

    public boolean performApply() {
        this.applyStyle();
        return true;
    }

    private void applyStyle() {
        StyleLayer layer = this.getSelectedLayer();
        Style newStyle = this.propertiesEditor.getStyle();
        List featureTypeStyles = newStyle.featureTypeStyles();
        int ftsNum = featureTypeStyles.size();
        if (ftsNum < 1) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.SimplePointEditorPage_1, (String)Messages.SimplePointEditorPage_2);
            this.style = this.oldStyle;
            this.setStyle(this.oldStyle);
            layer.revertAll();
            layer.apply();
            StyleEditorDialog dialog = (StyleEditorDialog)this.getContainer();
            dialog.getCurrentPage().refresh();
            return;
        }
        newStyle.setName(layer.getName());
        this.setStyle(newStyle);
        StyleBlackboard styleBlackboard = layer.getStyleBlackboard();
        styleBlackboard.put("net.refractions.udig.style.sld", (Object)newStyle);
    }

    public boolean performOk() {
        this.applyStyle();
        this.propertiesEditor.close();
        return true;
    }

    public boolean isValid() {
        return true;
    }

    public void refresh() {
        StyleLayer layer = this.getSelectedLayer();
        IGeoResource resource = layer.getGeoResource();
        if (!resource.canResolve(FeatureSource.class)) {
            return;
        }
        StyleBlackboard styleBlackboard = layer.getStyleBlackboard();
        this.oldStyle = (Style)styleBlackboard.get("net.refractions.udig.style.sld");
        if (this.oldStyle == null) {
            this.oldStyle = Utilities.createDefaultPointStyle();
        }
        DuplicatingStyleVisitor dsv = new DuplicatingStyleVisitor();
        dsv.visit(this.oldStyle);
        this.style = (Style)dsv.getCopy();
        if (!this.isPointStyle(this.style)) {
            this.stackLayout.topControl = this.noFeatureLabel;
        } else {
            this.stackLayout.topControl = this.propertiesEditor.getControl();
            this.propertiesEditor.updateStyle(this.style);
        }
        this.mainComposite.layout();
    }
}

