/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.style.advanced.editorpages;

import eu.udig.style.advanced.internal.Messages;
import eu.udig.style.advanced.utils.StolenColorEditor;
import java.awt.Color;
import net.refractions.udig.project.internal.StyleBlackboard;
import net.refractions.udig.style.sld.editor.StyleEditorPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class CoverageColorMaskStyleEditorPage
extends StyleEditorPage
implements SelectionListener {
    public static String COVERAGE_COLORMASK_ID = "raster-color-mask";
    private Button colorMaskButton;
    private boolean doColorMask;
    private StolenColorEditor maskColorEditor;

    public CoverageColorMaskStyleEditorPage() {
        this.setSize(new Point(500, 450));
    }

    public void createPageContent(Composite parent) {
        StyleBlackboard styleBlackboard = this.getSelectedLayer().getStyleBlackboard();
        String maskColorString = styleBlackboard.getString(COVERAGE_COLORMASK_ID);
        Group colorMaskGroup = new Group(parent, 16);
        colorMaskGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        colorMaskGroup.setLayout((Layout)new GridLayout(2, false));
        colorMaskGroup.setText(Messages.CoverageColorMaskStyleEditorPage_0);
        this.colorMaskButton = new Button((Composite)colorMaskGroup, 32);
        this.colorMaskButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.colorMaskButton.setText(Messages.CoverageColorMaskStyleEditorPage_1);
        this.colorMaskButton.addSelectionListener((SelectionListener)this);
        this.maskColorEditor = new StolenColorEditor((Composite)colorMaskGroup);
        if (maskColorString != null) {
            String[] colorSplit = maskColorString.split(":");
            Color color = new Color(Integer.parseInt(colorSplit[0]), Integer.parseInt(colorSplit[1]), Integer.parseInt(colorSplit[2]));
            this.maskColorEditor.setColor(color);
            this.colorMaskButton.setSelection(true);
        }
    }

    public void widgetSelected(SelectionEvent e) {
        Object source = e.getSource();
        if (source.equals(this.colorMaskButton)) {
            this.doColorMask = this.colorMaskButton.getSelection();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public String getErrorMessage() {
        return null;
    }

    public String getLabel() {
        return null;
    }

    public void gotFocus() {
    }

    public boolean performCancel() {
        return false;
    }

    public boolean okToLeave() {
        return true;
    }

    public boolean performApply() {
        return this.applyCurrentStyle();
    }

    public boolean performOk() {
        return this.applyCurrentStyle();
    }

    private boolean applyCurrentStyle() {
        StyleBlackboard styleBlackboard = this.getSelectedLayer().getStyleBlackboard();
        if (this.colorMaskButton.getSelection()) {
            Color maskColor = this.maskColorEditor.getColor();
            String colorStr = String.valueOf(maskColor.getRed()) + ":" + maskColor.getGreen() + ":" + maskColor.getBlue();
            styleBlackboard.putString(COVERAGE_COLORMASK_ID, colorStr);
        } else {
            styleBlackboard.remove(COVERAGE_COLORMASK_ID);
        }
        return true;
    }

    public void refresh() {
    }

    public void dispose() {
        super.dispose();
    }

    public void styleChanged(Object source) {
    }
}

