/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.style.advanced.common.styleattributeclasses;

import eu.udig.style.advanced.common.styleattributeclasses.FeatureTypeStyleWrapper;
import eu.udig.style.advanced.common.styleattributeclasses.RuleWrapper;
import eu.udig.style.advanced.utils.Utilities;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.geotools.styling.FeatureTypeConstraint;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.SLDTransformer;
import org.geotools.styling.Style;
import org.geotools.styling.StyledLayer;
import org.geotools.styling.StyledLayerDescriptor;
import org.geotools.styling.UserLayer;

public class StyleWrapper {
    private Style style;
    private String name;
    private List<FeatureTypeStyleWrapper> featureTypeStylesWrapperList = new ArrayList<FeatureTypeStyleWrapper>();

    public StyleWrapper(Style style) {
        this.style = style;
        this.name = style.getName();
        List featureTypeStyles = style.featureTypeStyles();
        for (FeatureTypeStyle featureTypeStyle : featureTypeStyles) {
            FeatureTypeStyleWrapper fstW = new FeatureTypeStyleWrapper(featureTypeStyle, this);
            this.featureTypeStylesWrapperList.add(fstW);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.style.setName(name);
    }

    public List<FeatureTypeStyleWrapper> getFeatureTypeStylesWrapperList() {
        return Collections.unmodifiableList(this.featureTypeStylesWrapperList);
    }

    public RuleWrapper getFirstRule() {
        FeatureTypeStyleWrapper featureTypeStyleWrapper;
        List<RuleWrapper> rulesWrapperList;
        if (this.featureTypeStylesWrapperList.size() > 0 && (rulesWrapperList = (featureTypeStyleWrapper = this.featureTypeStylesWrapperList.get(0)).getRulesWrapperList()).size() > 0) {
            RuleWrapper ruleWrapper = rulesWrapperList.get(0);
            return ruleWrapper;
        }
        return null;
    }

    public FeatureTypeStyleWrapper addFeatureTypeStyle(FeatureTypeStyle tmpFts) {
        if (tmpFts == null) {
            tmpFts = Utilities.sf.createFeatureTypeStyle();
        }
        this.style.featureTypeStyles().add(0, tmpFts);
        FeatureTypeStyleWrapper wrapper = new FeatureTypeStyleWrapper(tmpFts, this);
        this.featureTypeStylesWrapperList.add(0, wrapper);
        return wrapper;
    }

    public void removeFeatureTypeStyle(FeatureTypeStyleWrapper ftsW) {
        FeatureTypeStyle fts = ftsW.getFeatureTypeStyle();
        this.style.featureTypeStyles().remove(fts);
        this.featureTypeStylesWrapperList.remove(ftsW);
    }

    public void clear() {
        this.style.featureTypeStyles().clear();
        this.featureTypeStylesWrapperList.clear();
    }

    public String toXml() throws Exception {
        StyledLayerDescriptor sld = Utilities.sf.createStyledLayerDescriptor();
        UserLayer layer = Utilities.sf.createUserLayer();
        layer.setLayerFeatureConstraints(new FeatureTypeConstraint[1]);
        sld.addStyledLayer((StyledLayer)layer);
        layer.addUserStyle(this.style);
        SLDTransformer aTransformer = new SLDTransformer();
        aTransformer.setIndentation(4);
        String xml = aTransformer.transform((Object)sld);
        return xml;
    }

    public Style getStyle() {
        return this.style;
    }

    public void swap(int src, int dest) {
        List ftss = this.style.featureTypeStyles();
        if (src >= 0 && src < ftss.size() && dest >= 0 && dest < ftss.size()) {
            Collections.swap(ftss, src, dest);
            Collections.swap(this.featureTypeStylesWrapperList, src, dest);
        }
    }
}

