/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.style.advanced.common.styleattributeclasses;

import eu.udig.style.advanced.common.styleattributeclasses.DummySymbolizerWrapper;
import eu.udig.style.advanced.common.styleattributeclasses.FeatureTypeStyleWrapper;
import eu.udig.style.advanced.common.styleattributeclasses.LineSymbolizerWrapper;
import eu.udig.style.advanced.common.styleattributeclasses.PointSymbolizerWrapper;
import eu.udig.style.advanced.common.styleattributeclasses.PolygonSymbolizerWrapper;
import eu.udig.style.advanced.common.styleattributeclasses.SymbolizerWrapper;
import eu.udig.style.advanced.common.styleattributeclasses.TextSymbolizerWrapper;
import eu.udig.style.advanced.utils.Utilities;
import java.util.ArrayList;
import java.util.List;
import net.refractions.udig.style.sld.SLD;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.TextSymbolizer;

public class RuleWrapper {
    private Rule rule;
    private String name;
    private String maxScale;
    private String minScale;
    private List<SymbolizerWrapper> symbolizersWrapperList = new ArrayList<SymbolizerWrapper>();
    private final FeatureTypeStyleWrapper parent;

    public RuleWrapper(Rule rule, FeatureTypeStyleWrapper parent) {
        this.rule = rule;
        this.parent = parent;
        this.name = rule.getName();
        try {
            this.maxScale = String.valueOf(rule.getMaxScaleDenominator());
            this.minScale = String.valueOf(rule.getMinScaleDenominator());
        }
        catch (Exception exception) {
            this.maxScale = "infinity";
            this.minScale = "0";
        }
        List symbolizers = rule.symbolizers();
        for (Symbolizer symbolizer : symbolizers) {
            SymbolizerWrapper wrapper = this.getWrapper(symbolizer);
            this.symbolizersWrapperList.add(wrapper);
        }
    }

    public FeatureTypeStyleWrapper getParent() {
        return this.parent;
    }

    public Rule getRule() {
        return this.rule;
    }

    private SymbolizerWrapper getWrapper(Symbolizer symbolizer) {
        SymbolizerWrapper symbolizerWrapper = null;
        if (symbolizer instanceof PointSymbolizer) {
            symbolizerWrapper = new PointSymbolizerWrapper(symbolizer, this);
        } else if (symbolizer instanceof LineSymbolizer) {
            symbolizerWrapper = new LineSymbolizerWrapper(symbolizer, this);
        } else if (symbolizer instanceof PolygonSymbolizer) {
            symbolizerWrapper = new PolygonSymbolizerWrapper(symbolizer, this);
        } else if (symbolizer instanceof TextSymbolizer) {
            symbolizerWrapper = new TextSymbolizerWrapper(symbolizer, this, this.getType());
        } else if (symbolizer instanceof RasterSymbolizer) {
            return null;
        }
        return symbolizerWrapper;
    }

    public SLD getType() {
        SymbolizerWrapper geometrySymbolizersWrapper = this.getGeometrySymbolizersWrapper();
        if (geometrySymbolizersWrapper == null) {
            return null;
        }
        Symbolizer symbolizer = geometrySymbolizersWrapper.getSymbolizer();
        if (symbolizer instanceof PointSymbolizer) {
            return SLD.POINT;
        }
        if (symbolizer instanceof LineSymbolizer) {
            return SLD.LINE;
        }
        if (symbolizer instanceof PolygonSymbolizer) {
            return SLD.POLYGON;
        }
        if (symbolizer instanceof RasterSymbolizer) {
            return SLD.RASTER;
        }
        return null;
    }

    public SymbolizerWrapper getGeometrySymbolizersWrapper() {
        for (SymbolizerWrapper symbolizerWrapper : this.symbolizersWrapperList) {
            if (symbolizerWrapper.isTextSymbolizer()) continue;
            return symbolizerWrapper;
        }
        DummySymbolizerWrapper geometrySymbolizersWrapper = new DummySymbolizerWrapper(Utilities.createDefaultGeometrySymbolizer(SLD.POINT), null);
        return geometrySymbolizersWrapper;
    }

    public TextSymbolizerWrapper getTextSymbolizersWrapper() {
        for (SymbolizerWrapper symbolizerWrapper : this.symbolizersWrapperList) {
            if (!symbolizerWrapper.isTextSymbolizer()) continue;
            return (TextSymbolizerWrapper)symbolizerWrapper;
        }
        return null;
    }

    public void removeTextSymbolizersWrapper() {
        ArrayList<SymbolizerWrapper> removeSW = new ArrayList<SymbolizerWrapper>();
        ArrayList<Symbolizer> removeS = new ArrayList<Symbolizer>();
        List symbolizers = this.rule.symbolizers();
        for (SymbolizerWrapper symbolizerWrapper : this.symbolizersWrapperList) {
            if (!symbolizerWrapper.isTextSymbolizer()) continue;
            Symbolizer symbolizer = symbolizerWrapper.getSymbolizer();
            removeSW.add(symbolizerWrapper);
            removeS.add(symbolizer);
        }
        this.symbolizersWrapperList.removeAll(removeSW);
        symbolizers.removeAll(removeS);
    }

    public <T> T addSymbolizer(Symbolizer newSymbolizer, Class<T> symbolizerClass) {
        SymbolizerWrapper wrapper = null;
        if (newSymbolizer != null) {
            if (newSymbolizer instanceof PointSymbolizer) {
                wrapper = new PointSymbolizerWrapper(newSymbolizer, this);
            } else if (newSymbolizer instanceof LineSymbolizer) {
                wrapper = new LineSymbolizerWrapper(newSymbolizer, this);
            } else if (newSymbolizer instanceof PolygonSymbolizer) {
                wrapper = new PolygonSymbolizerWrapper(newSymbolizer, this);
            } else if (newSymbolizer instanceof TextSymbolizer) {
                wrapper = new TextSymbolizerWrapper(newSymbolizer, this, this.getType());
            } else if (newSymbolizer instanceof RasterSymbolizer) {
                return null;
            }
        } else if (symbolizerClass.isAssignableFrom(PointSymbolizerWrapper.class)) {
            newSymbolizer = Utilities.sf.createPointSymbolizer();
            wrapper = new PointSymbolizerWrapper(newSymbolizer, this);
        } else if (symbolizerClass.isAssignableFrom(LineSymbolizerWrapper.class)) {
            newSymbolizer = Utilities.sf.createLineSymbolizer();
            wrapper = new LineSymbolizerWrapper(newSymbolizer, this);
        } else if (symbolizerClass.isAssignableFrom(PolygonSymbolizerWrapper.class)) {
            newSymbolizer = Utilities.sf.createPolygonSymbolizer();
            wrapper = new PolygonSymbolizerWrapper(newSymbolizer, this);
        } else if (symbolizerClass.isAssignableFrom(TextSymbolizerWrapper.class)) {
            newSymbolizer = Utilities.sf.createTextSymbolizer();
            wrapper = new TextSymbolizerWrapper(newSymbolizer, this, this.getType());
        } else if (symbolizerClass.isAssignableFrom(RasterSymbolizer.class)) {
            return null;
        }
        this.rule.symbolizers().add(newSymbolizer);
        this.symbolizersWrapperList.add(wrapper);
        return symbolizerClass.cast(wrapper);
    }

    public void clear() {
        this.rule.symbolizers().clear();
        this.symbolizersWrapperList.clear();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.rule.setName(name);
    }

    public String getMaxScale() {
        return this.maxScale;
    }

    public void setMaxScale(String maxScale) {
        this.maxScale = maxScale;
        try {
            this.rule.setMaxScaleDenominator(Double.parseDouble(maxScale));
        }
        catch (Exception exception) {
            this.rule.setMaxScaleDenominator(Double.POSITIVE_INFINITY);
        }
    }

    public String getMinScale() {
        return this.minScale;
    }

    public void setMinScale(String minScale) {
        this.minScale = minScale;
        try {
            this.rule.setMinScaleDenominator(Double.parseDouble(minScale));
        }
        catch (Exception exception) {
            this.rule.setMinScaleDenominator(Double.parseDouble("0"));
        }
    }
}

