/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.style.advanced.common.styleattributeclasses;

import eu.udig.style.advanced.common.styleattributeclasses.RuleWrapper;
import eu.udig.style.advanced.common.styleattributeclasses.SymbolizerWrapper;
import eu.udig.style.advanced.utils.Utilities;
import java.awt.geom.Point2D;
import java.util.List;
import net.refractions.udig.ui.graphics.SLDs;
import org.geotools.styling.ExternalGraphic;
import org.geotools.styling.Fill;
import org.geotools.styling.Graphic;
import org.geotools.styling.Mark;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.Symbolizer;
import org.opengis.filter.expression.Expression;
import org.opengis.style.Stroke;

public class PointSymbolizerWrapper
extends SymbolizerWrapper {
    private String size;
    private String rotation;
    private String markName;
    private String fillColor;
    private String fillOpacity;
    private String strokeColor;
    private String strokeOpacity;
    private String strokeWidth;
    private boolean hasFill;
    private boolean hasStroke;
    private Mark mark;
    private Fill fill;
    private org.geotools.styling.Stroke stroke;
    private Graphic graphic;

    public PointSymbolizerWrapper(Symbolizer symbolizer, RuleWrapper parent) {
        super(symbolizer, parent);
        PointSymbolizer pointSymbolizer = (PointSymbolizer)symbolizer;
        this.graphic = pointSymbolizer.getGraphic();
        List<ExternalGraphic> externalGraphicsList = Utilities.externalGraphicsFromGraphic(this.graphic);
        Expression sizeExpr = this.graphic.getSize();
        String tmp = this.expressionToString(sizeExpr);
        this.size = tmp != null ? tmp : "1";
        Expression rotationExpr = this.graphic.getRotation();
        tmp = this.expressionToString(rotationExpr);
        this.rotation = tmp != null ? tmp : "0";
        Point2D offset = Utilities.getOffset((Symbolizer)pointSymbolizer);
        if (offset != null) {
            this.xOffset = String.valueOf(offset.getX());
            this.yOffset = String.valueOf(offset.getY());
        } else {
            this.xOffset = "0";
            this.yOffset = "0";
        }
        if (externalGraphicsList.size() == 0) {
            this.mark = SLDs.mark((PointSymbolizer)pointSymbolizer);
            if (this.mark == null) {
                return;
            }
            this.markName = (String)this.mark.getWellKnownName().evaluate(null, String.class);
            if (this.markName == null || this.markName.equals("")) {
                this.markName = "circle";
                this.mark.setWellKnownName((Expression)Utilities.ff.literal((Object)this.markName));
            }
            this.fill = this.mark.getFill();
            if (this.fill != null) {
                this.fillColor = (String)this.fill.getColor().evaluate(null, String.class);
                Expression opacityExpr = this.fill.getOpacity();
                this.fillOpacity = this.expressionToString(opacityExpr);
                this.hasFill = true;
            } else {
                this.hasFill = false;
            }
            this.stroke = this.mark.getStroke();
            if (this.stroke != null) {
                Expression color = this.stroke.getColor();
                tmp = (String)color.evaluate(null, String.class);
                this.strokeColor = tmp != null ? tmp : "#000000";
                Expression opacity = this.stroke.getOpacity();
                tmp = this.expressionToString(opacity);
                this.strokeOpacity = tmp != null ? tmp : "1";
                Expression width = this.stroke.getWidth();
                tmp = this.expressionToString(width);
                this.strokeWidth = tmp != null ? tmp : "1";
                this.hasStroke = true;
            } else {
                this.hasStroke = false;
            }
        } else {
            this.externalGraphic = externalGraphicsList.get(0);
        }
    }

    public Graphic getGraphic() {
        return this.graphic;
    }

    public void setSize(String size, boolean isProperty) {
        this.size = size;
        if (isProperty) {
            this.graphic.setSize((Expression)Utilities.ff.property(size));
        } else {
            this.graphic.setSize((Expression)Utilities.ff.literal((Object)size));
        }
    }

    public void setRotation(String rotation, boolean isProperty) {
        this.rotation = rotation;
        if (isProperty) {
            this.graphic.setRotation((Expression)Utilities.ff.property(rotation));
        } else {
            this.graphic.setRotation((Expression)Utilities.ff.literal((Object)rotation));
        }
    }

    public void setMarkName(String markName) {
        if (markName == null || markName.equals("")) {
            return;
        }
        this.markName = markName;
        if (this.mark == null) {
            this.mark = Utilities.sf.createMark();
        }
        this.mark.setWellKnownName((Expression)Utilities.ff.literal((Object)markName));
        this.graphic.graphicalSymbols().clear();
        this.graphic.graphicalSymbols().add(this.mark);
    }

    public void setFillColor(String fillColor) {
        this.hasFill = fillColor != null;
        this.fillColor = fillColor;
        this.checkFillExists();
        this.fill.setColor((Expression)Utilities.ff.literal((Object)fillColor));
    }

    public void setFillOpacity(String fillOpacity, boolean isProperty) {
        this.fillOpacity = fillOpacity;
        this.checkFillExists();
        if (isProperty) {
            this.fill.setOpacity((Expression)Utilities.ff.property(fillOpacity));
        } else {
            this.fill.setOpacity((Expression)Utilities.ff.literal((Object)fillOpacity));
        }
    }

    public void setHasStroke(boolean hasStroke) {
        this.hasStroke = hasStroke;
        if (hasStroke) {
            this.checkStrokeExists();
        } else {
            this.stroke = null;
            this.mark.setStroke(null);
        }
    }

    public void setHasFill(boolean hasFill) {
        this.hasFill = hasFill;
        if (hasFill) {
            this.checkFillExists();
        } else {
            this.fill = null;
            this.mark.setFill(null);
        }
    }

    private void checkStrokeExists() {
        if (this.stroke == null) {
            if (this.strokeColor == null) {
                this.strokeColor = "#000000";
            }
            if (this.strokeWidth == null) {
                this.strokeWidth = "1";
            }
            this.stroke = Utilities.sf.createStroke((Expression)Utilities.ff.literal((Object)this.strokeColor), (Expression)Utilities.ff.literal((Object)this.strokeWidth));
            if (this.mark != null) {
                this.mark.setStroke((Stroke)this.stroke);
            }
        }
    }

    private void checkFillExists() {
        if (this.fill == null) {
            if (this.fillColor == null) {
                this.fillColor = "#000000";
            }
            this.fill = Utilities.sf.createFill((Expression)Utilities.ff.literal((Object)this.fillColor));
            if (this.mark != null) {
                this.mark.setFill((org.opengis.style.Fill)this.fill);
            }
        }
    }

    public void setStrokeWidth(String strokeWidth, boolean isProperty) {
        this.strokeWidth = strokeWidth;
        this.checkStrokeExists();
        if (isProperty) {
            this.stroke.setWidth((Expression)Utilities.ff.property(strokeWidth));
        } else {
            this.stroke.setWidth((Expression)Utilities.ff.literal((Object)strokeWidth));
        }
    }

    public void setStrokeColor(String strokeColor) {
        this.strokeColor = strokeColor;
        this.checkStrokeExists();
        this.hasStroke = strokeColor != null;
        this.stroke.setColor((Expression)Utilities.ff.literal((Object)strokeColor));
    }

    public void setStrokeOpacity(String strokeOpacity, boolean isProperty) {
        this.strokeOpacity = strokeOpacity;
        this.checkStrokeExists();
        if (isProperty) {
            this.stroke.setOpacity((Expression)Utilities.ff.property(strokeOpacity));
        } else {
            this.stroke.setOpacity((Expression)Utilities.ff.literal((Object)strokeOpacity));
        }
    }

    public String getSize() {
        return this.size;
    }

    public String getRotation() {
        return this.rotation;
    }

    public String getMarkName() {
        return this.markName;
    }

    public String getFillColor() {
        return this.fillColor;
    }

    public String getFillOpacity() {
        return this.fillOpacity;
    }

    public String getStrokeColor() {
        return this.strokeColor;
    }

    public String getStrokeOpacity() {
        return this.strokeOpacity;
    }

    public String getStrokeWidth() {
        return this.strokeWidth;
    }

    public boolean hasFill() {
        return this.hasFill;
    }

    public boolean hasStroke() {
        return this.hasStroke;
    }
}

