/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.style.advanced.common;

import eu.udig.style.advanced.common.styleattributeclasses.FeatureTypeStyleWrapper;
import eu.udig.style.advanced.common.styleattributeclasses.RuleWrapper;
import eu.udig.style.advanced.internal.Messages;
import eu.udig.style.advanced.utils.Utilities;
import java.awt.image.BufferedImage;
import java.util.List;
import net.refractions.udig.style.sld.SLD;
import net.refractions.udig.ui.graphics.AWTSWTImageUtils;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class GroupRulesTreeLabelProvider
extends LabelProvider {
    private final SLD type;

    public GroupRulesTreeLabelProvider(SLD type) {
        this.type = type;
    }

    public Image getImage(Object element) {
        BufferedImage image = null;
        if (element instanceof FeatureTypeStyleWrapper) {
            FeatureTypeStyleWrapper ftsW = (FeatureTypeStyleWrapper)element;
            List<RuleWrapper> rulesWrapperList = ftsW.getRulesWrapperList();
            image = Utilities.rulesWrapperToImage(rulesWrapperList, 16, 16, this.type);
        } else if (element instanceof RuleWrapper) {
            RuleWrapper ruleWrapper = (RuleWrapper)element;
            image = Utilities.rulesWrapperToImage(ruleWrapper, 16, 16, this.type);
        }
        if (image != null) {
            Image convertToSWTImage = AWTSWTImageUtils.convertToSWTImage(image);
            return convertToSWTImage;
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof FeatureTypeStyleWrapper) {
            FeatureTypeStyleWrapper ftsW = (FeatureTypeStyleWrapper)element;
            String name = ftsW.getName();
            if (name == null || name.length() == 0) {
                name = Messages.GroupRulesTreeLabelProvider_0;
                name = Utilities.checkSameNameFeatureTypeStyle(ftsW.getParent().getFeatureTypeStylesWrapperList(), name);
                ftsW.setName(name);
            }
            return name;
        }
        if (element instanceof RuleWrapper) {
            RuleWrapper ruleWrapper = (RuleWrapper)element;
            String name = ruleWrapper.getName();
            if (name == null || name.length() == 0) {
                name = Messages.GroupRulesTreeLabelProvider_1;
                name = Utilities.checkSameNameRule(ruleWrapper.getParent().getRulesWrapperList(), name);
                ruleWrapper.setName(name);
            }
            return name;
        }
        return null;
    }
}

