/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.style.advanced.common;

import eu.udig.style.advanced.common.IStyleChangesListener;
import eu.udig.style.advanced.common.ParameterComposite;
import eu.udig.style.advanced.common.styleattributeclasses.LineSymbolizerWrapper;
import eu.udig.style.advanced.common.styleattributeclasses.RuleWrapper;
import eu.udig.style.advanced.internal.Messages;
import eu.udig.style.advanced.utils.StolenColorEditor;
import eu.udig.style.advanced.utils.Utilities;
import java.awt.Color;
import java.io.File;
import java.net.MalformedURLException;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.opengis.filter.expression.Literal;

public class BoderParametersComposite
extends ParameterComposite
implements ModifyListener {
    private final Composite parent;
    private final String[] numericAttributesArrays;
    private Composite mainComposite;
    private Button borderEnableButton;
    private Spinner borderWidthSpinner;
    private Combo borderWidthAttributecombo;
    private StolenColorEditor borderColorEditor;
    private Spinner borderOpacitySpinner;
    private Combo borderOpacityAttributecombo;
    private Button borderColorButton;
    private Text graphicsPathText;
    private Text dashText;
    private Text dashOffsetText;
    private Combo lineJoinCombo;
    private Combo lineCapCombo;
    private final String[] stringAttributesArrays;
    private Combo borderColorAttributecombo;

    public BoderParametersComposite(Composite parent, String[] numericAttributesArrays, String[] stringattributesArrays) {
        this.parent = parent;
        this.numericAttributesArrays = numericAttributesArrays;
        this.stringAttributesArrays = stringattributesArrays;
    }

    @Override
    public Composite getComposite() {
        return this.mainComposite;
    }

    public void init(RuleWrapper ruleWrapper) {
        int index;
        int index2;
        int index3;
        Color tmpColor;
        int index4;
        int index5;
        LineSymbolizerWrapper lineSymbolizerWrapper = ruleWrapper.getGeometrySymbolizersWrapper().adapt(LineSymbolizerWrapper.class);
        this.mainComposite = new Composite(this.parent, 0);
        this.mainComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.mainComposite.setLayout((Layout)new GridLayout(3, true));
        boolean widgetEnabled = lineSymbolizerWrapper.hasStroke();
        this.borderEnableButton = new Button(this.mainComposite, 32);
        GridData borderEnableButtonGD = new GridData(1, 0x1000000, false, false);
        borderEnableButtonGD.horizontalSpan = 3;
        this.borderEnableButton.setLayoutData((Object)borderEnableButtonGD);
        this.borderEnableButton.setText(Messages.BoderParametersComposite_0);
        this.borderEnableButton.setSelection(widgetEnabled);
        this.borderEnableButton.addSelectionListener((SelectionListener)this);
        new Label(this.mainComposite, 0);
        Label valueLabel = new Label(this.mainComposite, 0);
        valueLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
        valueLabel.setText(Messages.BoderParametersComposite_1);
        Label fieldsLabel = new Label(this.mainComposite, 0);
        fieldsLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
        fieldsLabel.setText(Messages.BoderParametersComposite_2);
        Label borderWidthLabel = new Label(this.mainComposite, 0);
        borderWidthLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        borderWidthLabel.setText(Messages.BoderParametersComposite_3);
        this.borderWidthSpinner = new Spinner(this.mainComposite, 2048);
        this.borderWidthSpinner.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.borderWidthSpinner.setMaximum(500);
        this.borderWidthSpinner.setMinimum(0);
        this.borderWidthSpinner.setIncrement(10);
        String width = lineSymbolizerWrapper.getStrokeWidth();
        Double tmpWidth = this.isDouble(width);
        int tmp = 3;
        if (tmpWidth != null) {
            tmp = tmpWidth.intValue();
        }
        this.borderWidthSpinner.setSelection(tmp * 10);
        this.borderWidthSpinner.setDigits(1);
        this.borderWidthSpinner.addSelectionListener((SelectionListener)this);
        this.borderWidthAttributecombo = new Combo(this.mainComposite, 12);
        this.borderWidthAttributecombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.borderWidthAttributecombo.setItems(this.numericAttributesArrays);
        this.borderWidthAttributecombo.addSelectionListener((SelectionListener)this);
        this.borderWidthAttributecombo.select(0);
        if (tmpWidth == null && (index5 = this.getAttributeIndex(width, this.numericAttributesArrays)) != -1) {
            this.borderWidthAttributecombo.select(index5);
        }
        Label borderOpactityLabel = new Label(this.mainComposite, 0);
        borderOpactityLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        borderOpactityLabel.setText(Messages.BoderParametersComposite_4);
        this.borderOpacitySpinner = new Spinner(this.mainComposite, 2048);
        this.borderOpacitySpinner.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.borderOpacitySpinner.setMaximum(100);
        this.borderOpacitySpinner.setMinimum(0);
        this.borderOpacitySpinner.setIncrement(10);
        String opacity = lineSymbolizerWrapper.getStrokeOpacity();
        Double tmpOpacity = this.isDouble(opacity);
        tmp = 100;
        if (tmpOpacity != null) {
            tmp = (int)(tmpOpacity * 100.0);
        }
        this.borderOpacitySpinner.setSelection(tmp);
        this.borderOpacitySpinner.addSelectionListener((SelectionListener)this);
        this.borderOpacityAttributecombo = new Combo(this.mainComposite, 12);
        this.borderOpacityAttributecombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.borderOpacityAttributecombo.setItems(this.numericAttributesArrays);
        this.borderOpacityAttributecombo.addSelectionListener((SelectionListener)this);
        this.borderOpacityAttributecombo.select(0);
        if (tmpOpacity == null && (index4 = this.getAttributeIndex(opacity, this.numericAttributesArrays)) != -1) {
            this.borderOpacityAttributecombo.select(index4);
        }
        Label borderColorLabel = new Label(this.mainComposite, 0);
        borderColorLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        borderColorLabel.setText(Messages.BoderParametersComposite_5);
        String color = lineSymbolizerWrapper.getStrokeColor();
        try {
            tmpColor = Color.decode(color);
        }
        catch (Exception exception) {
            tmpColor = Color.gray;
        }
        this.borderColorEditor = new StolenColorEditor(this.mainComposite, (SelectionListener)this);
        this.borderColorEditor.setColor(tmpColor);
        this.borderColorButton = this.borderColorEditor.getButton();
        GridData borderColorButtonSIMPLEGD = new GridData(4, 0x1000000, true, false);
        this.borderColorButton.setLayoutData((Object)borderColorButtonSIMPLEGD);
        this.borderColorAttributecombo = new Combo(this.mainComposite, 12);
        this.borderColorAttributecombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.borderColorAttributecombo.setItems(this.stringAttributesArrays);
        this.borderColorAttributecombo.addSelectionListener((SelectionListener)this);
        this.borderColorAttributecombo.select(0);
        if (tmpColor == null && (index3 = this.getAttributeIndex(color, this.stringAttributesArrays)) != -1) {
            this.borderColorAttributecombo.select(index3);
        }
        Label graphicsFillLabel = new Label(this.mainComposite, 16);
        graphicsFillLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        graphicsFillLabel.setText(Messages.BoderParametersComposite_6);
        Composite pathComposite = new Composite(this.mainComposite, 0);
        GridData pathCompositeGD = new GridData(4, 4, true, false);
        pathCompositeGD.horizontalSpan = 2;
        pathComposite.setLayoutData((Object)pathCompositeGD);
        GridLayout pathLayout = new GridLayout(2, false);
        pathLayout.marginWidth = 0;
        pathLayout.marginHeight = 0;
        pathComposite.setLayout((Layout)pathLayout);
        this.graphicsPathText = new Text(pathComposite, 18436);
        this.graphicsPathText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        try {
            this.graphicsPathText.setText(lineSymbolizerWrapper.getStrokeExternalGraphicStrokePath());
        }
        catch (MalformedURLException malformedURLException) {
            this.graphicsPathText.setText("");
        }
        this.graphicsPathText.addModifyListener((ModifyListener)this);
        Button pathButton = new Button(pathComposite, 8);
        pathButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        pathButton.setText("...");
        pathButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDialog = new FileDialog(BoderParametersComposite.this.graphicsPathText.getShell(), 4096);
                String path = fileDialog.open();
                if (path == null || path.length() < 1) {
                    BoderParametersComposite.this.graphicsPathText.setText("");
                } else {
                    BoderParametersComposite.this.graphicsPathText.setText(path);
                }
            }
        });
        Label dashLabel = new Label(this.mainComposite, 0);
        GridData dashLabelGD = new GridData(4, 0x1000000, true, false);
        dashLabel.setLayoutData((Object)dashLabelGD);
        dashLabel.setText(Messages.BoderParametersComposite_8);
        this.dashText = new Text(this.mainComposite, 18436);
        GridData dashGD = new GridData(4, 0x1000000, true, false);
        dashGD.horizontalSpan = 2;
        this.dashText.setLayoutData((Object)dashGD);
        String dash = lineSymbolizerWrapper.getDash();
        float[] dashArray = Utilities.getDash(dash);
        if (dashArray != null) {
            this.dashText.setText(dash);
        } else {
            this.dashText.setText("");
        }
        this.dashText.addModifyListener((ModifyListener)this);
        Label dashOffsetLabel = new Label(this.mainComposite, 0);
        GridData dashOffsetLabelGD = new GridData(4, 0x1000000, true, false);
        dashOffsetLabel.setLayoutData((Object)dashOffsetLabelGD);
        dashOffsetLabel.setText(Messages.BoderParametersComposite_9);
        this.dashOffsetText = new Text(this.mainComposite, 18436);
        GridData dashOffsetGD = new GridData(4, 0x1000000, true, false);
        dashOffsetGD.horizontalSpan = 2;
        this.dashOffsetText.setLayoutData((Object)dashOffsetGD);
        String dashOffset = lineSymbolizerWrapper.getDashOffset();
        Double dashOffsetFloat = this.isDouble(dashOffset);
        if (dashOffsetFloat != null) {
            this.dashOffsetText.setText(dashOffset);
        } else {
            this.dashOffsetText.setText("");
        }
        this.dashOffsetText.addModifyListener((ModifyListener)this);
        Label linCapLabel = new Label(this.mainComposite, 0);
        linCapLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        linCapLabel.setText(Messages.BoderParametersComposite_10);
        this.lineCapCombo = new Combo(this.mainComposite, 12);
        GridData lineCapGD = new GridData(4, 0x1000000, true, false);
        lineCapGD.horizontalSpan = 2;
        this.lineCapCombo.setLayoutData((Object)lineCapGD);
        this.lineCapCombo.setItems(Utilities.lineCapNames);
        this.lineCapCombo.addSelectionListener((SelectionListener)this);
        String lineCap = lineSymbolizerWrapper.getLineCap();
        if (lineCap != null && (index2 = this.getAttributeIndex(lineCap, Utilities.lineCapNames)) != -1) {
            this.lineCapCombo.select(index2);
        }
        Label linJoinLabel = new Label(this.mainComposite, 0);
        linJoinLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        linJoinLabel.setText(Messages.BoderParametersComposite_11);
        this.lineJoinCombo = new Combo(this.mainComposite, 12);
        GridData lineJoinGD = new GridData(4, 0x1000000, true, false);
        lineJoinGD.horizontalSpan = 2;
        this.lineJoinCombo.setLayoutData((Object)lineJoinGD);
        this.lineJoinCombo.setItems(Utilities.lineJoinNames);
        this.lineJoinCombo.addSelectionListener((SelectionListener)this);
        String lineJoin = lineSymbolizerWrapper.getLineJoin();
        if (lineJoin != null && (index = this.getAttributeIndex(lineJoin, Utilities.lineJoinNames)) != -1) {
            this.lineJoinCombo.select(index);
        }
        this.checkEnablements();
    }

    public void update(RuleWrapper ruleWrapper) {
        int index;
        String lineJoin;
        int index2;
        String dash;
        float[] dashArray;
        int index3;
        int index4;
        LineSymbolizerWrapper lineSymbolizerWrapper = ruleWrapper.getGeometrySymbolizersWrapper().adapt(LineSymbolizerWrapper.class);
        boolean widgetEnabled = lineSymbolizerWrapper.hasStroke();
        this.borderEnableButton.setSelection(widgetEnabled);
        String width = lineSymbolizerWrapper.getStrokeWidth();
        Double tmpWidth = this.isDouble(width);
        int tmp = 3;
        if (tmpWidth != null) {
            tmp = tmpWidth.intValue();
        }
        this.borderWidthSpinner.setSelection(tmp * 10);
        if (tmpWidth == null && (index4 = this.getAttributeIndex(width, this.numericAttributesArrays)) != -1) {
            this.borderWidthAttributecombo.select(index4);
        }
        String color = lineSymbolizerWrapper.getStrokeColor();
        Color tmpColor = null;
        try {
            tmpColor = Color.decode(color);
        }
        catch (Exception exception) {}
        if (tmpColor != null) {
            this.borderColorEditor.setColor(tmpColor);
        } else {
            int index5 = this.getAttributeIndex(color, this.stringAttributesArrays);
            if (index5 != -1) {
                this.borderColorAttributecombo.select(index5);
            }
        }
        try {
            this.graphicsPathText.setText(lineSymbolizerWrapper.getStrokeExternalGraphicStrokePath());
        }
        catch (MalformedURLException malformedURLException) {
            this.graphicsPathText.setText("");
        }
        String opacity = lineSymbolizerWrapper.getStrokeOpacity();
        Double tmpOpacity = this.isDouble(opacity);
        tmp = 100;
        if (tmpOpacity != null) {
            tmp = (int)(tmpOpacity * 100.0);
        }
        this.borderOpacitySpinner.setSelection(tmp);
        if (tmpOpacity == null && (index3 = this.getAttributeIndex(opacity, this.numericAttributesArrays)) != -1) {
            this.borderOpacityAttributecombo.select(index3);
        }
        if ((dashArray = Utilities.getDash(dash = lineSymbolizerWrapper.getDash())) != null) {
            this.dashText.setText(dash);
        } else {
            this.dashText.setText("");
        }
        String dashOffset = lineSymbolizerWrapper.getDashOffset();
        Double dashOffsetDouble = this.isDouble(dashOffset);
        if (dashOffsetDouble != null) {
            this.dashOffsetText.setText(dashOffset);
        } else {
            this.dashOffsetText.setText("");
        }
        String lineCap = lineSymbolizerWrapper.getLineCap();
        if (lineCap != null && (index2 = this.getAttributeIndex(lineCap, Utilities.lineCapNames)) != -1) {
            this.lineCapCombo.select(index2);
        }
        if ((lineJoin = lineSymbolizerWrapper.getLineJoin()) != null && (index = this.getAttributeIndex(lineJoin, Utilities.lineJoinNames)) != -1) {
            this.lineJoinCombo.select(index);
        }
        this.checkEnablements();
    }

    private void checkEnablements() {
        boolean comboIsNone = this.comboIsNone(this.borderOpacityAttributecombo);
        this.borderOpacitySpinner.setEnabled(comboIsNone);
        comboIsNone = this.comboIsNone(this.borderWidthAttributecombo);
        this.borderWidthSpinner.setEnabled(comboIsNone);
        comboIsNone = this.comboIsNone(this.borderColorAttributecombo);
        this.borderColorEditor.setEnabled(comboIsNone);
    }

    public void widgetSelected(SelectionEvent e) {
        Object source = e.getSource();
        if (source.equals(this.borderEnableButton)) {
            boolean selected = this.borderEnableButton.getSelection();
            this.notifyListeners(String.valueOf(selected), false, IStyleChangesListener.STYLEEVENTTYPE.BORDERENABLE);
        } else if (source.equals(this.borderWidthSpinner) || source.equals(this.borderWidthAttributecombo)) {
            boolean comboIsNone = this.comboIsNone(this.borderWidthAttributecombo);
            if (comboIsNone) {
                int selection = this.borderWidthSpinner.getSelection();
                int digits = this.borderWidthSpinner.getDigits();
                double value = (double)selection / Math.pow(10.0, digits);
                String strokeWidth = String.valueOf(value);
                this.notifyListeners(strokeWidth, false, IStyleChangesListener.STYLEEVENTTYPE.BORDERWIDTH);
            } else {
                int index = this.borderWidthAttributecombo.getSelectionIndex();
                String field = this.borderWidthAttributecombo.getItem(index);
                if (field.length() == 0) {
                    return;
                }
                this.notifyListeners(field, true, IStyleChangesListener.STYLEEVENTTYPE.BORDERWIDTH);
            }
        } else if (source.equals(this.borderColorButton) || source.equals(this.borderColorAttributecombo)) {
            boolean comboIsNone = this.comboIsNone(this.borderColorAttributecombo);
            if (comboIsNone) {
                Color color = this.borderColorEditor.getColor();
                Literal colorExpr = Utilities.ff.literal((Object)color);
                String strokeColor = (String)colorExpr.evaluate(null, String.class);
                this.notifyListeners(strokeColor, false, IStyleChangesListener.STYLEEVENTTYPE.BORDERCOLOR);
            } else {
                int index = this.borderColorAttributecombo.getSelectionIndex();
                String field = this.borderColorAttributecombo.getItem(index);
                if (field.length() == 0) {
                    return;
                }
                this.notifyListeners(field, true, IStyleChangesListener.STYLEEVENTTYPE.BORDERCOLOR);
            }
        } else if (source.equals(this.borderOpacitySpinner) || source.equals(this.borderOpacityAttributecombo)) {
            boolean comboIsNone = this.comboIsNone(this.borderOpacityAttributecombo);
            if (comboIsNone) {
                int opacity = this.borderOpacitySpinner.getSelection();
                float opacityNorm = (float)opacity / 100.0f;
                String strokeOpacity = String.valueOf(opacityNorm);
                this.notifyListeners(strokeOpacity, false, IStyleChangesListener.STYLEEVENTTYPE.BORDEROPACITY);
            } else {
                int index = this.borderOpacityAttributecombo.getSelectionIndex();
                String field = this.borderOpacityAttributecombo.getItem(index);
                if (field.length() == 0) {
                    return;
                }
                this.notifyListeners(field, true, IStyleChangesListener.STYLEEVENTTYPE.BORDEROPACITY);
            }
        } else if (source.equals(this.lineCapCombo)) {
            int index = this.lineCapCombo.getSelectionIndex();
            String item = this.lineCapCombo.getItem(index);
            if (item.length() == 0) {
                return;
            }
            this.notifyListeners(item, true, IStyleChangesListener.STYLEEVENTTYPE.LINECAP);
        } else if (source.equals(this.lineJoinCombo)) {
            int index = this.lineJoinCombo.getSelectionIndex();
            String item = this.lineJoinCombo.getItem(index);
            if (item.length() == 0) {
                return;
            }
            this.notifyListeners(item, true, IStyleChangesListener.STYLEEVENTTYPE.LINEJOIN);
        }
        this.checkEnablements();
    }

    public void modifyText(ModifyEvent e) {
        Object source = e.getSource();
        if (source.equals(this.graphicsPathText)) {
            try {
                String text = this.graphicsPathText.getText();
                File graphicsFile = new File(text);
                if (graphicsFile.exists() || text.toLowerCase().startsWith("http")) {
                    text = graphicsFile.toURI().toURL().toExternalForm();
                    String strokeWidth = String.valueOf(1);
                    String strokeSize = String.valueOf(15);
                    this.notifyListeners(new String[]{text, strokeWidth, strokeSize}, false, IStyleChangesListener.STYLEEVENTTYPE.GRAPHICSPATHBORDER);
                }
            }
            catch (MalformedURLException e1) {
                e1.printStackTrace();
            }
        } else if (source.equals(this.dashText)) {
            String text = this.dashText.getText();
            float[] dash = Utilities.getDash(text);
            if (dash == null) {
                return;
            }
            this.notifyListeners(new String[]{text}, false, IStyleChangesListener.STYLEEVENTTYPE.DASH);
        } else if (source.equals(this.dashOffsetText)) {
            String text = this.dashOffsetText.getText();
            this.notifyListeners(new String[]{text}, false, IStyleChangesListener.STYLEEVENTTYPE.DASHOFFSET);
        }
    }
}

