/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.omsbox.view.widgets;

import eu.udig.omsbox.core.ModuleDescription;
import eu.udig.omsbox.view.widgets.ModuleGui;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;

public class MultipleModuleDescriptionDialog {
    private static final int DIALOG_WIDTH = 500;
    private Dialog dialog;
    private Composite parentPanel;
    private final List<ModuleDescription> moduleDescriptions;
    private ModuleDescription currentModuleDescription;
    private StackLayout stackLayout;
    private Combo namesCombo;
    private Composite moduleComposite;
    private String title = "";
    private ModuleDescription lastUsedModuleDescription;

    public MultipleModuleDescriptionDialog(String title, List<ModuleDescription> moduleDescriptions) {
        this.moduleDescriptions = moduleDescriptions;
        if (title != null) {
            this.title = title;
        }
        this.lastUsedModuleDescription = null;
    }

    public void setLastUsedModuleDescription(ModuleDescription moduleDescription) {
        this.lastUsedModuleDescription = moduleDescription;
    }

    public void open(Shell parentShell) {
        this.dialog = new Dialog(parentShell){

            protected void configureShell(Shell shell) {
                super.configureShell(shell);
                shell.setText(MultipleModuleDescriptionDialog.this.title);
                shell.setSize(500, 700);
                Monitor primary = Display.getDefault().getPrimaryMonitor();
                Rectangle bounds = primary.getBounds();
                Rectangle rect = shell.getBounds();
                int x = bounds.x + (bounds.width - rect.width) / 2;
                int y = bounds.y + (bounds.height - rect.height) / 2;
                shell.setLocation(x, y);
            }

            protected int getShellStyle() {
                return 2160;
            }

            protected Control createDialogArea(Composite parent) {
                MultipleModuleDescriptionDialog.this.parentPanel = (Composite)super.createDialogArea(parent);
                MultipleModuleDescriptionDialog.this.parentPanel.setLayout((Layout)new GridLayout(1, false));
                MultipleModuleDescriptionDialog.this.parentPanel.setLayoutData((Object)new GridData(4, 4, true, true));
                String[] names = new String[MultipleModuleDescriptionDialog.this.moduleDescriptions.size()];
                int i = 0;
                while (i < names.length) {
                    names[i] = ((ModuleDescription)MultipleModuleDescriptionDialog.this.moduleDescriptions.get(i)).getName();
                    ++i;
                }
                MultipleModuleDescriptionDialog.this.namesCombo = new Combo(MultipleModuleDescriptionDialog.this.parentPanel, 12);
                MultipleModuleDescriptionDialog.this.namesCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
                MultipleModuleDescriptionDialog.this.namesCombo.setItems(names);
                if (MultipleModuleDescriptionDialog.this.lastUsedModuleDescription != null) {
                    int j = 0;
                    while (j < MultipleModuleDescriptionDialog.this.moduleDescriptions.size()) {
                        if (((ModuleDescription)MultipleModuleDescriptionDialog.this.moduleDescriptions.get(j)).getClassName().equals(MultipleModuleDescriptionDialog.this.lastUsedModuleDescription.getClassName())) {
                            MultipleModuleDescriptionDialog.this.namesCombo.select(j);
                        }
                        ++j;
                    }
                } else {
                    MultipleModuleDescriptionDialog.this.namesCombo.select(0);
                }
                MultipleModuleDescriptionDialog.this.namesCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        MultipleModuleDescriptionDialog.this.setGui();
                    }
                });
                MultipleModuleDescriptionDialog.this.moduleComposite = new Composite(MultipleModuleDescriptionDialog.this.parentPanel, 0);
                MultipleModuleDescriptionDialog.this.moduleComposite.setLayoutData((Object)new GridData(4, 4, true, true));
                MultipleModuleDescriptionDialog.this.stackLayout = new StackLayout();
                MultipleModuleDescriptionDialog.this.moduleComposite.setLayout((Layout)MultipleModuleDescriptionDialog.this.stackLayout);
                MultipleModuleDescriptionDialog.this.setGui();
                return MultipleModuleDescriptionDialog.this.parentPanel;
            }

            protected void buttonPressed(int buttonId) {
                if (buttonId == 1) {
                    MultipleModuleDescriptionDialog.this.currentModuleDescription = null;
                }
                super.buttonPressed(buttonId);
            }
        };
        this.dialog.setBlockOnOpen(true);
        this.dialog.open();
    }

    private void setGui() {
        String text = this.namesCombo.getText();
        int i = 0;
        while (i < this.moduleDescriptions.size()) {
            if (this.moduleDescriptions.get(i).getName().equals(text)) {
                this.currentModuleDescription = this.moduleDescriptions.get(i);
                break;
            }
            ++i;
        }
        Composite tmpComposite = new Composite(this.moduleComposite, 0);
        tmpComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        tmpComposite.setLayout((Layout)new GridLayout(1, false));
        ModuleGui moduleGui = new ModuleGui(this.currentModuleDescription);
        moduleGui.makeGui(tmpComposite, true);
        this.stackLayout.topControl = tmpComposite;
        this.moduleComposite.layout();
    }

    public ModuleDescription getModuleDescription() {
        return this.currentModuleDescription;
    }
}

