/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.omsbox.view.widgets;

import eu.udig.omsbox.OmsBoxPlugin;
import eu.udig.omsbox.core.FieldData;
import eu.udig.omsbox.core.ModuleDescription;
import eu.udig.omsbox.utils.OmsBoxUtils;
import eu.udig.omsbox.view.widgets.ModuleGuiElement;
import eu.udig.omsbox.view.widgets.ModuleGuiFactory;
import java.util.ArrayList;
import java.util.List;
import net.miginfocom.swt.MigLayout;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ModuleGui {
    private final ModuleDescription mainModuleDescription;
    private ModuleGuiFactory formGuiFactory = new ModuleGuiFactory();
    private List<ModuleGuiElement> modulesOuputGuiList;
    private List<ModuleGuiElement> modulesInputGuiList;
    private boolean hideComplex;

    public ModuleGui(ModuleDescription mainModuleDescription) {
        this.mainModuleDescription = mainModuleDescription;
    }

    public Control makeGui(Composite parent, boolean hideComplex) {
        this.hideComplex = hideComplex;
        this.modulesInputGuiList = new ArrayList<ModuleGuiElement>();
        this.modulesOuputGuiList = new ArrayList<ModuleGuiElement>();
        CTabFolder folder = new CTabFolder(parent, 1024);
        folder.setUnselectedCloseVisible(false);
        folder.setLayout((Layout)new FillLayout());
        folder.setLayoutData((Object)new GridData(4, 4, true, true));
        String layoutConstraint = "insets 20 20 20 20, fillx";
        this.makeInputTab(folder, layoutConstraint);
        this.makeOutputTab(folder, layoutConstraint);
        this.makeDescription(folder, layoutConstraint);
        return folder;
    }

    private void makeDescription(CTabFolder folder, String layoutConstraint) {
        CTabItem tab = new CTabItem(folder, 0);
        tab.setText("description");
        try {
            Browser browser = new Browser((Composite)folder, 0);
            GridData layoutData = new GridData(1808);
            browser.setLayoutData((Object)layoutData);
            String className = this.mainModuleDescription.getClassName();
            String moduleDocumentationPath = OmsBoxUtils.getModuleDocumentationPath(className);
            browser.setUrl("file:" + moduleDocumentationPath);
            tab.setControl((Control)browser);
        }
        catch (SWTError e) {
            e.printStackTrace();
            Label problemLabel = new Label((Composite)folder, 0);
            problemLabel.setLayoutData((Object)new GridData(4, 4, true, true));
            problemLabel.setText("An error occurred while loading the documentation.");
            tab.setControl((Control)problemLabel);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void makeInputTab(CTabFolder folder, String layoutConstraint) {
        List<FieldData> inputsList = this.mainModuleDescription.getInputsList();
        if (inputsList.size() == 0) {
            return;
        }
        if (this.hideComplex) {
            boolean oneNotComplex = false;
            for (FieldData fieldData : inputsList) {
                if (!fieldData.isSimpleType()) continue;
                oneNotComplex = true;
            }
            if (!oneNotComplex) {
                return;
            }
        }
        CTabItem tab = new CTabItem(folder, 0);
        tab.setText("inputs");
        folder.setSelection(tab);
        ScrolledComposite scroller = new ScrolledComposite((Composite)folder, 512);
        scroller.setLayout((Layout)new FillLayout());
        Composite tabComposite = new Composite((Composite)scroller, 0);
        layoutConstraint = String.valueOf(layoutConstraint) + ", gapy 15";
        tabComposite.setLayout((Layout)new MigLayout(layoutConstraint, ""));
        scroller.setContent((Control)tabComposite);
        scroller.setExpandVertical(true);
        scroller.setExpandHorizontal(true);
        tab.setControl((Control)scroller);
        int[] row = new int[1];
        int j = 0;
        while (j < inputsList.size()) {
            FieldData inputData = inputsList.get(j);
            if (!(this.hideComplex && !inputData.isSimpleType() && !OmsBoxUtils.isFieldExceptional(inputData) || inputData.isProcessingRegionRelated() && OmsBoxPlugin.getDefault().doIgnoreProcessingRegion())) {
                List<ModuleGuiElement> inputList = this.formGuiFactory.createInputGui(inputData, row);
                for (ModuleGuiElement moduleGuiElement : inputList) {
                    moduleGuiElement.makeGui(tabComposite);
                }
                this.modulesInputGuiList.addAll(inputList);
                row[0] = row[0] + 1;
            }
            ++j;
        }
        Point size = folder.computeSize(-1, -1);
        scroller.setMinHeight(size.y);
        scroller.setMinWidth(size.x);
    }

    private void makeOutputTab(CTabFolder folder, String layoutConstraint) {
        List<FieldData> outputsList = this.mainModuleDescription.getOutputsList();
        if (outputsList.size() == 0) {
            return;
        }
        boolean atLeastOneIsSimple = false;
        boolean atLeastOneIsSimpleArray = false;
        boolean atLeastOneIsComplex = false;
        for (FieldData fieldData : outputsList) {
            if (fieldData.isSimpleType()) {
                atLeastOneIsSimple = true;
                continue;
            }
            if (fieldData.isSimpleArrayType()) {
                atLeastOneIsSimpleArray = true;
                continue;
            }
            atLeastOneIsComplex = true;
        }
        if (this.hideComplex && !atLeastOneIsSimple && atLeastOneIsComplex) {
            return;
        }
        if ((atLeastOneIsSimple || atLeastOneIsSimpleArray) && !atLeastOneIsComplex) {
            return;
        }
        CTabItem tab = new CTabItem(folder, 0);
        tab.setText("outputs");
        ScrolledComposite scroller = new ScrolledComposite((Composite)folder, 512);
        scroller.setLayout((Layout)new FillLayout());
        Composite tabComposite = new Composite((Composite)scroller, 0);
        tabComposite.setLayout((Layout)new MigLayout(layoutConstraint, ""));
        scroller.setContent((Control)tabComposite);
        scroller.setExpandVertical(true);
        scroller.setExpandHorizontal(true);
        tab.setControl((Control)scroller);
        int[] row = new int[1];
        int j = 0;
        while (j < outputsList.size()) {
            FieldData outputData = outputsList.get(j);
            if (!(this.hideComplex && !outputData.isSimpleType() || outputData.isProcessingRegionRelated() && OmsBoxPlugin.getDefault().doIgnoreProcessingRegion())) {
                List<ModuleGuiElement> ouputList = this.formGuiFactory.createOutputGui(outputData, row);
                for (ModuleGuiElement moduleGuiElement : ouputList) {
                    moduleGuiElement.makeGui(tabComposite);
                }
                this.modulesOuputGuiList.addAll(ouputList);
                row[0] = row[0] + 1;
            }
            ++j;
        }
        Point size = folder.computeSize(-1, -1);
        scroller.setMinHeight(size.y);
        scroller.setMinWidth(size.x);
    }

    public ModuleDescription getModuleDescription() {
        return this.mainModuleDescription;
    }

    public List<ModuleGuiElement> getModulesInputGuiList() {
        return this.modulesInputGuiList;
    }

    public List<ModuleGuiElement> getModulesOuputGuiList() {
        return this.modulesOuputGuiList;
    }
}

