/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.omsbox.view.widgets;

import com.vividsolutions.jts.geom.Coordinate;
import eu.udig.omsbox.OmsBoxPlugin;
import eu.udig.omsbox.core.FieldData;
import eu.udig.omsbox.processingregion.ProcessingRegion;
import eu.udig.omsbox.processingregion.ProcessingRegionStyle;
import eu.udig.omsbox.utils.MapcalculatorUtils;
import eu.udig.omsbox.utils.OmsBoxUtils;
import eu.udig.omsbox.view.widgets.ModuleGuiElement;
import java.awt.Point;
import java.io.File;
import java.net.URL;
import java.text.MessageFormat;
import java.util.List;
import net.refractions.udig.catalog.ID;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.internal.ui.UDigByteAndLocalTransfer;
import net.refractions.udig.project.BlackboardEvent;
import net.refractions.udig.project.IBlackboard;
import net.refractions.udig.project.IBlackboardListener;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.IStyleBlackboard;
import net.refractions.udig.project.internal.impl.LayerImpl;
import net.refractions.udig.project.render.IRenderManager;
import net.refractions.udig.project.ui.ApplicationGIS;
import net.refractions.udig.project.ui.render.displayAdapter.MapMouseEvent;
import net.refractions.udig.project.ui.render.displayAdapter.MapMouseListener;
import net.refractions.udig.project.ui.render.displayAdapter.ViewportPane;
import net.refractions.udig.ui.CRSChooser;
import net.refractions.udig.ui.Controller;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.URLTransfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class GuiTextField
extends ModuleGuiElement
implements ModifyListener,
FocusListener {
    private StyledText text;
    private String constraints;
    private final FieldData data;
    private boolean isInFile;
    private boolean isInFolder;
    private boolean isOutFile;
    private boolean isOutFolder;
    private boolean isCrs;
    private boolean isEastingNorthing;
    private boolean isNorthing;
    private boolean isEasting;
    private boolean isMultiline;
    private boolean isProcessingNorth;
    private boolean isProcessingSouth;
    private boolean isProcessingWest;
    private boolean isProcessingEast;
    private boolean isProcessingCols;
    private boolean isProcessingRows;
    private boolean isProcessingXres;
    private boolean isProcessingYres;
    private boolean isMapcalc;
    private boolean isGrassfile;
    private MapMouseListener currentMapMouseListener;
    private IBlackboardListener currentBlackboardListener;
    private int rows;

    public GuiTextField(FieldData data, String constraints) {
        this.data = data;
        this.constraints = constraints;
        if (data.guiHints != null) {
            if (data.guiHints.contains("infile")) {
                this.isInFile = true;
            }
            if (data.guiHints.contains("infolder")) {
                this.isInFolder = true;
            }
            if (data.guiHints.contains("outfile")) {
                this.isOutFile = true;
            }
            if (data.guiHints.contains("outfolder")) {
                this.isOutFolder = true;
            }
            if (data.guiHints.contains("crs")) {
                this.isCrs = true;
            }
            if (data.guiHints.contains("eastnorth")) {
                this.isEastingNorthing = true;
            } else if (data.guiHints.contains("northing")) {
                this.isNorthing = true;
            } else if (data.guiHints.contains("easting")) {
                this.isEasting = true;
            }
            if (data.guiHints.contains("multiline")) {
                String[] split;
                this.isMultiline = true;
                String[] stringArray = split = data.guiHints.split(",");
                int n = split.length;
                int n2 = 0;
                while (n2 < n) {
                    String string = stringArray[n2];
                    String hint = string.trim();
                    if (hint.startsWith("multiline")) {
                        hint = hint.replaceFirst("multiline", "");
                        this.rows = 1;
                        try {
                            this.rows = Integer.parseInt(hint);
                        }
                        catch (Exception exception) {}
                    }
                    ++n2;
                }
            }
            if (data.guiHints.contains("mapcalc")) {
                this.isMapcalc = true;
            }
            if (data.guiHints.contains("grassfile")) {
                this.isGrassfile = true;
            }
            if (data.guiHints.contains("process_north")) {
                this.isProcessingNorth = true;
            } else if (data.guiHints.contains("process_south")) {
                this.isProcessingSouth = true;
            } else if (data.guiHints.contains("process_west")) {
                this.isProcessingWest = true;
            } else if (data.guiHints.contains("process_east")) {
                this.isProcessingEast = true;
            } else if (data.guiHints.contains("process_cols")) {
                this.isProcessingCols = true;
            } else if (data.guiHints.contains("process_rows")) {
                this.isProcessingRows = true;
            } else if (data.guiHints.contains("process_xres")) {
                this.isProcessingXres = true;
            } else if (data.guiHints.contains("process_yres")) {
                this.isProcessingYres = true;
            }
        }
    }

    @Override
    public Control makeGui(Composite parent) {
        GridData textGD;
        int cols = 1;
        if (this.isInFile || this.isInFolder || this.isOutFile || this.isOutFolder || this.isCrs || this.isMultiline) {
            cols = 2;
        }
        final boolean isFile = this.isInFile || this.isOutFile;
        boolean isFolder = this.isInFolder || this.isOutFolder;
        parent = new Composite(parent, 0);
        parent.setLayoutData((Object)this.constraints);
        GridLayout layout = new GridLayout(cols, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        parent.setLayout((Layout)layout);
        if (!this.isMultiline) {
            this.text = new StyledText(parent, 133120);
            textGD = new GridData(4, 0x1000000, true, false);
            textGD.widthHint = 100;
            this.text.setLayoutData((Object)textGD);
        } else if (this.isMapcalc) {
            this.text = MapcalculatorUtils.createMapcalcPanel(parent, this.rows);
        } else {
            this.text = new StyledText(parent, 19010);
            textGD = new GridData(4, 0x1000000, true, true);
            textGD.verticalSpan = this.rows;
            textGD.widthHint = 100;
            this.text.setLayoutData((Object)textGD);
        }
        this.text.addModifyListener((ModifyListener)this);
        this.text.addFocusListener((FocusListener)this);
        if (this.data.fieldValue != null) {
            String tmp = this.data.fieldValue;
            if (tmp.contains("@@@WORKINGFOLDER@@@")) {
                String workingFolder = OmsBoxPlugin.getDefault().getWorkingFolder();
                this.data.fieldValue = (workingFolder = this.checkBackSlash(workingFolder, true)) != null ? (tmp = tmp.replaceFirst("@@@WORKINGFOLDER@@@", workingFolder)) : "";
            }
            this.data.fieldValue = this.checkBackSlash(this.data.fieldValue, isFile);
            this.text.setText(this.data.fieldValue);
        }
        if (this.isMultiline) {
            int i = 0;
            while (i < this.rows) {
                Label dummyLabel = new Label(parent, 0);
                dummyLabel.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
                ++i;
            }
        }
        if (isFile) {
            Button browseButton = new Button(parent, 8);
            browseButton.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
            browseButton.setText("...");
            browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FileDialog fileDialog = new FileDialog(GuiTextField.this.text.getShell(), GuiTextField.this.isInFile ? 4096 : 8192);
                    String lastFolderChosen = OmsBoxPlugin.getDefault().getLastFolderChosen();
                    fileDialog.setFilterPath(lastFolderChosen);
                    String path = fileDialog.open();
                    if (path == null || path.length() < 1) {
                        GuiTextField.this.text.setText("");
                    } else {
                        path = GuiTextField.this.checkBackSlash(path, isFile);
                        GuiTextField.this.text.setText(path);
                        GuiTextField.this.text.setSelection(GuiTextField.this.text.getCharCount());
                        GuiTextField.this.setDataValue();
                    }
                    OmsBoxPlugin.getDefault().setLastFolderChosen(fileDialog.getFilterPath());
                }
            });
        }
        if (isFolder) {
            Button browseButton = new Button(parent, 8);
            browseButton.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
            browseButton.setText("...");
            browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DirectoryDialog directoryDialog = new DirectoryDialog(GuiTextField.this.text.getShell(), GuiTextField.this.isInFolder ? 4096 : 8192);
                    String lastFolderChosen = OmsBoxPlugin.getDefault().getLastFolderChosen();
                    directoryDialog.setFilterPath(lastFolderChosen);
                    String path = directoryDialog.open();
                    if (path == null || path.length() < 1) {
                        GuiTextField.this.text.setText("");
                    } else {
                        path = GuiTextField.this.checkBackSlash(path, isFile);
                        GuiTextField.this.text.setText(path);
                        GuiTextField.this.setDataValue();
                    }
                    OmsBoxPlugin.getDefault().setLastFolderChosen(directoryDialog.getFilterPath());
                }
            });
        }
        if (this.isCrs) {
            Button crsButton = new Button(parent, 2048);
            crsButton.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
            crsButton.setText("...");
            crsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Shell shell = new Shell(GuiTextField.this.text.getShell(), 1264);
                    Dialog dialog = new Dialog(shell){
                        private CRSChooser chooser;
                        private CoordinateReferenceSystem crs;

                        protected void configureShell(Shell shell) {
                            super.configureShell(shell);
                            shell.setText("Choose CRS");
                        }

                        protected Control createDialogArea(Composite parent) {
                            Composite comp = (Composite)super.createDialogArea(parent);
                            GridLayout gLayout = (GridLayout)comp.getLayout();
                            gLayout.numColumns = 1;
                            this.chooser = new CRSChooser(new Controller(){

                                public void handleClose() {
                                    this.buttonPressed(0);
                                }

                                public void handleOk() {
                                    this.buttonPressed(0);
                                }
                            });
                            return this.chooser.createControl(parent);
                        }

                        protected void buttonPressed(int buttonId) {
                            if (buttonId == 0) {
                                this.crs = this.chooser.getCRS();
                                try {
                                    String codeFromCrs = OmsBoxUtils.getCodeFromCrs(this.crs);
                                    GuiTextField.this.text.setText(codeFromCrs);
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                            this.close();
                        }
                    };
                    dialog.setBlockOnOpen(true);
                    dialog.open();
                }
            });
            IMap activeMap = ApplicationGIS.getActiveMap();
            if (activeMap != null) {
                try {
                    CoordinateReferenceSystem crs = activeMap.getViewportModel().getCRS();
                    String codeFromCrs = OmsBoxUtils.getCodeFromCrs(crs);
                    this.text.setText(codeFromCrs);
                    this.setDataValue();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (this.isNorthing || this.isEasting || this.isEastingNorthing) {
            this.addMapMouseListener();
        }
        if (this.isProcessing()) {
            this.addRegionListener();
            ILayer processingRegionLayer = OmsBoxPlugin.getDefault().getProcessingRegionMapGraphic();
            IStyleBlackboard blackboard = processingRegionLayer.getStyleBlackboard();
            Object object = blackboard.get("eu.udig.omsbox.processingregion.ProcessingRegionStyleContent");
            if (object instanceof ProcessingRegionStyle) {
                ProcessingRegionStyle processingStyle = (ProcessingRegionStyle)object;
                this.setRegion(processingStyle);
            }
        }
        this.text.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (GuiTextField.this.isNorthing || GuiTextField.this.isEasting || GuiTextField.this.isEastingNorthing) {
                    GuiTextField.this.removeMapMouseListener();
                }
                if (GuiTextField.this.isProcessing()) {
                    GuiTextField.this.removeRegionListener();
                }
            }
        });
        this.addDrop();
        return this.text;
    }

    @Override
    public FieldData getFieldData() {
        if (this.isMapcalc) {
            MapcalculatorUtils.saveMapcalcHistory(this.text.getText());
        }
        return this.data;
    }

    private void setDataValue() {
        String textStr = this.text.getText();
        boolean isFile = this.isInFile || this.isOutFile;
        this.data.fieldValue = textStr = this.checkBackSlash(textStr, isFile);
    }

    @Override
    public boolean hasData() {
        return true;
    }

    public void modifyText(ModifyEvent e) {
        this.setDataValue();
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        this.setDataValue();
    }

    private void removeMapMouseListener() {
        if (this.currentMapMouseListener != null) {
            IMap activeMap = ApplicationGIS.getActiveMap();
            IRenderManager renderManager = activeMap.getRenderManager();
            ViewportPane viewportPane = (ViewportPane)renderManager.getMapDisplay();
            viewportPane.removeMouseListener(this.currentMapMouseListener);
        }
    }

    private void addMapMouseListener() {
        final IMap activeMap = ApplicationGIS.getActiveMap();
        if (activeMap == null) {
            return;
        }
        IRenderManager renderManager = activeMap.getRenderManager();
        if (renderManager == null) {
            return;
        }
        ViewportPane viewportPane = (ViewportPane)renderManager.getMapDisplay();
        if (viewportPane == null) {
            return;
        }
        this.currentMapMouseListener = new MapMouseListener(){

            public void mouseReleased(MapMouseEvent event) {
                Point point = event.getPoint();
                Coordinate worldClick = activeMap.getViewportModel().pixelToWorld(point.x, point.y);
                if (GuiTextField.this.isEastingNorthing) {
                    GuiTextField.this.text.setText(String.valueOf(String.valueOf(worldClick.x)) + "," + String.valueOf(worldClick.y));
                }
                if (GuiTextField.this.isNorthing) {
                    GuiTextField.this.text.setText(String.valueOf(worldClick.y));
                }
                if (GuiTextField.this.isEasting) {
                    GuiTextField.this.text.setText(String.valueOf(worldClick.x));
                }
            }

            public void mousePressed(MapMouseEvent event) {
            }

            public void mouseExited(MapMouseEvent event) {
            }

            public void mouseEntered(MapMouseEvent event) {
            }

            public void mouseDoubleClicked(MapMouseEvent event) {
            }
        };
        viewportPane.addMouseListener(this.currentMapMouseListener);
    }

    private void removeRegionListener() {
        if (this.currentBlackboardListener != null) {
            ILayer processingRegionLayer = OmsBoxPlugin.getDefault().getProcessingRegionMapGraphic();
            IStyleBlackboard blackboard = processingRegionLayer.getStyleBlackboard();
            blackboard.removeListener(this.currentBlackboardListener);
        }
    }

    private void addRegionListener() {
        ILayer processingRegionLayer = OmsBoxPlugin.getDefault().getProcessingRegionMapGraphic();
        IStyleBlackboard blackboard = processingRegionLayer.getStyleBlackboard();
        this.currentBlackboardListener = new IBlackboardListener(){

            public void blackBoardCleared(IBlackboard source) {
            }

            public void blackBoardChanged(BlackboardEvent event) {
                Object newValue;
                Object key = event.getKey();
                if (key.equals("eu.udig.omsbox.processingregion.ProcessingRegionStyleContent") && (newValue = event.getNewValue()) instanceof ProcessingRegionStyle) {
                    ProcessingRegionStyle processingStyle = (ProcessingRegionStyle)newValue;
                    GuiTextField.this.setRegion(processingStyle);
                }
            }
        };
        blackboard.addListener(this.currentBlackboardListener);
    }

    private void setRegion(ProcessingRegionStyle processingStyle) {
        ProcessingRegion region = new ProcessingRegion(processingStyle.west, processingStyle.east, processingStyle.south, processingStyle.north, processingStyle.rows, processingStyle.cols);
        if (this.isProcessingNorth) {
            this.text.setText(String.valueOf(processingStyle.north));
        } else if (this.isProcessingSouth) {
            this.text.setText(String.valueOf(processingStyle.south));
        } else if (this.isProcessingWest) {
            this.text.setText(String.valueOf(processingStyle.west));
        } else if (this.isProcessingEast) {
            this.text.setText(String.valueOf(processingStyle.east));
        } else if (this.isProcessingCols) {
            this.text.setText(String.valueOf(processingStyle.cols));
        } else if (this.isProcessingRows) {
            this.text.setText(String.valueOf(processingStyle.rows));
        } else if (this.isProcessingXres) {
            this.text.setText(String.valueOf(region.getWEResolution()));
        } else if (this.isProcessingYres) {
            this.text.setText(String.valueOf(region.getNSResolution()));
        }
    }

    private boolean isProcessing() {
        return this.isProcessingNorth || this.isProcessingSouth || this.isProcessingEast || this.isProcessingWest || this.isProcessingCols || this.isProcessingRows || this.isProcessingXres || this.isProcessingYres;
    }

    private void addDrop() {
        int operations = 19;
        DropTarget target = new DropTarget((Control)this.text, operations);
        final TextTransfer textTransfer = TextTransfer.getInstance();
        final FileTransfer fileTransfer = FileTransfer.getInstance();
        final URLTransfer urlTransfer = URLTransfer.getInstance();
        final UDigByteAndLocalTransfer omsboxTransfer = UDigByteAndLocalTransfer.getInstance();
        Transfer[] types = new Transfer[]{fileTransfer, textTransfer, urlTransfer, omsboxTransfer};
        target.setTransfer(types);
        target.addDropListener(new DropTargetListener(){

            public void drop(DropTargetEvent event) {
                File file;
                String[] files;
                if (textTransfer.isSupportedType(event.currentDataType)) {
                    String text = (String)event.data;
                    System.out.println(text);
                }
                if (fileTransfer.isSupportedType(event.currentDataType) && (files = (String[])event.data).length > 0 && (file = new File(files[0])).exists()) {
                    GuiTextField.this.setTextContent(file);
                    OmsBoxPlugin.getDefault().setLastFolderChosen(file.getParentFile().getAbsolutePath());
                }
                if (urlTransfer.isSupportedType(event.currentDataType)) {
                    Object data2 = event.data;
                    System.out.println(data2);
                }
                if (omsboxTransfer.isSupportedType(event.currentDataType)) {
                    try {
                        Object data = event.data;
                        if (data instanceof TreeSelection) {
                            ID id;
                            IService service;
                            List resources;
                            TreeSelection selection = (TreeSelection)data;
                            Object firstElement = selection.getFirstElement();
                            IGeoResource geoResource = null;
                            if (firstElement instanceof LayerImpl) {
                                LayerImpl layer = (LayerImpl)firstElement;
                                geoResource = layer.getGeoResource();
                            }
                            if (firstElement instanceof IService && (resources = (service = (IService)firstElement).resources((IProgressMonitor)new NullProgressMonitor())).size() > 0) {
                                geoResource = (IGeoResource)resources.get(0);
                            }
                            if (geoResource != null && (id = geoResource.getID()) != null) {
                                if (id.isFile()) {
                                    File file2 = id.toFile();
                                    if (file2.exists()) {
                                        GuiTextField.this.setTextContent(file2);
                                        OmsBoxPlugin.getDefault().setLastFolderChosen(file2.getParentFile().getAbsolutePath());
                                    }
                                } else if (id.toString().contains("#") && id.toString().startsWith("file")) {
                                    String string = id.toString().replaceAll("#", "");
                                    URL url = new URL(string);
                                    File file3 = new File(url.toURI());
                                    if (file3.exists()) {
                                        GuiTextField.this.setTextContent(file3);
                                        OmsBoxPlugin.getDefault().setLastFolderChosen(file3.getParentFile().getAbsolutePath());
                                    }
                                } else {
                                    System.out.println("Not a file: " + id.toString());
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                GuiTextField.this.modifyText(null);
            }

            public void dragEnter(DropTargetEvent event) {
            }

            public void dragLeave(DropTargetEvent event) {
            }

            public void dragOperationChanged(DropTargetEvent event) {
            }

            public void dragOver(DropTargetEvent event) {
            }

            public void dropAccept(DropTargetEvent event) {
            }
        });
    }

    private void setTextContent(File file) {
        if (this.isMapcalc) {
            String map = file.getName();
            GuiTextField.insertTextAtCaretPosition(this.text, map);
        } else {
            this.text.setText(file.getAbsolutePath());
            this.text.setSelection(this.text.getCharCount());
        }
    }

    private static void insertTextAtCaretPosition(StyledText text, String string) {
        int caretPosition = text.getCaretOffset();
        String textStr = text.getText();
        String sub1 = textStr.substring(0, caretPosition);
        String sub2 = textStr.substring(caretPosition);
        StringBuilder sb = new StringBuilder();
        sb.append(sub1);
        sb.append(string);
        sb.append(sub2);
        text.setText(sb.toString());
    }

    @Override
    public String validateContent() {
        File file;
        StringBuilder sb = new StringBuilder();
        String textStr = this.text.getText();
        int length = textStr.length();
        if ((this.isInFile || this.isInFolder) && length != 0 && !(file = new File(textStr)).exists()) {
            sb.append(MessageFormat.format("File {0} dosen''t exist.\n", textStr));
        }
        if (this.isMapcalc && length == 0) {
            sb.append("The function is mandatory for the mapcalc module.\n");
        }
        if (this.isGrassfile && length != 0 && !OmsBoxUtils.isGrass(textStr)) {
            File tmp = new File(textStr);
            sb.append("Grass modules currently work only with data contained in a GRASS mapset (which doesn't seem to be the case for: " + tmp.getName() + ").\n");
        }
        if (sb.length() > 0) {
            return sb.toString();
        }
        return null;
    }
}

