/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.omsbox.view.widgets;

import eu.udig.omsbox.OmsBoxPlugin;
import eu.udig.omsbox.core.FieldData;
import eu.udig.omsbox.view.widgets.ModuleGuiElement;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.refractions.udig.catalog.ID;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.internal.ui.UDigByteAndLocalTransfer;
import net.refractions.udig.project.internal.impl.LayerImpl;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.URLTransfer;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class GuiFilespathListInputField
extends ModuleGuiElement
implements ModifyListener,
FocusListener {
    private String constraints;
    private final FieldData data;
    private TableViewer tableViewer;

    public GuiFilespathListInputField(FieldData data, String constraints) {
        this.data = data;
        this.constraints = constraints;
    }

    @Override
    public Control makeGui(Composite parent) {
        parent = new Composite(parent, 0);
        parent.setLayoutData((Object)this.constraints);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        parent.setLayout((Layout)layout);
        this.tableViewer = new TableViewer(parent);
        Table table = this.tableViewer.getTable();
        GridData controlGD = new GridData(4, 4, true, true);
        controlGD.verticalSpan = 8;
        table.setLayoutData((Object)controlGD);
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.createColumns(parent, this.tableViewer);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.tableViewer.setInput(Arrays.asList(""));
        int i = 0;
        while (i < 8) {
            Label dummyLabel = new Label(parent, 0);
            dummyLabel.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, true));
            ++i;
        }
        this.addDrop();
        return this.tableViewer.getControl();
    }

    private void createColumns(Composite parent, TableViewer viewer) {
        int[] bounds = new int[]{200, 100};
        String[] titles = new String[]{"name", "path"};
        TableViewerColumn col = this.createTableViewerColumn(titles[0], bounds[0], 0);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public Image getImage(Object element) {
                return null;
            }

            public String getText(Object element) {
                if (element instanceof String) {
                    String path = (String)element;
                    File file = new File(path);
                    return file.getName();
                }
                return null;
            }
        });
        col = this.createTableViewerColumn(titles[1], bounds[1], 1);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public Image getImage(Object element) {
                return null;
            }

            public String getText(Object element) {
                if (element instanceof String) {
                    String path = (String)element;
                    return path;
                }
                return null;
            }
        });
    }

    private TableViewerColumn createTableViewerColumn(String title, int bound, int colNumber) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.tableViewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setWidth(bound);
        column.setResizable(true);
        column.setMoveable(true);
        return viewerColumn;
    }

    @Override
    public FieldData getFieldData() {
        return this.data;
    }

    @Override
    public boolean hasData() {
        return true;
    }

    public void modifyText(ModifyEvent e) {
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
    }

    private void addDrop() {
        int operations = 19;
        Control control = this.tableViewer.getControl();
        DropTarget target = new DropTarget(control, operations);
        final TextTransfer textTransfer = TextTransfer.getInstance();
        final FileTransfer fileTransfer = FileTransfer.getInstance();
        final URLTransfer urlTransfer = URLTransfer.getInstance();
        final UDigByteAndLocalTransfer omsboxTransfer = UDigByteAndLocalTransfer.getInstance();
        Transfer[] types = new Transfer[]{fileTransfer, textTransfer, urlTransfer, omsboxTransfer};
        target.setTransfer(types);
        target.addDropListener(new DropTargetListener(){

            public void drop(DropTargetEvent event) {
                File file;
                String[] files;
                if (textTransfer.isSupportedType(event.currentDataType)) {
                    String text = (String)event.data;
                    System.out.println(text);
                }
                if (fileTransfer.isSupportedType(event.currentDataType) && (files = (String[])event.data).length > 0 && (file = new File(files[0])).exists()) {
                    GuiFilespathListInputField.this.addFileToViewer(file);
                    OmsBoxPlugin.getDefault().setLastFolderChosen(file.getParentFile().getAbsolutePath());
                }
                if (urlTransfer.isSupportedType(event.currentDataType)) {
                    Object data2 = event.data;
                    System.out.println(data2);
                }
                if (omsboxTransfer.isSupportedType(event.currentDataType)) {
                    try {
                        Object data = event.data;
                        if (data instanceof TreeSelection) {
                            ID id;
                            IService service;
                            List resources;
                            TreeSelection selection = (TreeSelection)data;
                            Object firstElement = selection.getFirstElement();
                            IGeoResource geoResource = null;
                            if (firstElement instanceof LayerImpl) {
                                LayerImpl layer = (LayerImpl)firstElement;
                                geoResource = layer.getGeoResource();
                            }
                            if (firstElement instanceof IService && (resources = (service = (IService)firstElement).resources((IProgressMonitor)new NullProgressMonitor())).size() > 0) {
                                geoResource = (IGeoResource)resources.get(0);
                            }
                            if (geoResource != null && (id = geoResource.getID()) != null) {
                                if (id.isFile()) {
                                    File file2 = id.toFile();
                                    if (file2.exists()) {
                                        GuiFilespathListInputField.this.addFileToViewer(file2);
                                        OmsBoxPlugin.getDefault().setLastFolderChosen(file2.getParentFile().getAbsolutePath());
                                    }
                                } else if (id.toString().contains("#") && id.toString().startsWith("file")) {
                                    String string = id.toString().replaceAll("#", "");
                                    URL url = new URL(string);
                                    File file3 = new File(url.toURI());
                                    if (file3.exists()) {
                                        GuiFilespathListInputField.this.addFileToViewer(file3);
                                        OmsBoxPlugin.getDefault().setLastFolderChosen(file3.getParentFile().getAbsolutePath());
                                    }
                                } else {
                                    System.out.println("Not a file: " + id.toString());
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                GuiFilespathListInputField.this.modifyText(null);
            }

            public void dragEnter(DropTargetEvent event) {
            }

            public void dragLeave(DropTargetEvent event) {
            }

            public void dragOperationChanged(DropTargetEvent event) {
            }

            public void dragOver(DropTargetEvent event) {
            }

            public void dropAccept(DropTargetEvent event) {
            }
        });
    }

    private void addFileToViewer(File file) {
        List fileList = (List)this.tableViewer.getInput();
        ArrayList<String> newFileList = new ArrayList<String>();
        for (String path : fileList) {
            if (path == null || path.length() <= 0) continue;
            newFileList.add(path);
        }
        String absolutePath = file.getAbsolutePath();
        if (!newFileList.contains(absolutePath)) {
            newFileList.add(absolutePath);
            this.tableViewer.setInput(newFileList);
            StringBuilder sb = new StringBuilder();
            sb.append("Arrays.asList(");
            for (String path : newFileList) {
                path = this.checkBackSlash(path, true);
                sb.append("\"");
                sb.append(path);
                sb.append("\",");
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append(")");
            this.data.fieldValue = sb.toString();
        }
    }

    @Override
    public String validateContent() {
        return null;
    }
}

