/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.omsbox.view.widgets;

import eu.udig.omsbox.core.FieldData;
import eu.udig.omsbox.core.ModuleDescription;
import eu.udig.omsbox.core.OmsModulesManager;
import eu.udig.omsbox.view.widgets.ModuleGuiElement;
import eu.udig.omsbox.view.widgets.MultipleModuleDescriptionDialog;
import java.util.List;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.geotools.coverage.grid.GridCoverage2D;

public class GuiCoverageOutputField
extends ModuleGuiElement
implements SelectionListener {
    private final String constraints;
    private List<ModuleDescription> rasterWriters;
    private ModuleDescription selectedRasterWriter;
    private FieldData data;
    private Button browseButton;

    public GuiCoverageOutputField(FieldData data, String constraints) {
        this.data = data;
        this.constraints = constraints;
    }

    @Override
    public Control makeGui(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)this.constraints);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        this.browseButton = new Button(composite, 8);
        this.browseButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.browseButton.setText("...");
        this.browseButton.addSelectionListener((SelectionListener)this);
        return null;
    }

    @Override
    public FieldData getFieldData() {
        return this.data;
    }

    @Override
    public boolean hasData() {
        return true;
    }

    public void widgetSelected(SelectionEvent e) {
        this.rasterWriters = OmsModulesManager.getInstance().getRasterWriters();
        MultipleModuleDescriptionDialog dialog = new MultipleModuleDescriptionDialog("Choose Output Raster Writer", this.rasterWriters);
        if (this.selectedRasterWriter != null) {
            dialog.setLastUsedModuleDescription(this.selectedRasterWriter);
        }
        dialog.open(this.browseButton.getShell());
        this.selectedRasterWriter = dialog.getModuleDescription();
        List<FieldData> inputsList = this.selectedRasterWriter.getInputsList();
        for (FieldData fieldData : inputsList) {
            if (!fieldData.fieldType.equals(GridCoverage2D.class.getCanonicalName())) continue;
            this.data.otherFieldName = fieldData.fieldName;
            this.data.otherModule = this.selectedRasterWriter;
            break;
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    @Override
    public String validateContent() {
        return null;
    }
}

