/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.omsbox.view.actions;

import eu.udig.omsbox.utils.OmsBoxConstants;
import eu.udig.omsbox.view.OmsBoxView;
import java.io.File;
import net.refractions.udig.ui.ExceptionDetailsDialog;
import org.apache.commons.io.FileUtils;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.joda.time.DateTime;

public class OmsScriptGenerationAction
implements IViewActionDelegate {
    private IViewPart view;

    public void init(IViewPart view) {
        this.view = view;
    }

    public void run(IAction action) {
        if (this.view instanceof OmsBoxView) {
            OmsBoxView omsView = (OmsBoxView)this.view;
            try {
                String script = omsView.generateScriptForSelectedModule();
                if (script == null) {
                    return;
                }
                Program program = Program.findProgram((String)".txt");
                if (program != null) {
                    File tempFile = File.createTempFile("omsbox_", ".oms");
                    if (tempFile == null || !tempFile.exists() || tempFile.getAbsolutePath() == null) {
                        String ts = new DateTime().toString(OmsBoxConstants.dateTimeFormatterYYYYMMDDHHMMSS);
                        String userHomePath = System.getProperty("user.home");
                        File userHomeFile = new File(userHomePath);
                        if (!userHomeFile.exists()) {
                            String message = "Unable to create the oms script both in the temp folder and user home. Check your permissions.";
                            ExceptionDetailsDialog.openError(null, (String)message, (int)4, (String)"eu.udig.omsbox", (Throwable)new RuntimeException());
                            return;
                        }
                        tempFile = new File(userHomeFile, "omsbox_" + ts + ".oms");
                    }
                    FileUtils.writeStringToFile((File)tempFile, (String)script);
                    program.execute(tempFile.getAbsolutePath());
                } else {
                    FileDialog fileDialog = new FileDialog(this.view.getSite().getShell(), 8192);
                    String path = fileDialog.open();
                    if (path == null || path.length() < 1) {
                        return;
                    }
                    FileUtils.writeStringToFile((File)new File(path), (String)script);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                String message = "An error ocurred while generating the script.";
                ExceptionDetailsDialog.openError(null, (String)message, (int)4, (String)"eu.udig.omsbox", (Throwable)e);
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

