/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.omsbox.view.actions;

import eu.udig.omsbox.OmsBoxPlugin;
import eu.udig.omsbox.core.IProcessListener;
import eu.udig.omsbox.core.JConsoleOutputConsole;
import eu.udig.omsbox.core.OmsScriptExecutor;
import eu.udig.omsbox.utils.OmsBoxConstants;
import eu.udig.omsbox.view.OmsBoxView;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.joda.time.DateTime;

public class OmsScriptExecutionAction
implements IViewActionDelegate,
IProcessListener {
    private IViewPart view;
    private String scriptID;

    public void init(IViewPart view) {
        this.view = view;
    }

    public void run(IAction action) {
        if (this.view instanceof OmsBoxView) {
            FileDialog fileDialog = new FileDialog(this.view.getSite().getShell(), 4096);
            fileDialog.setFilterPath(OmsBoxPlugin.getDefault().getLastFolderChosen());
            String path = fileDialog.open();
            if (path == null || path.length() < 1) {
                return;
            }
            OmsBoxPlugin.getDefault().setLastFolderChosen(fileDialog.getFilterPath());
            this.execute(path);
        }
    }

    private void execute(String path) {
        JConsoleOutputConsole outputConsole = new JConsoleOutputConsole("Script: " + path);
        outputConsole.clearConsole();
        PrintStream internalStream = outputConsole.internal;
        PrintStream errorStream = outputConsole.err;
        IConsoleManager manager = ConsolePlugin.getDefault().getConsoleManager();
        manager.addConsoles(new IConsole[]{outputConsole});
        manager.showConsoleView((IConsole)outputConsole);
        try {
            OmsScriptExecutor executor = new OmsScriptExecutor();
            executor.addProcessListener(this);
            String loggerLevelGui = OmsBoxPlugin.getDefault().retrieveSavedLogLevel();
            String ramLevel = String.valueOf(OmsBoxPlugin.getDefault().retrieveSavedHeap());
            Process process = executor.exec(path, internalStream, errorStream, loggerLevelGui, ramLevel);
            File scriptFile = new File(path);
            this.scriptID = String.valueOf(scriptFile.getName()) + " " + new DateTime().toString(OmsBoxConstants.dateTimeFormatterYYYYMMDDHHMMSS);
            OmsBoxPlugin.getDefault().addProcess(process, this.scriptID);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    @Override
    public void onProcessStopped() {
        OmsBoxPlugin.getDefault().cleanProcess(this.scriptID);
    }

    public static String readFile(File file) throws IOException {
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(file));
            StringBuilder sb = new StringBuilder(200);
            String line = null;
            while ((line = br.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }
            String string = sb.toString();
            return string;
        }
        finally {
            br.close();
        }
    }
}

