/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.omsbox.view;

import eu.udig.omsbox.OmsBoxPlugin;
import eu.udig.omsbox.core.ModuleDescription;
import eu.udig.omsbox.core.OmsModulesManager;
import eu.udig.omsbox.core.ScriptHandler;
import eu.udig.omsbox.utils.ImageCache;
import eu.udig.omsbox.utils.OmsBoxConstants;
import eu.udig.omsbox.utils.ViewerFolder;
import eu.udig.omsbox.utils.ViewerModule;
import eu.udig.omsbox.view.widgets.ModuleGui;
import i18n.omsbox.Messages;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.refractions.udig.ui.PlatformGIS;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.part.ViewPart;
import org.joda.time.DateTime;

public class OmsBoxView
extends ViewPart {
    public static final String SPATIAL_TOOLBOX = "Spatial Toolbox...";
    public static final String LOADING_MODULES_FROM_LIBRARIES = "Loading modules from libraries...";
    public static final String ID = "eu.udig.omsbox.view.DatabaseView";
    private Composite modulesGuiComposite;
    private StackLayout modulesGuiStackLayout;
    private TreeViewer modulesViewer;
    private ModuleGui currentSelectedModuleGui;
    private HashMap<String, Control> module2GuiMap = new HashMap();

    public void createPartControl(Composite parent) {
        this.module2GuiMap.clear();
        Composite mainComposite = new Composite(parent, 0);
        GridLayout mainLayout = new GridLayout(1, false);
        mainLayout.marginWidth = 5;
        mainLayout.marginHeight = 5;
        mainComposite.setLayout((Layout)mainLayout);
        mainComposite.setLayoutData((Object)new GridData(1808));
        Composite modulesComposite = new Composite(mainComposite, 0);
        GridData modulesGroupGD = new GridData(4, 4, true, true);
        modulesComposite.setLayoutData((Object)modulesGroupGD);
        GridLayout modulesCompositeLayout = new GridLayout(3, true);
        modulesCompositeLayout.marginWidth = 0;
        modulesComposite.setLayout((Layout)modulesCompositeLayout);
        Label modulesLabel = new Label(modulesComposite, 0);
        modulesLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        modulesLabel.setText(Messages.OmsBoxView_Modules);
        Label dummyLabel = new Label(modulesComposite, 0);
        GridData dummyLabelGD = new GridData(1, 0x1000000, false, false);
        dummyLabelGD.horizontalSpan = 2;
        dummyLabel.setLayoutData((Object)dummyLabelGD);
        Composite modulesListComposite = new Composite(modulesComposite, 0);
        modulesListComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        modulesListComposite.setLayout((Layout)new GridLayout(1, false));
        this.modulesViewer = this.createTreeViewer(modulesListComposite);
        ArrayList viewerFolders = new ArrayList();
        this.modulesViewer.setInput(viewerFolders);
        this.addFilterButtons(modulesListComposite);
        this.addQuickSettings(modulesListComposite);
        this.modulesGuiComposite = new Composite(modulesComposite, 2048);
        this.modulesGuiStackLayout = new StackLayout();
        this.modulesGuiComposite.setLayout((Layout)this.modulesGuiStackLayout);
        GridData modulesGuiCompositeGD = new GridData(4, 4, true, true);
        modulesGuiCompositeGD.horizontalSpan = 2;
        this.modulesGuiComposite.setLayoutData((Object)modulesGuiCompositeGD);
        Label l = new Label(this.modulesGuiComposite, 16);
        l.setText(Messages.OmsBoxView_No_module_selected);
        this.modulesGuiStackLayout.topControl = l;
        this.relayout();
    }

    private TreeViewer createTreeViewer(Composite modulesComposite) {
        PatternFilter patternFilter = new PatternFilter();
        FilteredTree filter = new FilteredTree(modulesComposite, 2052, patternFilter, true);
        TreeViewer modulesViewer = filter.getViewer();
        Control control = modulesViewer.getControl();
        GridData controlGD = new GridData(4, 4, true, true);
        control.setLayoutData((Object)controlGD);
        modulesViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public Object[] getElements(Object inputElement) {
                return this.getChildren(inputElement);
            }

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof List) {
                    List list = (List)parentElement;
                    Object[] array = list.toArray();
                    return array;
                }
                if (parentElement instanceof ViewerFolder) {
                    ViewerFolder folder = (ViewerFolder)parentElement;
                    List<ViewerFolder> subFolders = folder.getSubFolders();
                    List<ViewerModule> modules = folder.getModules();
                    ArrayList<Object> allObjs = new ArrayList<Object>();
                    allObjs.addAll(subFolders);
                    allObjs.addAll(modules);
                    return allObjs.toArray();
                }
                return new Object[0];
            }

            public Object getParent(Object element) {
                if (element instanceof ViewerFolder) {
                    ViewerFolder folder = (ViewerFolder)element;
                    return folder.getParentFolder();
                }
                if (element instanceof ViewerModule) {
                    ViewerModule module = (ViewerModule)element;
                    return module.getParentFolder();
                }
                return null;
            }

            public boolean hasChildren(Object element) {
                return this.getChildren(element).length > 0;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        modulesViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                if (element instanceof ViewerFolder) {
                    return ImageCache.getInstance().getImage("icons/category.gif");
                }
                if (element instanceof ViewerModule) {
                    ModuleDescription md = ((ViewerModule)element).getModuleDescription();
                    ModuleDescription.Status status = md.getStatus();
                    if (status == ModuleDescription.Status.experimental) {
                        return ImageCache.getInstance().getImage("icons/module_exp.gif");
                    }
                    return ImageCache.getInstance().getImage("icons/module.gif");
                }
                return null;
            }

            public String getText(Object element) {
                if (element instanceof ViewerFolder) {
                    ViewerFolder categoryFolder = (ViewerFolder)element;
                    return categoryFolder.getName();
                }
                if (element instanceof ViewerModule) {
                    ModuleDescription module = ((ViewerModule)element).getModuleDescription();
                    return module.getName().replaceAll("\\_\\_", ".");
                }
                return "";
            }
        });
        modulesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!(event.getSelection() instanceof IStructuredSelection)) {
                    return;
                }
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                Object selectedItem = sel.getFirstElement();
                if (selectedItem == null) {
                    OmsBoxView.this.putUnselected();
                    return;
                }
                if (selectedItem instanceof ViewerModule) {
                    Control control;
                    ModuleDescription currentSelectedModule = ((ViewerModule)selectedItem).getModuleDescription();
                    OmsBoxView.this.currentSelectedModuleGui = new ModuleGui(currentSelectedModule);
                    ((OmsBoxView)OmsBoxView.this).modulesGuiStackLayout.topControl = control = OmsBoxView.this.currentSelectedModuleGui.makeGui(OmsBoxView.this.modulesGuiComposite, false);
                    OmsBoxView.this.modulesGuiComposite.layout(true);
                } else {
                    OmsBoxView.this.putUnselected();
                }
            }
        });
        return modulesViewer;
    }

    private void addFilterButtons(Composite modulesComposite) {
        Button filterActive = new Button(modulesComposite, 32);
        filterActive.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        filterActive.setText(Messages.OmsBoxView_Load_Experimental);
        final ExperimentalFilter activeFilter = new ExperimentalFilter();
        this.modulesViewer.addFilter((ViewerFilter)activeFilter);
        filterActive.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (((Button)event.widget).getSelection()) {
                    OmsBoxView.this.modulesViewer.removeFilter((ViewerFilter)activeFilter);
                } else {
                    OmsBoxView.this.modulesViewer.addFilter((ViewerFilter)activeFilter);
                }
            }
        });
    }

    private void addQuickSettings(Composite modulesListComposite) {
        Group quickSettingsGroup = new Group(modulesListComposite, 0);
        quickSettingsGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        quickSettingsGroup.setLayout((Layout)new GridLayout(2, true));
        quickSettingsGroup.setText("Process settings");
        Label heapLabel = new Label((Composite)quickSettingsGroup, 0);
        heapLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        heapLabel.setText("Memory [MB]");
        final Combo heapCombo = new Combo((Composite)quickSettingsGroup, 4);
        heapCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        heapCombo.setItems(OmsBoxConstants.HEAPLEVELS);
        int savedHeapLevel = OmsBoxPlugin.getDefault().retrieveSavedHeap();
        int i = 0;
        while (i < OmsBoxConstants.HEAPLEVELS.length) {
            if (OmsBoxConstants.HEAPLEVELS[i].equals(String.valueOf(savedHeapLevel))) {
                heapCombo.select(i);
                break;
            }
            ++i;
        }
        heapCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String item = heapCombo.getText();
                OmsBoxPlugin.getDefault().saveHeap(Integer.parseInt(item));
            }
        });
        heapCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String item = heapCombo.getText();
                try {
                    Integer.parseInt(item);
                }
                catch (Exception exception) {
                    return;
                }
                if (item.length() > 0) {
                    OmsBoxPlugin.getDefault().saveHeap(Integer.parseInt(item));
                }
            }
        });
        Label logLabel = new Label((Composite)quickSettingsGroup, 0);
        logLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        logLabel.setText("Debug info");
        final Combo logCombo = new Combo((Composite)quickSettingsGroup, 12);
        logCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        logCombo.setItems(OmsBoxConstants.LOGLEVELS_GUI);
        String savedLogLevel = OmsBoxPlugin.getDefault().retrieveSavedLogLevel();
        int i2 = 0;
        while (i2 < OmsBoxConstants.LOGLEVELS_GUI.length) {
            if (OmsBoxConstants.LOGLEVELS_GUI[i2].equals(savedLogLevel)) {
                logCombo.select(i2);
                break;
            }
            ++i2;
        }
        logCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String item = logCombo.getText();
                OmsBoxPlugin.getDefault().saveLogLevel(item);
            }
        });
    }

    public void setFocus() {
    }

    public void relayout() {
        IRunnableWithProgress operation = new IRunnableWithProgress(){

            public void run(IProgressMonitor pm) throws InvocationTargetException, InterruptedException {
                pm.beginTask(OmsBoxView.LOADING_MODULES_FROM_LIBRARIES, -1);
                HashMap<String, List<ModuleDescription>> availableModules = OmsModulesManager.getInstance().browseModules(false);
                final List<ViewerFolder> viewerFolders = ViewerFolder.hashmap2ViewerFolders(availableModules);
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        OmsBoxView.this.modulesViewer.setInput((Object)viewerFolders);
                    }
                });
                pm.done();
            }
        };
        PlatformGIS.runInProgressDialog((String)SPATIAL_TOOLBOX, (boolean)true, (IRunnableWithProgress)operation, (boolean)true);
    }

    public void putUnselected() {
        Label l = new Label(this.modulesGuiComposite, 16);
        l.setText(Messages.OmsBoxView_No_module_selected);
        this.modulesGuiStackLayout.topControl = l;
        this.modulesGuiComposite.layout(true);
    }

    public void runSelectedModule() throws Exception {
        ScriptHandler handler = new ScriptHandler();
        String script = handler.genereateScript(this.currentSelectedModuleGui);
        if (script == null) {
            return;
        }
        String scriptID = String.valueOf(this.currentSelectedModuleGui.getModuleDescription().getName()) + " " + new DateTime().toString(OmsBoxConstants.dateTimeFormatterYYYYMMDDHHMMSS);
        handler.runModule(scriptID, script);
    }

    public String generateScriptForSelectedModule() throws Exception {
        ScriptHandler handler = new ScriptHandler();
        if (this.currentSelectedModuleGui == null) {
            return null;
        }
        String script = handler.genereateScript(this.currentSelectedModuleGui);
        return script;
    }

    private static class ExperimentalFilter
    extends ViewerFilter {
        private ExperimentalFilter() {
        }

        public boolean select(Viewer arg0, Object arg1, Object arg2) {
            if (arg2 instanceof ViewerFolder) {
                return true;
            }
            if (arg2 instanceof ViewerModule) {
                ModuleDescription md = ((ViewerModule)arg2).getModuleDescription();
                return md.getStatus() != ModuleDescription.Status.experimental;
            }
            return false;
        }
    }
}

