/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.omsbox.utils;

import eu.udig.omsbox.core.ModuleDescription;
import eu.udig.omsbox.utils.ViewerModule;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ViewerFolder {
    private final String name;
    private List<ViewerFolder> subFolders = new ArrayList<ViewerFolder>();
    private List<ViewerModule> modules = new ArrayList<ViewerModule>();
    private ViewerFolder parentFolder;

    public ViewerFolder(String name) {
        this.name = name;
    }

    public void setParentFolder(ViewerFolder parentFolder) {
        this.parentFolder = parentFolder;
    }

    public ViewerFolder getParentFolder() {
        return this.parentFolder;
    }

    public String getName() {
        return this.name;
    }

    public void addSubFolder(ViewerFolder subFolder) {
        if (!this.subFolders.contains(subFolder)) {
            subFolder.setParentFolder(this);
            this.subFolders.add(subFolder);
        }
    }

    public void addModule(ViewerModule module) {
        if (!this.modules.contains(module)) {
            module.setParentFolder(this);
            this.modules.add(module);
        }
    }

    public List<ViewerFolder> getSubFolders() {
        return this.subFolders;
    }

    public List<ViewerModule> getModules() {
        return this.modules;
    }

    public static List<ViewerFolder> hashmap2ViewerFolders(HashMap<String, List<ModuleDescription>> availableModules) {
        ArrayList<ViewerFolder> folders = new ArrayList<ViewerFolder>();
        HashMap<String, ViewerFolder> tmpFoldersMap = new HashMap<String, ViewerFolder>();
        Set<Map.Entry<String, List<ModuleDescription>>> entrySet = availableModules.entrySet();
        for (Map.Entry<String, List<ModuleDescription>> entry : entrySet) {
            String key = entry.getKey();
            List<ModuleDescription> md = entry.getValue();
            String[] keySplit = key.split("/");
            String mainKey = keySplit[0];
            ViewerFolder mainFolder = (ViewerFolder)tmpFoldersMap.get(mainKey);
            if (mainFolder == null) {
                mainFolder = new ViewerFolder(mainKey);
                folders.add(mainFolder);
                tmpFoldersMap.put(mainKey, mainFolder);
            }
            int i = 1;
            while (i < keySplit.length) {
                ViewerFolder tmpFolder = (ViewerFolder)tmpFoldersMap.get(keySplit[i]);
                if (tmpFolder == null) {
                    tmpFolder = new ViewerFolder(keySplit[i]);
                    tmpFoldersMap.put(keySplit[i], tmpFolder);
                }
                mainFolder.addSubFolder(tmpFolder);
                mainFolder = tmpFolder;
                ++i;
            }
            for (ModuleDescription moduleDescription : md) {
                mainFolder.addModule(new ViewerModule(moduleDescription));
            }
        }
        return folders;
    }
}

