/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.omsbox.utils;

import eu.udig.omsbox.OmsBoxPlugin;
import eu.udig.omsbox.core.FieldData;
import eu.udig.omsbox.core.OmsModulesManager;
import eu.udig.omsbox.processingregion.ProcessingRegion;
import eu.udig.omsbox.utils.AnnotationUtilities;
import java.awt.geom.AffineTransform;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.util.Collection;
import oms3.Access;
import oms3.ComponentAccess;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Documentation;
import oms3.annotations.Keywords;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Status;
import oms3.annotations.Unit;
import org.apache.commons.io.FileUtils;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.geometry.Envelope2D;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.matrix.XAffineTransform;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class OmsBoxUtils {
    private static final String OMSBOXHTMLDOCS = "omsboxhtmldocs";
    private static final String NEWLINE = "\n";
    private static final String HTMLNEWLINE = "<br>";
    private static final String DOCSSUFFIX = ".html";

    public static String getCodeFromCrs(CoordinateReferenceSystem crs) throws Exception {
        String code = null;
        try {
            Integer epsg = CRS.lookupEpsgCode((CoordinateReferenceSystem)crs, (boolean)true);
            code = "EPSG:" + epsg;
        }
        catch (Exception exception) {
            code = CRS.lookupIdentifier((IdentifiedObject)crs, (boolean)true);
        }
        return code;
    }

    public static ProcessingRegion gridGeometry2ProcessingRegion(GridGeometry2D gridGeometry) {
        Envelope2D envelope = gridGeometry.getEnvelope2D();
        DirectPosition lowerCorner = envelope.getLowerCorner();
        double[] westSouth = lowerCorner.getCoordinate();
        DirectPosition upperCorner = envelope.getUpperCorner();
        double[] eastNorth = upperCorner.getCoordinate();
        AffineTransform gridToCRS = (AffineTransform)gridGeometry.getGridToCRS();
        double xRes = XAffineTransform.getScaleX0((AffineTransform)gridToCRS);
        double yRes = XAffineTransform.getScaleY0((AffineTransform)gridToCRS);
        ProcessingRegion region = new ProcessingRegion(westSouth[0], eastNorth[0], westSouth[1], eastNorth[1], xRes, yRes);
        return region;
    }

    public static boolean isFieldExceptional(FieldData inputData) {
        return inputData.guiHints != null && inputData.guiHints.equals("filespathlist");
    }

    public static String getModuleDocumentationPath(String moduleClassName) throws Exception {
        File configurationsFolder = OmsBoxPlugin.getDefault().getConfigurationsFolder();
        File htmlDocsFolder = new File(configurationsFolder, OMSBOXHTMLDOCS);
        File htmlDocs = new File(htmlDocsFolder, String.valueOf(moduleClassName) + DOCSSUFFIX);
        if (!htmlDocs.exists()) {
            throw new RuntimeException();
        }
        return htmlDocs.getAbsolutePath();
    }

    public static void cleanModuleDocumentation() throws Exception {
        File configurationsFolder = OmsBoxPlugin.getDefault().getConfigurationsFolder();
        File htmlDocsFolder = new File(configurationsFolder, OMSBOXHTMLDOCS);
        if (htmlDocsFolder.exists()) {
            FileUtils.deleteDirectory((File)htmlDocsFolder);
        }
    }

    public static void generateModuleDocumentation(String moduleClassName) throws Exception {
        Keywords keywords;
        License license;
        Author author;
        Class<?> moduleClass = OmsModulesManager.getInstance().getModulesClass(moduleClassName);
        StringBuilder sb = new StringBuilder();
        sb.append("<html><body>\n");
        Documentation documentation = moduleClass.getAnnotation(Documentation.class);
        String documentationStr = null;
        if (documentation != null) {
            documentationStr = AnnotationUtilities.getLocalizedDocumentation(documentation);
            if (documentationStr.length() == 0) {
                documentationStr = null;
            } else if (documentationStr.equals(" - ")) {
                documentationStr = null;
            }
        }
        if (documentation != null && documentationStr != null) {
            if (documentationStr.endsWith(DOCSSUFFIX)) {
                String modulePackage = moduleClassName.substring(0, moduleClassName.lastIndexOf(46));
                String path = String.valueOf(modulePackage.replaceAll("\\.", "/")) + "/" + documentationStr;
                InputStream inStream = OmsModulesManager.getInstance().getResourceAsStream(path);
                if (inStream != null) {
                    BufferedReader br = null;
                    try {
                        br = new BufferedReader(new InputStreamReader(inStream));
                        StringBuilder tmpSb = new StringBuilder();
                        String line = "";
                        while ((line = br.readLine()) != null) {
                            tmpSb.append(line).append(NEWLINE);
                        }
                        documentationStr = tmpSb.toString();
                    }
                    finally {
                        if (br != null) {
                            br.close();
                        }
                    }
                }
            }
            sb.append("<h2>Description</h2>").append(NEWLINE);
            sb.append(NEWLINE);
            sb.append("<blockquote>");
            sb.append(documentationStr);
            sb.append("</blockquote>");
            sb.append(NEWLINE);
            sb.append(NEWLINE);
        } else {
            Description description = moduleClass.getAnnotation(Description.class);
            String descriptionStr = AnnotationUtilities.getLocalizedDescription(description);
            if (description != null) {
                sb.append("<h2>Description</h2>").append(NEWLINE);
                sb.append(NEWLINE);
                sb.append("<blockquote>");
                sb.append(descriptionStr);
                sb.append("</blockquote>");
                sb.append(NEWLINE);
                sb.append(NEWLINE);
            }
        }
        sb.append("<h2>General Information</h2>").append(NEWLINE);
        sb.append(NEWLINE);
        Status status = moduleClass.getAnnotation(Status.class);
        if (status != null) {
            sb.append("<blockquote>");
            sb.append("Module status: " + OmsBoxUtils.getStatusString(status.value())).append(NEWLINE);
            sb.append("</blockquote>");
            sb.append(NEWLINE);
        }
        Name name = moduleClass.getAnnotation(Name.class);
        String nameStr = AnnotationUtilities.getLocalizedName(name);
        if (name != null) {
            sb.append("<blockquote>");
            sb.append(" Name to use in a script: <b>" + nameStr + "</b>").append(NEWLINE);
            sb.append("</blockquote>");
            sb.append(NEWLINE);
        }
        if ((author = moduleClass.getAnnotation(Author.class)) != null) {
            String authorNameStr = author.name();
            String[] authorNameSplit = authorNameStr.split(",");
            String authorContactStr = author.contact();
            String[] authorContactSplit = authorContactStr.split(",");
            sb.append("<blockquote>");
            sb.append(" Authors ").append(NEWLINE);
            sb.append(HTMLNEWLINE);
            sb.append("<ul>").append(NEWLINE);
            String[] stringArray = authorNameSplit;
            int n = authorNameSplit.length;
            int n2 = 0;
            while (n2 < n) {
                String authorName = stringArray[n2];
                sb.append("<li>").append(authorName.trim());
                ++n2;
            }
            sb.append("</li>").append(NEWLINE);
            sb.append("</ul>").append(NEWLINE);
            sb.append(NEWLINE);
            sb.append(HTMLNEWLINE);
            sb.append(HTMLNEWLINE);
            sb.append(" Contacts: ").append(NEWLINE);
            sb.append(HTMLNEWLINE);
            sb.append("<ul>").append(NEWLINE);
            stringArray = authorContactSplit;
            n = authorContactSplit.length;
            n2 = 0;
            while (n2 < n) {
                String authorContact = stringArray[n2];
                sb.append("<li>").append(authorContact.trim());
                ++n2;
            }
            sb.append("</li>").append(NEWLINE);
            sb.append("</ul>").append(NEWLINE);
            sb.append("</blockquote>");
            sb.append(NEWLINE);
        }
        if ((license = moduleClass.getAnnotation(License.class)) != null) {
            String licenseStr = AnnotationUtilities.getLocalizedLicense(license);
            sb.append("<blockquote>");
            sb.append(" License: " + licenseStr).append(NEWLINE);
            sb.append("</blockquote>");
            sb.append(NEWLINE);
        }
        if ((keywords = moduleClass.getAnnotation(Keywords.class)) != null) {
            String keywordsStr = AnnotationUtilities.getLocalizedKeywords(keywords);
            sb.append("<blockquote>");
            sb.append(" Keywords: " + keywordsStr).append(NEWLINE);
            sb.append("</blockquote>");
            sb.append(NEWLINE);
        }
        sb.append(NEWLINE);
        Object annotatedObject = moduleClass.newInstance();
        ComponentAccess cA = new ComponentAccess(annotatedObject);
        sb.append("<h2>Parameters</h2>").append(NEWLINE);
        sb.append(NEWLINE);
        sb.append("<blockquote>");
        Collection inputs = cA.inputs();
        StringBuilder sbTmp = new StringBuilder();
        OmsBoxUtils.collectParameters(sbTmp, inputs);
        OmsBoxUtils.toTable(sb, sbTmp, "Input parameters");
        sb.append(NEWLINE);
        Collection outputs = cA.outputs();
        sbTmp = new StringBuilder();
        OmsBoxUtils.collectParameters(sbTmp, outputs);
        OmsBoxUtils.toTable(sb, sbTmp, "Output parameters");
        sb.append("</blockquote>");
        sb.append(NEWLINE);
        sb.append(NEWLINE);
        sb.append("</body></html>");
        File configurationsFolder = OmsBoxPlugin.getDefault().getConfigurationsFolder();
        File htmlDocsFolder = new File(configurationsFolder, OMSBOXHTMLDOCS);
        if (!htmlDocsFolder.exists() && !htmlDocsFolder.mkdir()) {
            throw new RuntimeException();
        }
        File htmlDocs = new File(htmlDocsFolder, String.valueOf(moduleClassName) + DOCSSUFFIX);
        FileUtils.writeStringToFile((File)htmlDocs, (String)sb.toString());
    }

    private static void collectParameters(StringBuilder sbTmp, Collection<Access> accessList) throws Exception {
        for (Access access : accessList) {
            Field field = access.getField();
            String fieldName = field.getName();
            Description descriptionAnnot = field.getAnnotation(Description.class);
            if (fieldName.equals("pm")) continue;
            String fieldDescription = " - ";
            if (descriptionAnnot != null) {
                Unit unitAnn;
                fieldDescription = AnnotationUtilities.getLocalizedDescription(descriptionAnnot);
                if (fieldDescription == null) {
                    fieldDescription = " - ";
                }
                if ((unitAnn = field.getAnnotation(Unit.class)) != null) {
                    fieldDescription = String.valueOf(fieldDescription) + " [" + unitAnn.value() + "]";
                }
            }
            sbTmp.append("<tr>").append(NEWLINE);
            sbTmp.append("<td width=\"40%\"> <b>").append(fieldName).append("</b> </td><td width=\"60%\"> ");
            sbTmp.append(fieldDescription).append(" </td>").append(NEWLINE);
            sbTmp.append("</tr>").append(NEWLINE);
        }
    }

    private static void toTable(StringBuilder sbToAppendTo, StringBuilder tableContentSb, String tableTitle) {
        if (tableContentSb.length() > 0) {
            sbToAppendTo.append("<h3>" + tableTitle + "</h3>").append(NEWLINE);
            sbToAppendTo.append("<table width=\"100%\" border=\"1\" cellpadding=\"10\">").append(NEWLINE);
            sbToAppendTo.append((CharSequence)tableContentSb);
            sbToAppendTo.append("</table>").append(NEWLINE);
        }
    }

    private static String getStatusString(int statusValue) {
        switch (statusValue) {
            case 40: {
                return "CERTIFIED";
            }
            case 10: {
                return "DRAFT";
            }
            case 5: {
                return "EXPERIMENTAL";
            }
            case 20: {
                return "TESTED";
            }
            case 30: {
                return "VALIDATED";
            }
        }
        return "DRAFT";
    }

    public static boolean isGrass(String path) {
        if (path == null) {
            return false;
        }
        File file = new File(path);
        File cellFolderFile = file.getParentFile();
        File mapsetFile = cellFolderFile.getParentFile();
        File windFile = new File(mapsetFile, "WIND");
        return cellFolderFile.getName().toLowerCase().equals("cell") && windFile.exists();
    }
}

