/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.omsbox.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ImageCache {
    public static final String CATEGORY = "icons/category.gif";
    public static final String MODULE = "icons/module.gif";
    public static final String MODULEEXP = "icons/module_exp.gif";
    public static final String RUN = "icons/run_module.gif";
    public static final String STOP = "icons/stop_module.gif";
    public static final String GRID = "icons/grid_obj.gif";
    private static ImageCache imageCache;
    private HashMap<String, Image> imageMap = new HashMap();

    private ImageCache() {
    }

    public static ImageCache getInstance() {
        if (imageCache == null) {
            imageCache = new ImageCache();
        }
        return imageCache;
    }

    public Image getImage(String key) {
        Image image = this.imageMap.get(key);
        if (image == null) {
            image = this.createImage(key);
            this.imageMap.put(key, image);
        }
        return image;
    }

    private Image createImage(String key) {
        ImageDescriptor id = AbstractUIPlugin.imageDescriptorFromPlugin((String)"eu.udig.omsbox", (String)key);
        Image image = id.createImage();
        return image;
    }

    public void dispose() {
        Set<Map.Entry<String, Image>> entrySet = this.imageMap.entrySet();
        for (Map.Entry<String, Image> entry : entrySet) {
            entry.getValue().dispose();
        }
        this.imageMap.clear();
    }
}

