/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.omsbox.ui;

import eu.udig.omsbox.OmsBoxPlugin;
import java.util.HashMap;
import java.util.Set;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class RunningProcessListDialog {
    private Dialog dialog;
    private String currentSelectedProcessId;
    private TableViewer tableViewer;
    private HashMap<String, Process> runningProcessesMap;

    public void open(Shell parentShell, int selectionType) {
        this.runningProcessesMap = OmsBoxPlugin.getDefault().getRunningProcessesMap();
        this.dialog = new Dialog(parentShell){

            protected void configureShell(Shell shell) {
                super.configureShell(shell);
                shell.setText("Kill selected process");
            }

            protected Point getInitialSize() {
                return new Point(640, 450);
            }

            protected Control createDialogArea(Composite parent) {
                Composite parentPanel = (Composite)super.createDialogArea(parent);
                GridLayout gLayout = (GridLayout)parentPanel.getLayout();
                gLayout.numColumns = 1;
                RunningProcessListDialog.this.createTableViewer(parentPanel);
                return parentPanel;
            }

            protected void buttonPressed(int buttonId) {
                if (buttonId == 0) {
                    OmsBoxPlugin.getDefault().killProcess(RunningProcessListDialog.this.currentSelectedProcessId);
                }
                super.buttonPressed(buttonId);
            }
        };
        this.dialog.setBlockOnOpen(true);
        this.dialog.open();
    }

    public boolean isDisposed() {
        return this.dialog.getShell().isDisposed();
    }

    public void widgetSelected(SelectionEvent e) {
    }

    private void createTableViewer(Composite parentPanel) {
        Group processesGroup = new Group(parentPanel, 0);
        processesGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        processesGroup.setLayout((Layout)new GridLayout(1, false));
        processesGroup.setText("Current running processes (select process and press ok to kill it)");
        this.tableViewer = new TableViewer((Composite)processesGroup);
        Control control = this.tableViewer.getControl();
        GridData controlGD = new GridData(4, 4, true, true);
        control.setLayoutData((Object)controlGD);
        this.tableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof HashMap) {
                    HashMap paths = (HashMap)inputElement;
                    Set keySet = paths.keySet();
                    Object[] array = new Object[keySet.size()];
                    int i = 0;
                    for (Object key : keySet) {
                        array[i] = key;
                        ++i;
                    }
                    return array;
                }
                return new String[0];
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }
        });
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                return null;
            }

            public String getText(Object element) {
                if (element instanceof String) {
                    String processId = (String)element;
                    return processId;
                }
                return "";
            }
        });
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!(event.getSelection() instanceof IStructuredSelection)) {
                    return;
                }
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                Object selectedItem = sel.getFirstElement();
                if (selectedItem == null) {
                    return;
                }
                if (selectedItem instanceof String) {
                    RunningProcessListDialog.this.currentSelectedProcessId = (String)selectedItem;
                }
            }
        });
        if (this.runningProcessesMap.size() > 0) {
            this.tableViewer.setInput(this.runningProcessesMap);
        } else {
            this.tableViewer.setInput((Object)"");
        }
    }
}

