/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.omsbox.processingregion;

import com.vividsolutions.jts.geom.Envelope;
import eu.udig.catalog.jgrass.activeregion.dialogs.FeatureChooserDialog;
import eu.udig.omsbox.processingregion.ProcessingRegion;
import eu.udig.omsbox.processingregion.ProcessingRegionMapGraphic;
import eu.udig.omsbox.processingregion.ProcessingRegionStyle;
import eu.udig.omsbox.processingregion.ProcessingRegionStyleContent;
import eu.udig.omsbox.ui.CoverageChooserDialog;
import eu.udig.omsbox.utils.OmsBoxUtils;
import java.awt.Color;
import java.io.IOException;
import java.util.List;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.StyleBlackboard;
import net.refractions.udig.project.internal.impl.UDIGFeatureStore;
import net.refractions.udig.project.ui.internal.dialogs.ColorEditor;
import net.refractions.udig.style.IStyleConfigurator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.data.DataStore;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.coverage.grid.GridCoverage;

public class ProcessingRegionGraphicStyleConfigurator
extends IStyleConfigurator
implements SelectionListener,
ModifyListener {
    private static final int bound_type = 0;
    private static final int row_type = 1;
    private static final int res_type = 2;
    private Label northLabel = null;
    private Text northText = null;
    private Label rowsLabel = null;
    private Text rowsText = null;
    private Label southLabel = null;
    private Text southText = null;
    private Label colsLabel = null;
    private Text colsText = null;
    private Label westLabel = null;
    private Text westText = null;
    private Label xresLabel = null;
    private Text xresText = null;
    private Label eastLabel = null;
    private Text eastText = null;
    private Label yresLabel = null;
    private Text yresText = null;
    private Button rasterMapSetButton = null;
    private Button featuresMapSetButton = null;
    private ColorEditor backgroundColour;
    private ColorEditor foregroundColor;
    private Text backgroundAlphaText;
    private Text forgroundAlphaText;
    private ProcessingRegionStyle style = null;
    private boolean isWorking = false;
    private StyleBlackboard blackboard;

    public void createControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        ScrolledComposite scrollComposite = new ScrolledComposite(parent, 512);
        scrollComposite.setMinHeight(100);
        scrollComposite.setLayoutData((Object)new GridData(1808));
        Composite c = new Composite((Composite)scrollComposite, 0);
        c.setLayout((Layout)new GridLayout());
        c.setLayoutData((Object)new GridData(1808));
        Group regionGroup = new Group(c, 2048);
        GridLayout layout2 = new GridLayout(2, true);
        regionGroup.setLayout((Layout)layout2);
        regionGroup.setText("Region settings");
        regionGroup.setLayoutData((Object)new GridData(768));
        this.northLabel = new Label((Composite)regionGroup, 0);
        this.northLabel.setText("north");
        this.northLabel.setLayoutData((Object)new GridData(768));
        this.northText = new Text((Composite)regionGroup, 2048);
        this.northText.setLayoutData((Object)new GridData(768));
        this.southLabel = new Label((Composite)regionGroup, 0);
        this.southLabel.setText("south");
        this.southLabel.setLayoutData((Object)new GridData(768));
        this.southText = new Text((Composite)regionGroup, 2048);
        this.southText.setLayoutData((Object)new GridData(768));
        this.westLabel = new Label((Composite)regionGroup, 0);
        this.westLabel.setText("west");
        this.westLabel.setLayoutData((Object)new GridData(768));
        this.westText = new Text((Composite)regionGroup, 2048);
        this.westText.setLayoutData((Object)new GridData(768));
        this.eastLabel = new Label((Composite)regionGroup, 0);
        this.eastLabel.setText("east");
        this.eastLabel.setLayoutData((Object)new GridData(768));
        this.eastText = new Text((Composite)regionGroup, 2048);
        this.eastText.setLayoutData((Object)new GridData(768));
        this.rowsLabel = new Label((Composite)regionGroup, 0);
        this.rowsLabel.setText("rows");
        this.rowsLabel.setLayoutData((Object)new GridData(768));
        this.rowsText = new Text((Composite)regionGroup, 2048);
        this.rowsText.setLayoutData((Object)new GridData(768));
        this.colsLabel = new Label((Composite)regionGroup, 0);
        this.colsLabel.setText("cols");
        this.colsLabel.setLayoutData((Object)new GridData(768));
        this.colsText = new Text((Composite)regionGroup, 2048);
        this.colsText.setLayoutData((Object)new GridData(768));
        this.xresLabel = new Label((Composite)regionGroup, 0);
        this.xresLabel.setText("xres");
        this.xresLabel.setLayoutData((Object)new GridData(768));
        this.xresText = new Text((Composite)regionGroup, 2048);
        this.xresText.setLayoutData((Object)new GridData(768));
        this.yresLabel = new Label((Composite)regionGroup, 0);
        this.yresLabel.setText("yres");
        this.yresLabel.setLayoutData((Object)new GridData(768));
        this.yresText = new Text((Composite)regionGroup, 2048);
        this.yresText.setLayoutData((Object)new GridData(768));
        Group styleGroup = new Group(c, 2048);
        GridLayout layout3 = new GridLayout(2, true);
        styleGroup.setLayout((Layout)layout3);
        styleGroup.setText("Style properties");
        styleGroup.setLayoutData((Object)new GridData(768));
        Label backgroundColourLabel = new Label((Composite)styleGroup, 0);
        backgroundColourLabel.setLayoutData((Object)new GridData(768));
        backgroundColourLabel.setText("background color");
        this.backgroundColour = new ColorEditor((Composite)styleGroup);
        this.backgroundColour.getButton().setLayoutData((Object)new GridData(768));
        Label backgroundAlphaLabel = new Label((Composite)styleGroup, 0);
        backgroundAlphaLabel.setLayoutData((Object)new GridData(768));
        backgroundAlphaLabel.setText("background alpha (0-1)");
        this.backgroundAlphaText = new Text((Composite)styleGroup, 2048);
        this.backgroundAlphaText.setLayoutData((Object)new GridData(768));
        Label foregroundColourLabel = new Label((Composite)styleGroup, 0);
        foregroundColourLabel.setLayoutData((Object)new GridData(768));
        foregroundColourLabel.setText("foreground color");
        this.foregroundColor = new ColorEditor((Composite)styleGroup);
        this.foregroundColor.getButton().setLayoutData((Object)new GridData(768));
        Label forgroundAlphaLabel = new Label((Composite)styleGroup, 0);
        forgroundAlphaLabel.setLayoutData((Object)new GridData(768));
        forgroundAlphaLabel.setText("foreground alpha (0-1)");
        this.forgroundAlphaText = new Text((Composite)styleGroup, 2048);
        this.forgroundAlphaText.setLayoutData((Object)new GridData(768));
        final Group settoGroup = new Group(c, 2048);
        GridLayout layout4 = new GridLayout(1, true);
        settoGroup.setLayout((Layout)layout4);
        settoGroup.setText("Set region to...");
        settoGroup.setLayoutData((Object)new GridData(768));
        this.rasterMapSetButton = new Button((Composite)settoGroup, 0);
        this.rasterMapSetButton.setText("set region to raster map");
        this.rasterMapSetButton.setLayoutData((Object)new GridData(768));
        this.rasterMapSetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CoverageChooserDialog tree = new CoverageChooserDialog();
                tree.open(settoGroup.getShell(), 4);
                ProcessingRegionGraphicStyleConfigurator.this.update(tree.getSelectedResources());
            }
        });
        this.featuresMapSetButton = new Button((Composite)settoGroup, 0);
        this.featuresMapSetButton.setText("set region to vector map");
        this.featuresMapSetButton.setLayoutData((Object)new GridData(768));
        this.featuresMapSetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FeatureChooserDialog tree = new FeatureChooserDialog();
                tree.open(settoGroup.getShell(), 4);
                ProcessingRegionGraphicStyleConfigurator.this.update(tree.getSelectedResources());
            }
        });
        this.northText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ProcessingRegionGraphicStyleConfigurator.this.isWorking) {
                    return;
                }
                ProcessingRegionGraphicStyleConfigurator.this.textModified(0);
            }
        });
        this.southText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ProcessingRegionGraphicStyleConfigurator.this.isWorking) {
                    return;
                }
                ProcessingRegionGraphicStyleConfigurator.this.textModified(0);
            }
        });
        this.rowsText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ProcessingRegionGraphicStyleConfigurator.this.isWorking) {
                    return;
                }
                ProcessingRegionGraphicStyleConfigurator.this.textModified(1);
            }
        });
        this.colsText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ProcessingRegionGraphicStyleConfigurator.this.isWorking) {
                    return;
                }
                ProcessingRegionGraphicStyleConfigurator.this.textModified(1);
            }
        });
        this.westText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ProcessingRegionGraphicStyleConfigurator.this.isWorking) {
                    return;
                }
                ProcessingRegionGraphicStyleConfigurator.this.textModified(0);
            }
        });
        this.xresText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ProcessingRegionGraphicStyleConfigurator.this.isWorking) {
                    return;
                }
                ProcessingRegionGraphicStyleConfigurator.this.textModified(2);
            }
        });
        this.eastText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ProcessingRegionGraphicStyleConfigurator.this.isWorking) {
                    return;
                }
                ProcessingRegionGraphicStyleConfigurator.this.textModified(0);
            }
        });
        this.yresText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ProcessingRegionGraphicStyleConfigurator.this.isWorking) {
                    return;
                }
                ProcessingRegionGraphicStyleConfigurator.this.textModified(2);
            }
        });
        this.foregroundColor.addSelectionListener((SelectionListener)this);
        this.backgroundColour.addSelectionListener((SelectionListener)this);
        c.layout();
        Point size = c.computeSize(-1, -1);
        c.setSize(size);
        scrollComposite.setContent((Control)c);
    }

    public boolean canStyle(Layer aLayer) {
        return aLayer.hasResource(ProcessingRegionMapGraphic.class);
    }

    protected void refresh() {
        try {
            StyleBlackboard blackboard = this.getLayer().getStyleBlackboard();
            this.style = (ProcessingRegionStyle)blackboard.get("eu.udig.omsbox.processingregion.ProcessingRegionStyleContent");
            if (this.style == null) {
                this.style = ProcessingRegionStyleContent.createDefault();
                blackboard.put("eu.udig.omsbox.processingregion.ProcessingRegionStyleContent", (Object)this.style);
            }
            ProcessingRegion tmp = new ProcessingRegion(this.style.west, this.style.east, this.style.south, this.style.north, this.style.rows, this.style.cols);
            this.isWorking = true;
            this.northText.setText(String.valueOf(this.style.north));
            this.southText.setText(String.valueOf(this.style.south));
            this.westText.setText(String.valueOf(this.style.west));
            this.eastText.setText(String.valueOf(this.style.east));
            this.xresText.setText(String.valueOf(tmp.getWEResolution()));
            this.yresText.setText(String.valueOf(tmp.getNSResolution()));
            this.colsText.setText(String.valueOf(this.style.cols));
            this.rowsText.setText(String.valueOf(this.style.rows));
            this.isWorking = false;
            this.forgroundAlphaText.setText(Float.toString(this.style.fAlpha));
            this.backgroundAlphaText.setText(Float.toString(this.style.bAlpha));
            this.foregroundColor.setColorValue(new RGB(this.style.foregroundColor.getRed(), this.style.foregroundColor.getGreen(), this.style.foregroundColor.getBlue()));
            this.backgroundColour.setColorValue(new RGB(this.style.backgroundColor.getRed(), this.style.backgroundColor.getGreen(), this.style.backgroundColor.getBlue()));
            this.commitToBlackboards(tmp);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateBlackboard() {
        int bAlpha;
        ProcessingRegionStyle style = this.getActiveRegionStyle();
        RGB bg = this.backgroundColour.getColorValue();
        try {
            bAlpha = Integer.parseInt(this.backgroundAlphaText.getText());
            style.backgroundColor = new Color(bg.red, bg.green, bg.blue, bAlpha);
        }
        catch (Exception exception) {
            style.backgroundColor = new Color(bg.red, bg.green, bg.blue);
        }
        bg = this.foregroundColor.getColorValue();
        try {
            bAlpha = Integer.parseInt(this.forgroundAlphaText.getText());
            style.foregroundColor = new Color(bg.red, bg.green, bg.blue, bAlpha);
        }
        catch (Exception exception) {
            style.foregroundColor = new Color(bg.red, bg.green, bg.blue);
        }
        this.dumpActiveRegionStyle(style);
    }

    private void dumpActiveRegionStyle(ProcessingRegionStyle style) {
        this.blackboard.put("eu.udig.omsbox.processingregion.ProcessingRegionStyleContent", (Object)style);
    }

    private ProcessingRegionStyle getActiveRegionStyle() {
        ProcessingRegionStyle style = (ProcessingRegionStyle)this.blackboard.get("eu.udig.omsbox.processingregion.ProcessingRegionStyleContent");
        if (style == null) {
            style = ProcessingRegionStyleContent.createDefault();
        }
        return style;
    }

    public void widgetSelected(SelectionEvent e) {
        this.updateBlackboard();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.updateBlackboard();
    }

    public void modifyText(ModifyEvent e) {
        this.updateBlackboard();
    }

    public void update(Object updatedObject) {
        if (updatedObject instanceof List) {
            Object text = null;
            List layers = (List)updatedObject;
            for (Object layer : layers) {
                if (layer instanceof IGeoResource) {
                    IGeoResource geoResource = (IGeoResource)layer;
                    try {
                        GridGeometry2D gridGeometry = null;
                        if (geoResource.canResolve(GridGeometry2D.class)) {
                            gridGeometry = (GridGeometry2D)geoResource.resolve(GridGeometry2D.class, (IProgressMonitor)new NullProgressMonitor());
                        } else if (geoResource.canResolve(GridCoverage.class)) {
                            GridCoverage2D gridCoverage = (GridCoverage2D)geoResource.resolve(GridCoverage.class, (IProgressMonitor)new NullProgressMonitor());
                            gridGeometry = gridCoverage.getGridGeometry();
                        }
                        if (gridGeometry == null) continue;
                        this.setWidgetsToWindow(OmsBoxUtils.gridGeometry2ProcessingRegion(gridGeometry));
                        continue;
                    }
                    catch (IOException iOException) {
                        return;
                    }
                }
                if (layer instanceof DataStore || layer instanceof UDIGFeatureStore) {
                    try {
                        DataStore store = (DataStore)layer;
                        SimpleFeatureSource featureStore = store.getFeatureSource(store.getTypeNames()[0]);
                        ReferencedEnvelope envelope = featureStore.getBounds();
                        ProcessingRegionStyle style = this.getActiveRegionStyle();
                        ProcessingRegion activeWindow = new ProcessingRegion(style.west, style.east, style.south, style.north, style.rows, style.cols);
                        ProcessingRegion newWindow = ProcessingRegion.adaptActiveRegionToEnvelope((Envelope)envelope, activeWindow);
                        this.northText.setText(String.valueOf(newWindow.getNorth()));
                        this.southText.setText(String.valueOf(newWindow.getSouth()));
                        this.eastText.setText(String.valueOf(newWindow.getEast()));
                        this.westText.setText(String.valueOf(newWindow.getWest()));
                        this.textModified(0);
                        continue;
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                        return;
                    }
                }
                return;
            }
            if (text == null) {
                return;
            }
        }
    }

    public void preApply() {
        double n = Double.parseDouble(this.northText.getText());
        double s = Double.parseDouble(this.southText.getText());
        double w = Double.parseDouble(this.westText.getText());
        double e = Double.parseDouble(this.eastText.getText());
        double xr = Double.parseDouble(this.xresText.getText());
        double yr = Double.parseDouble(this.yresText.getText());
        ProcessingRegion newRegion = new ProcessingRegion(w, e, s, n, xr, yr);
        this.style.fAlpha = Float.parseFloat(this.forgroundAlphaText.getText());
        this.style.bAlpha = Float.parseFloat(this.backgroundAlphaText.getText());
        RGB bg = this.backgroundColour.getColorValue();
        this.style.backgroundColor = new Color(bg.red, bg.green, bg.blue);
        bg = this.foregroundColor.getColorValue();
        this.style.foregroundColor = new Color(bg.red, bg.green, bg.blue);
        this.commitToBlackboards(newRegion);
        super.preApply();
    }

    private void commitToBlackboards(ProcessingRegion jgR) {
        this.blackboard = this.getLayer().getStyleBlackboard();
        this.style.north = jgR.getNorth();
        this.style.south = jgR.getSouth();
        this.style.east = jgR.getEast();
        this.style.west = jgR.getWest();
        this.style.rows = jgR.getRows();
        this.style.cols = jgR.getCols();
        this.blackboard.put("eu.udig.omsbox.processingregion.ProcessingRegionStyleContent", (Object)this.style);
        this.getLayer().setStatus(0);
    }

    private synchronized void textModified(int type) {
        this.isWorking = true;
        String northstr = this.northText.getText();
        String southstr = this.southText.getText();
        String eaststr = this.eastText.getText();
        String weststr = this.westText.getText();
        String rowsstr = this.rowsText.getText();
        String colsstr = this.colsText.getText();
        String ewresstr = this.xresText.getText();
        String nsresstr = this.yresText.getText();
        if (northstr.length() == 0 || southstr.length() == 0 || eaststr.length() == 0 || weststr.length() == 0 || rowsstr.length() == 0 || colsstr.length() == 0 || ewresstr.length() == 0 || nsresstr.length() == 0) {
            this.isWorking = false;
            return;
        }
        if (type == 0) {
            int rownum = (int)Math.round((new Double(northstr) - new Double(southstr)) / new Double(nsresstr));
            int colnum = (int)Math.round((new Double(eaststr) - new Double(weststr)) / new Double(ewresstr));
            double newnsres = (new Double(northstr) - new Double(southstr)) / (double)rownum;
            double newewres = (new Double(eaststr) - new Double(weststr)) / (double)colnum;
            this.rowsText.setText(String.valueOf(rownum));
            this.colsText.setText(String.valueOf(colnum));
            this.yresText.setText(String.valueOf(newnsres));
            this.xresText.setText(String.valueOf(newewres));
        } else if (type == 1 || type == 2) {
            int rownum = 0;
            int colnum = 0;
            double newnsres = 0.0;
            double newewres = 0.0;
            if (type == 1) {
                newnsres = (Double.parseDouble(northstr) - Double.parseDouble(southstr)) / Double.parseDouble(rowsstr);
                rownum = (int)Math.round((Double.parseDouble(northstr) - Double.parseDouble(southstr)) / newnsres);
                newnsres = (Double.parseDouble(northstr) - Double.parseDouble(southstr)) / (double)rownum;
                newewres = (Double.parseDouble(eaststr) - Double.parseDouble(weststr)) / Double.parseDouble(colsstr);
                colnum = (int)Math.round((Double.parseDouble(eaststr) - Double.parseDouble(weststr)) / newewres);
                newewres = (Double.parseDouble(eaststr) - Double.parseDouble(weststr)) / (double)colnum;
                this.rowsText.setText(String.valueOf(rownum));
                this.yresText.setText(String.valueOf(newnsres));
                this.colsText.setText(String.valueOf(colnum));
                this.xresText.setText(String.valueOf(newewres));
            } else if (type == 2) {
                double deltaWE;
                double n = Double.parseDouble(northstr);
                double s = Double.parseDouble(southstr);
                double nsRes = Double.parseDouble(nsresstr);
                double e = Double.parseDouble(eaststr);
                double w = Double.parseDouble(weststr);
                double ewRes = Double.parseDouble(ewresstr);
                double deltaNS = (n - s) % nsRes;
                if (deltaNS > 1.0E-5) {
                    s = s + deltaNS - nsRes;
                }
                if ((deltaWE = (e - w) % ewRes) > 0.0) {
                    e = e - deltaWE + ewRes;
                }
                this.southText.setText(String.valueOf(s));
                this.eastText.setText(String.valueOf(e));
                rownum = (int)Math.round((n - s) / nsRes);
                colnum = (int)Math.round((e - w) / ewRes);
                this.rowsText.setText(String.valueOf(rownum));
                this.colsText.setText(String.valueOf(colnum));
            }
        }
        this.isWorking = false;
    }

    private void setWidgetsToWindow(ProcessingRegion window) {
        this.northText.setText(String.valueOf(window.getNorth()));
        this.southText.setText(String.valueOf(window.getSouth()));
        this.westText.setText(String.valueOf(window.getWest()));
        this.eastText.setText(String.valueOf(window.getEast()));
        this.rowsText.setText(String.valueOf(window.getRows()));
        this.colsText.setText(String.valueOf(window.getCols()));
        this.xresText.setText(String.valueOf(window.getWEResolution()));
        this.yresText.setText(String.valueOf(window.getNSResolution()));
    }
}

