/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.omsbox.processingregion;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.util.Collections;
import net.refractions.udig.aoi.AOIListener;
import net.refractions.udig.aoi.IAOIService;
import net.refractions.udig.mapgraphic.MapGraphic;
import net.refractions.udig.mapgraphic.MapGraphicContext;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.ui.ApplicationGIS;
import net.refractions.udig.ui.PlatformGIS;
import net.refractions.udig.ui.graphics.AWTGraphics;
import net.refractions.udig.ui.graphics.ViewportGraphics;
import org.geotools.geometry.jts.ReferencedEnvelope;

public class AOILayerDecorator
implements MapGraphic {
    public static final String ID = "eu.udig.omsbox.processingregion.aoiLayerDecorator";
    private AOIListener serviceWatcher = new AOIListener(){

        public void handleEvent(AOIListener.Event event) {
            ReferencedEnvelope view = ApplicationGIS.getActiveMap().getViewportModel().getBounds();
            for (ILayer layer : ApplicationGIS.getActiveMap().getMapLayers()) {
                if (layer.findGeoResource(AOILayerDecorator.class) == null) continue;
                ApplicationGIS.getActiveMap().getRenderManager().refresh(layer, (Envelope)view);
            }
        }
    };

    protected void listenService(boolean listen) {
        IAOIService aOIService = PlatformGIS.getAOIService();
        if (listen) {
            aOIService.addListener(this.serviceWatcher);
        } else {
            aOIService.removeListener(this.serviceWatcher);
        }
    }

    public void draw(MapGraphicContext context) {
        context.getLayer().setStatus(5);
        this.listenService(true);
        ViewportGraphics graphic = context.getGraphics();
        if (graphic instanceof AWTGraphics) {
            AWTGraphics awtG = (AWTGraphics)graphic;
            Graphics2D g2D = awtG.g;
            RenderingHints hints = new RenderingHints(Collections.EMPTY_MAP);
            hints.add(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
            g2D.addRenderingHints(hints);
        }
        Dimension screen = context.getMapDisplay().getDisplaySize();
        IAOIService aOIService = PlatformGIS.getAOIService();
        Geometry multiGeometry = aOIService.getGeometry();
        if (multiGeometry != null) {
            Geometry geometry;
            Object innerPolygons = null;
            Polygon polygon = null;
            graphic.setColor(new Color(0.5f, 0.5f, 0.5f, 0.5f));
            int screenWidth = screen.width;
            int screenHeight = screen.height;
            GeneralPath path = new GeneralPath(0);
            path.moveTo(0.0f, 0.0f);
            path.lineTo(screenWidth, 0.0f);
            path.lineTo(screenWidth, screenHeight);
            path.lineTo(0.0f, screenHeight);
            path.closePath();
            int g = 0;
            while (g < multiGeometry.getNumGeometries()) {
                geometry = multiGeometry.getGeometryN(g);
                if (geometry.getGeometryType().equals("Polygon")) {
                    polygon = (Polygon)geometry;
                    LineString exterior = polygon.getExteriorRing();
                    int i = 0;
                    while (i < polygon.getNumInteriorRing()) {
                        innerPolygons = innerPolygons == null ? polygon.getInteriorRingN(i) : innerPolygons.union((Geometry)polygon.getInteriorRingN(i));
                        ++i;
                    }
                    Coordinate[] coordinates = exterior.getCoordinates();
                    Point point = null;
                    if (coordinates.length > 0) {
                        point = context.worldToPixel(coordinates[0]);
                        path.moveTo(point.x, point.y);
                    }
                    int c = 0;
                    while (c < coordinates.length) {
                        point = context.worldToPixel(coordinates[c]);
                        path.lineTo(point.x, point.y);
                        ++c;
                    }
                    path.closePath();
                }
                ++g;
            }
            graphic.fill((Shape)path);
            graphic.setColor(new Color(0.5f, 0.5f, 0.5f, 0.75f));
            graphic.setStroke(1, 1);
            graphic.draw((Shape)path);
            if (innerPolygons != null) {
                g = 0;
                while (g < innerPolygons.getNumGeometries()) {
                    path.reset();
                    geometry = innerPolygons.getGeometryN(g);
                    Coordinate[] coordinates = geometry.getCoordinates();
                    Point point = null;
                    if (coordinates.length > 0) {
                        point = context.worldToPixel(coordinates[0]);
                        path.moveTo(point.x, point.y);
                    }
                    int c = 0;
                    while (c < coordinates.length) {
                        point = context.worldToPixel(coordinates[c]);
                        path.lineTo(point.x, point.y);
                        ++c;
                    }
                    path.closePath();
                    graphic.setColor(new Color(0.5f, 0.5f, 0.5f, 0.5f));
                    graphic.fill((Shape)path);
                    graphic.setColor(new Color(0.5f, 0.5f, 0.5f, 0.75f));
                    graphic.draw((Shape)path);
                    ++g;
                }
            }
        }
        context.getLayer().setStatus(0);
        context.getLayer().setStatusMessage("Layer rendered");
    }

    public void dispose() {
        this.listenService(false);
    }
}

