/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.omsbox.core;

import eu.udig.catalog.jgrass.core.JGrassMapGeoResource;
import eu.udig.catalog.jgrass.core.JGrassService;
import eu.udig.catalog.jgrass.utils.JGrassCatalogUtilities;
import eu.udig.omsbox.OmsBoxPlugin;
import eu.udig.omsbox.core.FieldData;
import eu.udig.omsbox.core.IProcessListener;
import eu.udig.omsbox.core.JConsoleOutputConsole;
import eu.udig.omsbox.core.ModuleDescription;
import eu.udig.omsbox.core.OmsScriptExecutor;
import eu.udig.omsbox.utils.OmsBoxConstants;
import eu.udig.omsbox.utils.OmsBoxUtils;
import eu.udig.omsbox.view.widgets.ModuleGui;
import eu.udig.omsbox.view.widgets.ModuleGuiElement;
import java.io.File;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.IServiceFactory;
import net.refractions.udig.catalog.URLUtils;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.command.MapCommand;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.LayerFactory;
import net.refractions.udig.project.internal.commands.AddLayerCommand;
import net.refractions.udig.project.ui.ApplicationGIS;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.data.simple.SimpleFeatureCollection;

public class ScriptHandler {
    private static final String QUOTE = "'";
    private AtomicInteger counter = new AtomicInteger();
    private HashMap<ModuleDescription, String> variableNamesMap = new HashMap();
    private ModuleDescription mainModuleDescription;

    public String genereateScript(ModuleGui moduleGui) throws Exception {
        FieldData fieldData;
        FieldData fieldData2;
        String componentDescription;
        Iterator<ModuleGuiElement> fieldData3;
        String res;
        this.variableNamesMap.clear();
        this.mainModuleDescription = moduleGui.getModuleDescription();
        List<ModuleGuiElement> modulesInputGuiList = moduleGui.getModulesInputGuiList();
        List<ModuleGuiElement> modulesOutputGuiList = moduleGui.getModulesOuputGuiList();
        StringBuilder sb = new StringBuilder();
        for (ModuleGuiElement mgElem : modulesInputGuiList) {
            res = mgElem.validateContent();
            if (res == null) continue;
            sb.append(res);
        }
        for (ModuleGuiElement mgElem : modulesOutputGuiList) {
            res = mgElem.validateContent();
            if (res == null) continue;
            sb.append(res);
        }
        if (sb.length() > 0) {
            Shell shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
            MessageDialog.openWarning((Shell)shell, (String)"WARNING", (String)("The following problems were reported\n" + sb.toString()));
            return null;
        }
        String loggerLevelGui = OmsBoxPlugin.getDefault().retrieveSavedLogLevel();
        String loggerLevelOms = OmsBoxConstants.LOGLEVELS_MAP.get(loggerLevelGui);
        StringBuilder scriptSb = new StringBuilder();
        scriptSb.append("def simulation = new oms3.SimBuilder(logging:'" + loggerLevelOms + "').sim(name:");
        scriptSb.append(QUOTE);
        scriptSb.append(this.mainModuleDescription.getName());
        scriptSb.append(QUOTE);
        scriptSb.append(") {\n\n");
        scriptSb.append("model {\n\n");
        StringBuilder componentsSb = new StringBuilder();
        componentsSb.append("components  {\n");
        componentsSb.append(this.module2ComponenDescription(this.mainModuleDescription));
        for (ModuleGuiElement inElement : modulesInputGuiList) {
            if (!inElement.hasData()) continue;
            fieldData3 = inElement.getFieldData();
            if (((FieldData)((Object)fieldData3)).otherModule == null) continue;
            componentDescription = this.module2ComponenDescription(((FieldData)((Object)fieldData3)).otherModule);
            componentsSb.append(componentDescription);
        }
        for (ModuleGuiElement outElement : modulesOutputGuiList) {
            if (!outElement.hasData()) continue;
            fieldData3 = outElement.getFieldData();
            if (((FieldData)((Object)fieldData3)).otherModule == null) continue;
            componentDescription = this.module2ComponenDescription(((FieldData)((Object)fieldData3)).otherModule);
            componentsSb.append(componentDescription);
        }
        componentsSb.append("}\n\n");
        scriptSb.append(componentsSb.toString());
        StringBuilder parametersSb = new StringBuilder();
        parametersSb.append("parameter  {\n");
        for (ModuleGuiElement inElement : modulesInputGuiList) {
            if (!inElement.hasData()) continue;
            fieldData2 = inElement.getFieldData();
            this.field2ParameterDescription(fieldData2, this.mainModuleDescription, parametersSb);
        }
        for (ModuleGuiElement outElement : modulesOutputGuiList) {
            if (!outElement.hasData()) continue;
            fieldData2 = outElement.getFieldData();
            this.field2ParameterDescription(fieldData2, this.mainModuleDescription, parametersSb);
        }
        parametersSb.append("}\n\n");
        scriptSb.append(parametersSb.toString());
        StringBuilder connectionsSb = new StringBuilder();
        connectionsSb.append("connect  {\n");
        for (ModuleGuiElement inElement : modulesInputGuiList) {
            if (!inElement.hasData()) continue;
            fieldData = inElement.getFieldData();
            this.connectInputModules(this.mainModuleDescription, fieldData, connectionsSb);
        }
        for (ModuleGuiElement outElement : modulesOutputGuiList) {
            if (!outElement.hasData()) continue;
            fieldData = outElement.getFieldData();
            this.connectOutputModules(this.mainModuleDescription, fieldData, connectionsSb);
        }
        connectionsSb.append("}\n\n");
        scriptSb.append(connectionsSb.toString());
        scriptSb.append("}\n");
        scriptSb.append("}\n");
        scriptSb.append("result = simulation.run();\n\n");
        this.dumpSimpleOutputs(scriptSb, this.mainModuleDescription);
        return scriptSb.toString();
    }

    public void runModule(final String scriptId, String script) {
        JConsoleOutputConsole outputConsole = new JConsoleOutputConsole(scriptId);
        outputConsole.clearConsole();
        PrintStream internalStream = outputConsole.internal;
        PrintStream errorStream = outputConsole.err;
        IConsoleManager manager = ConsolePlugin.getDefault().getConsoleManager();
        manager.addConsoles(new IConsole[]{outputConsole});
        manager.showConsoleView((IConsole)outputConsole);
        try {
            OmsScriptExecutor executor = new OmsScriptExecutor();
            executor.addProcessListener(new IProcessListener(){

                @Override
                public void onProcessStopped() {
                    OmsBoxPlugin.getDefault().cleanProcess(scriptId);
                    ScriptHandler.this.loadOutputMaps();
                }
            });
            String loggerLevelGui = OmsBoxPlugin.getDefault().retrieveSavedLogLevel();
            String ramLevel = String.valueOf(OmsBoxPlugin.getDefault().retrieveSavedHeap());
            Process process = executor.exec(script, internalStream, errorStream, loggerLevelGui, ramLevel);
            OmsBoxPlugin.getDefault().addProcess(process, scriptId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadOutputMaps() {
        List<FieldData> outputsList = this.mainModuleDescription.getOutputsList();
        List<FieldData> InputsList = this.mainModuleDescription.getInputsList();
        for (FieldData fieldData : outputsList) {
            if (!fieldData.fieldType.equals(GridCoverage2D.class.getCanonicalName()) && !fieldData.fieldType.equals(SimpleFeatureCollection.class.getCanonicalName()) || fieldData.otherModule == null) continue;
            List<FieldData> inputList2 = fieldData.otherModule.getInputsList();
            for (FieldData fieldData2 : inputList2) {
                String filePath = fieldData2.fieldValue;
                File file = new File(filePath);
                try {
                    if (!file.exists()) continue;
                    this.loadFileInMap(file);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        for (FieldData fieldData : InputsList) {
            if (fieldData.guiHints == null || !fieldData.fieldType.equals(String.class.getCanonicalName()) || !fieldData.guiHints.contains("outfile") || fieldData.fieldValue == null || fieldData.fieldValue.length() <= 0) continue;
            String filePath = fieldData.fieldValue;
            File file = new File(filePath);
            try {
                if (!file.exists()) continue;
                this.loadFileInMap(file);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void loadFileInMap(File file) throws Exception {
        URL fileUrl = file.toURI().toURL();
        CatalogPlugin cp = CatalogPlugin.getDefault();
        IServiceFactory sf = cp.getServiceFactory();
        List services = sf.createService(fileUrl);
        ArrayList<IGeoResource> resources = new ArrayList<IGeoResource>();
        for (IService service : services) {
            List geoResource = service.resources((IProgressMonitor)new NullProgressMonitor());
            if (geoResource == null) continue;
            if (service instanceof JGrassService) {
                for (IGeoResource iGeoResource : geoResource) {
                    URL identifier = iGeoResource.getIdentifier();
                    File newFile = URLUtils.urlToFile((URL)identifier);
                    if (!file.getName().equals(newFile.getName())) continue;
                    File parentFile = file.getParentFile();
                    File newParentFile = newFile.getParentFile();
                    if (parentFile == null || newParentFile == null || !parentFile.getName().equals(newParentFile.getName())) continue;
                    parentFile = parentFile.getParentFile();
                    newParentFile = newParentFile.getParentFile();
                    if (parentFile != null && newParentFile != null) {
                        if (!parentFile.getName().equals(newParentFile.getName())) continue;
                        resources.add(iGeoResource);
                        continue;
                    }
                    resources.add(iGeoResource);
                }
                continue;
            }
            for (IGeoResource iGeoResource : geoResource) {
                resources.add(iGeoResource);
            }
        }
        if (resources.size() == 0) {
            return;
        }
        IMap map = ApplicationGIS.getActiveMap();
        LayerFactory layerFactory = map.getLayerFactory();
        for (IGeoResource resource : resources) {
            if (resource instanceof JGrassMapGeoResource) {
                JGrassMapGeoResource grassMGR = (JGrassMapGeoResource)resource;
                File locationFile = grassMGR.getLocationFile();
                File mapsetFile = grassMGR.getMapsetFile();
                File mapFile = grassMGR.getMapFile();
                JGrassMapGeoResource addedMapToCatalog = JGrassCatalogUtilities.addMapToCatalog((String)locationFile.getAbsolutePath(), (String)mapsetFile.getName(), (String)mapFile.getName(), (String)"grassbinaryraster");
                int index = map.getMapLayers().size();
                ApplicationGIS.addLayersToMap((IMap)map, Arrays.asList(addedMapToCatalog), (int)index);
                continue;
            }
            Layer layer = layerFactory.createLayer(resource);
            AddLayerCommand cmd = new AddLayerCommand(layer);
            map.sendCommandASync((MapCommand)cmd);
        }
    }

    private void dumpSimpleOutputs(StringBuilder scriptSb, ModuleDescription mainModuleDescription) {
        String mainVarName = this.variableNamesMap.get(mainModuleDescription);
        List<FieldData> outputsList = mainModuleDescription.getOutputsList();
        for (FieldData fieldData : outputsList) {
            if (!fieldData.isSimpleType()) continue;
            scriptSb.append("println \"");
            scriptSb.append(fieldData.fieldDescription);
            scriptSb.append(" = \" + result.");
            scriptSb.append(mainVarName);
            scriptSb.append(".");
            scriptSb.append(fieldData.fieldName);
            scriptSb.append("\n");
        }
        scriptSb.append("println \" \"\n\n");
        for (FieldData fieldData : outputsList) {
            String typeStr;
            if (!fieldData.isSimpleArrayType()) continue;
            if (fieldData.fieldType.equals(double[][].class.getCanonicalName()) || fieldData.fieldType.equals(float[][].class.getCanonicalName()) || fieldData.fieldType.equals(int[][].class.getCanonicalName())) {
                typeStr = null;
                if (fieldData.fieldType.equals(double[][].class.getCanonicalName())) {
                    typeStr = "double[][]";
                } else if (fieldData.fieldType.equals(float[][].class.getCanonicalName())) {
                    typeStr = "float[][]";
                } else if (fieldData.fieldType.equals(int[][].class.getCanonicalName())) {
                    typeStr = "int[][]";
                }
                scriptSb.append("println \"");
                scriptSb.append(fieldData.fieldDescription);
                scriptSb.append("\"\n");
                scriptSb.append("println \"-----------------------------------\"\n");
                scriptSb.append(typeStr);
                scriptSb.append(" matrix = result.");
                scriptSb.append(mainVarName);
                scriptSb.append(".");
                scriptSb.append(fieldData.fieldName);
                scriptSb.append("\n");
                scriptSb.append("for( int i = 0; i < matrix.length; i++ ) {\n");
                scriptSb.append("for( int j = 0; j < matrix[0].length; j++ ) {\n");
                scriptSb.append("print matrix[i][j] + \" \";\n");
                scriptSb.append("}\n");
                scriptSb.append("println \" \";\n");
                scriptSb.append("}\n");
                scriptSb.append("\n");
            } else if (fieldData.fieldType.equals(double[].class.getCanonicalName()) || fieldData.fieldType.equals(float[].class.getCanonicalName()) || fieldData.fieldType.equals(int[].class.getCanonicalName())) {
                typeStr = null;
                if (fieldData.fieldType.equals(double[].class.getCanonicalName())) {
                    typeStr = "double[]";
                } else if (fieldData.fieldType.equals(float[].class.getCanonicalName())) {
                    typeStr = "float[]";
                } else if (fieldData.fieldType.equals(int[].class.getCanonicalName())) {
                    typeStr = "int[]";
                }
                scriptSb.append("println \"");
                scriptSb.append(fieldData.fieldDescription);
                scriptSb.append("\"\n");
                scriptSb.append("println \"-----------------------------------\"\n");
                scriptSb.append(typeStr);
                scriptSb.append(" array = result.");
                scriptSb.append(mainVarName);
                scriptSb.append(".");
                scriptSb.append(fieldData.fieldName);
                scriptSb.append("\n");
                scriptSb.append("for( int i = 0; i < array.length; i++ ) {\n");
                scriptSb.append("println array[i] + \" \";\n");
                scriptSb.append("}\n");
                scriptSb.append("\n");
            }
            scriptSb.append("println \" \"\n\n");
        }
    }

    private String module2ComponenDescription(ModuleDescription moduleDescription) {
        StringBuilder sb = new StringBuilder();
        String varName = String.valueOf(moduleDescription.getScriptName()) + this.counter.getAndIncrement();
        this.variableNamesMap.put(moduleDescription, varName);
        sb.append("\t");
        sb.append(QUOTE);
        sb.append(varName);
        sb.append(QUOTE);
        sb.append("\t\t");
        sb.append(QUOTE);
        sb.append(moduleDescription.getScriptName());
        sb.append(QUOTE);
        sb.append("\n");
        return sb.toString();
    }

    private void field2ParameterDescription(FieldData field, ModuleDescription mainModuleDescription, StringBuilder sb) {
        if (field.otherModule == null && field.fieldValue != null && field.fieldValue.length() > 0) {
            String TMPQUOTE = QUOTE;
            if (OmsBoxUtils.isFieldExceptional(field)) {
                TMPQUOTE = "";
            }
            if (field.guiHints != null && field.guiHints.contains("multiline")) {
                TMPQUOTE = "\"\"\"";
            }
            sb.append("\t");
            sb.append(QUOTE);
            sb.append(this.variableNamesMap.get(mainModuleDescription));
            sb.append(".");
            sb.append(field.fieldName);
            sb.append(QUOTE);
            sb.append("\t\t");
            String fieldValue = field.fieldValue;
            sb.append(TMPQUOTE);
            sb.append(fieldValue);
            sb.append(TMPQUOTE);
            sb.append("\n");
        } else if (field.otherModule != null) {
            ModuleDescription otherModule = field.otherModule;
            List<FieldData> inputsList = otherModule.getInputsList();
            for (FieldData fieldData : inputsList) {
                if (fieldData.isSimpleType()) {
                    this.field2ParameterDescription(fieldData, otherModule, sb);
                    continue;
                }
                if (!OmsBoxUtils.isFieldExceptional(fieldData)) continue;
                this.field2ParameterDescription(fieldData, otherModule, sb);
            }
            List<FieldData> outputList = otherModule.getOutputsList();
            for (FieldData fieldData : outputList) {
                if (!fieldData.isSimpleType()) continue;
                this.field2ParameterDescription(fieldData, otherModule, sb);
            }
        }
    }

    private void connectInputModules(ModuleDescription mainModule, FieldData inData, StringBuilder sb) {
        if (inData.otherModule == null) {
            return;
        }
        ModuleDescription otherModule = inData.otherModule;
        sb.append("\t");
        sb.append(QUOTE);
        sb.append(this.variableNamesMap.get(otherModule));
        sb.append(".");
        sb.append(inData.otherFieldName);
        sb.append(QUOTE);
        sb.append("\t\t");
        sb.append(QUOTE);
        sb.append(this.variableNamesMap.get(mainModule));
        sb.append(".");
        sb.append(inData.fieldName);
        sb.append(QUOTE);
        sb.append("\n");
    }

    private void connectOutputModules(ModuleDescription mainModule, FieldData outData, StringBuilder sb) {
        if (outData.otherModule == null) {
            return;
        }
        ModuleDescription otherModule = outData.otherModule;
        sb.append("\t");
        sb.append(QUOTE);
        sb.append(this.variableNamesMap.get(mainModule));
        sb.append(".");
        sb.append(outData.fieldName);
        sb.append(QUOTE);
        sb.append("\t\t");
        sb.append(QUOTE);
        sb.append(this.variableNamesMap.get(otherModule));
        sb.append(".");
        sb.append(outData.otherFieldName);
        sb.append(QUOTE);
        sb.append("\n");
    }
}

