/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.omsbox.core;

import eu.udig.omsbox.OmsBoxPlugin;
import eu.udig.omsbox.core.ConsoleMessageFilter;
import eu.udig.omsbox.core.IProcessListener;
import eu.udig.omsbox.core.OmsModulesManager;
import eu.udig.omsbox.utils.OmsBoxConstants;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oms3.CLI;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.Platform;
import org.joda.time.DateTime;

public class OmsScriptExecutor {
    private String classPath;
    private boolean isRunning = false;
    List<IProcessListener> listeners = new ArrayList<IProcessListener>();
    private String javaFile = OmsBoxPlugin.getUdigJava();

    public OmsScriptExecutor() throws Exception {
        String classpathJars;
        if (!this.javaFile.equals("java")) {
            this.javaFile = "\"" + this.javaFile + "\"";
        }
        this.classPath = classpathJars = OmsBoxPlugin.getDefault().getClasspathJars();
    }

    public Process exec(String script, final PrintStream internalStream, final PrintStream errorStream, String loggerLevelGui, String ramLevel) throws Exception {
        String[] args;
        File tmpRunFile;
        String grassShell;
        File scriptFile;
        if (loggerLevelGui == null) {
            loggerLevelGui = OmsBoxConstants.LOGLEVEL_GUI_OFF;
        }
        if (!(scriptFile = new File(script)).exists()) {
            scriptFile = File.createTempFile("omsbox_script_", ".oms");
            BufferedWriter bw = null;
            try {
                bw = new BufferedWriter(new FileWriter(scriptFile));
                bw.write(script);
            }
            finally {
                bw.close();
            }
        }
        BufferedReader br = null;
        StringBuilder sb = new StringBuilder();
        try {
            br = new BufferedReader(new FileReader(scriptFile));
            String line = null;
            while ((line = br.readLine()) != null) {
                sb.append(line).append("\n");
            }
        }
        finally {
            br.close();
        }
        script = sb.toString();
        String tempdir = System.getProperty("java.io.tmpdir");
        File omsTmp = new File(String.valueOf(tempdir) + File.separator + "oms");
        if (!omsTmp.exists()) {
            omsTmp.mkdirs();
        }
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(this.javaFile);
        String ramExpr = "-Xmx" + ramLevel + "m";
        arguments.add(ramExpr);
        List<String> modulesJars = OmsModulesManager.getInstance().getModulesJars();
        StringBuilder sb2 = new StringBuilder();
        for (String moduleJar : modulesJars) {
            sb2.append(File.pathSeparator).append(moduleJar);
        }
        String modulesJarsString = sb2.toString().replaceFirst(File.pathSeparator, "");
        String resourcesFlag = "-Doms.sim.resources=\"" + modulesJarsString + "\"";
        arguments.add(resourcesFlag);
        String grassGisbase = OmsBoxPlugin.getDefault().getGisbasePreference();
        if (grassGisbase != null && grassGisbase.length() > 0) {
            arguments.add("-D" + OmsBoxConstants.GRASS_ENVIRONMENT_GISBASE_KEY + "=" + grassGisbase);
        }
        if ((grassShell = OmsBoxPlugin.getDefault().getShellPreference()) != null && grassShell.length() > 0) {
            arguments.add("-D" + OmsBoxConstants.GRASS_ENVIRONMENT_SHELL_KEY + "=" + grassShell);
        }
        arguments.add("-cp");
        arguments.add(this.classPath);
        arguments.add(CLI.class.getCanonicalName());
        arguments.add("-r ");
        arguments.add("\"" + scriptFile.getAbsolutePath() + "\"");
        String homeDir = System.getProperty("java.io.tmpdir");
        File homeFile = new File(homeDir);
        StringBuilder runSb = new StringBuilder();
        for (String arg : arguments) {
            runSb.append(arg).append(" ");
        }
        if (Platform.getOS().equals("win32")) {
            tmpRunFile = new File(homeFile, "udig_spatialtoolbox.bat");
            FileUtils.writeStringToFile((File)tmpRunFile, (String)("@echo off\n" + runSb.toString()));
            args = new String[]{"cmd", "/c", tmpRunFile.getAbsolutePath()};
        } else {
            tmpRunFile = new File(homeFile, "udig_spatialtoolbox.sh");
            FileUtils.writeStringToFile((File)tmpRunFile, (String)runSb.toString());
            args = new String[]{"sh", tmpRunFile.getAbsolutePath()};
        }
        ProcessBuilder processBuilder = new ProcessBuilder(args);
        Map<String, String> environment = processBuilder.environment();
        final Process process = processBuilder.start();
        internalStream.println("Process started: " + new DateTime().toString(OmsBoxConstants.dateTimeFormatterYYYYMMDDHHMMSS));
        internalStream.println("");
        if (loggerLevelGui.equals(OmsBoxConstants.LOGLEVEL_GUI_ON)) {
            internalStream.println("------------------------------>8----------------------------");
            internalStream.println("Launching command: ");
            internalStream.println("------------------");
            List<String> command = processBuilder.command();
            for (String arg : command) {
                internalStream.print(arg);
                internalStream.print(" ");
            }
            internalStream.println("\n");
            internalStream.println("(you can run the above from command line, customizing the content)");
            internalStream.println("----------------------------------->8---------------------------------");
            internalStream.println("");
            internalStream.println("Script run: ");
            internalStream.println("-----------");
            internalStream.println(script);
            internalStream.println("");
            internalStream.println("------------------------------>8----------------------------");
            internalStream.println("");
            internalStream.println("Environment used: ");
            internalStream.println("-----------------");
            Set<Map.Entry<String, String>> entrySet = environment.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                internalStream.print(entry.getKey());
                internalStream.print(" =\t");
                internalStream.println(entry.getValue());
            }
            internalStream.println("------------------------------>8----------------------------");
            internalStream.println("");
        }
        internalStream.println("");
        this.isRunning = true;
        new Thread(){

            @Override
            public void run() {
                block15: {
                    BufferedReader br = null;
                    try {
                        try {
                            String line;
                            InputStream is = process.getInputStream();
                            InputStreamReader isr = new InputStreamReader(is);
                            br = new BufferedReader(isr);
                            while ((line = br.readLine()) != null) {
                                internalStream.println(line);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            errorStream.println(e.getLocalizedMessage());
                            if (br != null) {
                                try {
                                    br.close();
                                }
                                catch (IOException e2) {
                                    e2.printStackTrace();
                                }
                            }
                            OmsScriptExecutor.this.isRunning = false;
                            OmsScriptExecutor.this.updateListeners();
                            break block15;
                        }
                    }
                    catch (Throwable throwable) {
                        if (br != null) {
                            try {
                                br.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                        OmsScriptExecutor.this.isRunning = false;
                        OmsScriptExecutor.this.updateListeners();
                        throw throwable;
                    }
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    OmsScriptExecutor.this.isRunning = false;
                    OmsScriptExecutor.this.updateListeners();
                }
                internalStream.println("");
                internalStream.println("");
                internalStream.println("Process finished: " + new DateTime().toString(OmsBoxConstants.dateTimeFormatterYYYYMMDDHHMMSS));
            }
        }.start();
        new Thread(){

            @Override
            public void run() {
                block13: {
                    BufferedReader br = null;
                    try {
                        try {
                            String line;
                            InputStream is = process.getErrorStream();
                            InputStreamReader isr = new InputStreamReader(is);
                            br = new BufferedReader(isr);
                            while ((line = br.readLine()) != null) {
                                if (ConsoleMessageFilter.doRemove(line)) continue;
                                errorStream.println(line);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            errorStream.println(e.getLocalizedMessage());
                            if (br == null) break block13;
                            try {
                                br.close();
                            }
                            catch (IOException e2) {
                                e2.printStackTrace();
                            }
                        }
                    }
                    finally {
                        if (br != null) {
                            try {
                                br.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
            }
        }.start();
        return process;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void addProcessListener(IProcessListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeProcessListener(IProcessListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    private void updateListeners() {
        for (IProcessListener listener : this.listeners) {
            listener.onProcessStopped();
        }
    }
}

