/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.omsbox.core;

import eu.udig.omsbox.core.FieldData;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import oms3.annotations.Name;

public class ModuleDescription {
    private final Class<?> moduleClass;
    private String className;
    private String scriptName;
    private String name;
    private String category;
    private String description;
    private Status status;
    private final int creationTime = (int)(System.currentTimeMillis() / 1000L);
    private List<FieldData> inputsList = new ArrayList<FieldData>();
    private List<FieldData> outputsList = new ArrayList<FieldData>();
    private oms3.annotations.Status omsStatus;

    public ModuleDescription(Class<?> moduleClass, String category, String description, oms3.annotations.Status omsStatus) {
        this.moduleClass = moduleClass;
        this.className = moduleClass.getCanonicalName();
        this.category = category;
        this.description = description;
        this.omsStatus = omsStatus;
        this.name = this.className.substring(this.className.lastIndexOf(46) + 1);
        Name nameAnn = moduleClass.getAnnotation(Name.class);
        this.scriptName = nameAnn != null ? nameAnn.value() : this.className;
        int statusValue = 10;
        if (omsStatus != null) {
            statusValue = omsStatus.value();
        }
        switch (statusValue) {
            case 20: 
            case 30: 
            case 40: {
                this.status = Status.mature;
                break;
            }
            case 5: 
            case 10: {
                this.status = Status.experimental;
                break;
            }
            default: {
                this.status = Status.experimental;
            }
        }
    }

    public void addInput(String fieldName, String type, String description, String defaultValue, String uiHint) {
        if (fieldName == null) {
            throw new IllegalArgumentException("field name is mandatory");
        }
        if (type == null) {
            throw new IllegalArgumentException("field type is mandatory");
        }
        if (description == null) {
            description = "No description available";
        }
        FieldData fieldData = new FieldData();
        fieldData.isIn = true;
        fieldData.fieldName = fieldName;
        fieldData.fieldType = type;
        fieldData.fieldDescription = description;
        fieldData.fieldValue = defaultValue;
        fieldData.guiHints = uiHint;
        if (this.inputsList.contains(fieldData)) {
            throw new IllegalArgumentException("Duplicated field: " + fieldName);
        }
        this.inputsList.add(fieldData);
    }

    public void addOutput(String fieldName, String type, String description, String defaultValue, String uiHint) {
        if (fieldName == null) {
            throw new IllegalArgumentException("field name is mandatory");
        }
        if (type == null) {
            throw new IllegalArgumentException("field type is mandatory");
        }
        if (description == null) {
            description = "No description available";
        }
        FieldData fieldData = new FieldData();
        fieldData.isIn = false;
        fieldData.fieldName = fieldName;
        fieldData.fieldType = type;
        fieldData.fieldDescription = description;
        fieldData.fieldValue = defaultValue;
        fieldData.guiHints = uiHint;
        if (this.outputsList.contains(fieldData)) {
            throw new IllegalArgumentException("Duplicated field: " + fieldName);
        }
        this.outputsList.add(fieldData);
    }

    public String getName() {
        return this.name;
    }

    public String getClassName() {
        return this.className;
    }

    public String getScriptName() {
        return this.scriptName;
    }

    public String getCategory() {
        return this.category;
    }

    public String getDescription() {
        return this.description;
    }

    public Status getStatus() {
        return this.status;
    }

    public List<FieldData> getInputsList() {
        return this.inputsList;
    }

    public List<FieldData> getOutputsList() {
        return this.outputsList;
    }

    public int getCreationTime() {
        return this.creationTime;
    }

    public ModuleDescription makeCopy() {
        ModuleDescription copy = new ModuleDescription(this.moduleClass, this.category, this.description, this.omsStatus);
        List<FieldData> inputsList2 = copy.getInputsList();
        for (FieldData inData : this.inputsList) {
            inputsList2.add(inData.makeCopy());
        }
        List<FieldData> outputList2 = copy.getOutputsList();
        for (FieldData outData : this.outputsList) {
            outputList2.add(outData.makeCopy());
        }
        return copy;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("*************************");
        sb.append("\nModule: ");
        sb.append(this.className);
        sb.append("\nCategory: ");
        sb.append(this.category);
        sb.append("\nDescription: ");
        sb.append(this.description);
        sb.append("\nStatus: ");
        sb.append((Object)this.status);
        sb.append("\nInput fields: ");
        int i = 0;
        while (i < this.inputsList.size()) {
            FieldData input = this.inputsList.get(i);
            sb.append("\n   -> Name: ");
            sb.append(input.fieldName);
            sb.append(", Description: ");
            sb.append(input.fieldDescription);
            sb.append(", Class: ");
            sb.append(input.fieldType);
            ++i;
        }
        sb.append("\nOutput fields: ");
        i = 0;
        while (i < this.outputsList.size()) {
            FieldData output = this.outputsList.get(i);
            sb.append("\n   -> Name: ");
            sb.append(output.fieldName);
            sb.append(", Description: ");
            sb.append(output.fieldDescription);
            sb.append(", Class: ");
            sb.append(output.fieldType);
            ++i;
        }
        sb.append("\n*************************\n");
        return sb.toString();
    }

    public int hashCode() {
        int result = this.creationTime;
        result = 31 * result + (this.category == null ? 0 : this.category.hashCode());
        result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.inputsList == null ? 0 : this.inputsList.hashCode());
        if (this.inputsList != null) {
            for (FieldData inData : this.inputsList) {
                result = 31 * result + inData.fieldValue.hashCode();
            }
        }
        result = 31 * result + (this.outputsList == null ? 0 : this.outputsList.hashCode());
        if (this.outputsList != null) {
            for (FieldData outData : this.outputsList) {
                result = 31 * result + outData.fieldValue.hashCode();
            }
        }
        result = 31 * result + (this.status == null ? 0 : this.status.hashCode());
        return Math.abs(result);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ModuleDescription other = (ModuleDescription)obj;
        if (this.category == null ? other.category != null : !this.category.equals(other.category)) {
            return false;
        }
        if (this.className == null ? other.className != null : !this.className.equals(other.className)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.inputsList == null ? other.inputsList != null : !this.inputsList.equals(other.inputsList)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.outputsList == null ? other.outputsList != null : !this.outputsList.equals(other.outputsList)) {
            return false;
        }
        if (this.status != other.status) {
            return false;
        }
        return this.creationTime == other.getCreationTime();
    }

    public static class ModuleDescriptionNameComparator
    implements Comparator<ModuleDescription> {
        @Override
        public int compare(ModuleDescription m1, ModuleDescription m2) {
            String n1 = m1.getName();
            String n2 = m2.getName();
            return n1.compareTo(n2);
        }
    }

    public static enum Status {
        mature,
        experimental;

    }
}

