/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.omsbox;

import eu.udig.omsbox.processingregion.ProcessingRegionMapGraphic;
import eu.udig.omsbox.utils.ImageCache;
import eu.udig.omsbox.utils.OmsBoxConstants;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.mapgraphic.internal.MapGraphicService;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.ui.ApplicationGIS;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.geotools.data.DataUtilities;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class OmsBoxPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "eu.udig.omsbox";
    private static OmsBoxPlugin plugin;
    public static final String JARPATH_SPLITTER = "@@@";
    public static final String OMSBOX_LOADED_JARS_KEY = "OMSBOX_LOADED_JARS_KEY";
    public static final String OMSBOX_RAM_KEY = "OMSBOX_RAM_KEY";
    public static final String OMSBOX_LOG_KEY = "OMSBOX_LOG_KEY";
    public static final String LAST_CHOSEN_FOLDER = "last_chosen_folder_key";
    private HashMap<String, Process> runningProcessesMap = new HashMap();
    private ILayer processingRegionLayer;
    private boolean doIgnoreProcessingRegion = true;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        ImageCache.getInstance().dispose();
        super.stop(context);
    }

    public static OmsBoxPlugin getDefault() {
        return plugin;
    }

    public String[] retrieveSavedJars() {
        IPreferenceStore preferenceStore = OmsBoxPlugin.getDefault().getPreferenceStore();
        String loadedJars = preferenceStore.getString(OMSBOX_LOADED_JARS_KEY);
        if (loadedJars != null && loadedJars.length() > 0) {
            String[] jarSplits = loadedJars.split(JARPATH_SPLITTER);
            ArrayList<String> existingList = new ArrayList<String>();
            String[] stringArray = jarSplits;
            int n = jarSplits.length;
            int n2 = 0;
            while (n2 < n) {
                String jarPath = stringArray[n2];
                File f = new File(jarPath);
                if (f.exists()) {
                    existingList.add(jarPath);
                }
                ++n2;
            }
            if (existingList.size() == 0) {
                return new String[0];
            }
            String[] existingJarsArray = existingList.toArray(new String[existingList.size()]);
            return existingJarsArray;
        }
        return new String[0];
    }

    public void saveJars(List<String> jarsList) {
        IPreferenceStore preferenceStore = OmsBoxPlugin.getDefault().getPreferenceStore();
        StringBuilder sb = new StringBuilder();
        for (String jarPath : jarsList) {
            sb.append(JARPATH_SPLITTER);
            sb.append(jarPath);
        }
        String jarsPathPref = sb.toString().replaceFirst(JARPATH_SPLITTER, "");
        preferenceStore.putValue(OMSBOX_LOADED_JARS_KEY, jarsPathPref);
    }

    public int retrieveSavedHeap() {
        IPreferenceStore preferenceStore = OmsBoxPlugin.getDefault().getPreferenceStore();
        int savedRam = preferenceStore.getInt(OMSBOX_RAM_KEY);
        if (savedRam <= 0) {
            savedRam = 64;
        }
        return savedRam;
    }

    public void saveHeap(int mem) {
        IPreferenceStore preferenceStore = OmsBoxPlugin.getDefault().getPreferenceStore();
        preferenceStore.setValue(OMSBOX_RAM_KEY, mem);
    }

    public String retrieveSavedLogLevel() {
        IPreferenceStore preferenceStore = OmsBoxPlugin.getDefault().getPreferenceStore();
        String savedLogLevel = preferenceStore.getString(OMSBOX_LOG_KEY);
        if (savedLogLevel.length() == 0) {
            savedLogLevel = "OFF";
        }
        return savedLogLevel;
    }

    public void saveLogLevel(String logLevel) {
        IPreferenceStore preferenceStore = OmsBoxPlugin.getDefault().getPreferenceStore();
        preferenceStore.setValue(OMSBOX_LOG_KEY, logLevel);
    }

    public String getLastFolderChosen() {
        IPreferenceStore store = this.getPreferenceStore();
        String lastFolder = store.getString(LAST_CHOSEN_FOLDER);
        if (lastFolder != null) {
            File f = new File(lastFolder);
            if (f.exists() && f.isDirectory()) {
                return lastFolder;
            }
            if (f.exists() && f.isFile()) {
                return f.getParent();
            }
        }
        return new File(System.getProperty("user.home")).getAbsolutePath();
    }

    public void setLastFolderChosen(String folderPath) {
        IPreferenceStore store = this.getPreferenceStore();
        store.putValue(LAST_CHOSEN_FOLDER, folderPath);
    }

    public String getClasspathJars() throws Exception {
        try {
            int n;
            int n2;
            Object[] objectArray;
            Bundle udigLibsBundle;
            String udigLibsFolderPath;
            Bundle omsBundle;
            String pluginPath;
            StringBuilder sb = new StringBuilder();
            sb.append(".");
            sb.append(File.pathSeparator);
            String sysClassPath = System.getProperty("java.class.path");
            if (sysClassPath != null && sysClassPath.length() > 0 && !sysClassPath.equals("null")) {
                this.addPath(sysClassPath, sb);
                sb.append(File.pathSeparator);
            }
            if ((pluginPath = this.getPath(omsBundle = Platform.getBundle((String)PLUGIN_ID), "/")) != null) {
                this.addPath(pluginPath, sb);
                sb.append(File.pathSeparator);
                this.addPath(String.valueOf(pluginPath) + File.separator + "bin", sb);
            }
            if ((udigLibsFolderPath = this.getPath(udigLibsBundle = Platform.getBundle((String)"net.refractions.udig.libs"), "lib")) != null) {
                sb.append(File.pathSeparator);
                this.addPath(String.valueOf(udigLibsFolderPath) + File.separator + "*", sb);
                File libsPluginPath = new File(udigLibsFolderPath).getParentFile();
                File[] toolsJararray = libsPluginPath.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.startsWith("tools_") && name.endsWith(".jar");
                    }
                });
                if (toolsJararray.length == 1) {
                    sb.append(File.pathSeparator);
                    this.addPath(toolsJararray[0].getAbsolutePath(), sb);
                }
            }
            this.addCustomLibs(sb);
            File extraSpatialtoolboxLibsFolder = OmsBoxPlugin.getExtraSpatialtoolboxLibsFolder();
            if (extraSpatialtoolboxLibsFolder != null) {
                File[] extraJars = extraSpatialtoolboxLibsFolder.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.endsWith(".jar");
                    }
                });
                objectArray = extraJars;
                n2 = extraJars.length;
                n = 0;
                while (n < n2) {
                    Object extraJar = objectArray[n];
                    sb.append(File.pathSeparator);
                    this.addPath(((File)extraJar).getAbsolutePath(), sb);
                    ++n;
                }
            }
            String[] retrieveSavedJars = this.retrieveSavedJars();
            objectArray = retrieveSavedJars;
            n2 = retrieveSavedJars.length;
            n = 0;
            while (n < n2) {
                Object file = objectArray[n];
                sb.append(File.pathSeparator);
                this.addPath((String)file, sb);
                ++n;
            }
            return sb.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void addPath(String path, StringBuilder sb) throws IOException {
        sb.append("\"").append(path).append("\"");
    }

    private void addCustomLibs(StringBuilder sb) throws IOException {
        File pluginsFolder;
        Location installLocation;
        File installFolder;
        Bundle itextBundle;
        String itextFolderPath;
        Bundle log4jBundle = Platform.getBundle((String)"org.apache.log4j");
        String log4jFolderPath = this.getPath(log4jBundle, "/");
        if (log4jFolderPath != null) {
            sb.append(File.pathSeparator);
            this.addPath(String.valueOf(log4jFolderPath) + File.separator + "*", sb);
        }
        if ((itextFolderPath = this.getPath(itextBundle = Platform.getBundle((String)"com.lowagie.itext"), "lib")) != null) {
            sb.append(File.pathSeparator);
            this.addPath(String.valueOf(itextFolderPath) + File.separator + "*", sb);
        }
        if ((installFolder = DataUtilities.urlToFile((URL)(installLocation = Platform.getInstallLocation()).getURL())) != null && installFolder.exists() && (pluginsFolder = new File(installFolder, "plugins")).exists()) {
            File[] files = pluginsFolder.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    boolean isCommonsLog = name.startsWith("org.apache.commons.logging_") && name.endsWith(".jar");
                    return isCommonsLog;
                }
            });
            if (files.length > 1) {
                sb.append(File.pathSeparator);
                this.addPath(files[0].getAbsolutePath(), sb);
            }
            if ((files = pluginsFolder.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    boolean isJunit = name.startsWith("junit") && name.endsWith(".jar");
                    return isJunit;
                }
            })).length > 1) {
                sb.append(File.pathSeparator);
                this.addPath(files[0].getAbsolutePath(), sb);
            }
        }
    }

    public static File getExtraSpatialtoolboxLibsFolder() {
        File omsboxLibsFolder;
        Location installLocation = Platform.getInstallLocation();
        File installFolder = DataUtilities.urlToFile((URL)installLocation.getURL());
        if (installFolder != null && installFolder.exists() && (omsboxLibsFolder = new File(installFolder, "spatialtoolbox")).exists()) {
            return omsboxLibsFolder;
        }
        return null;
    }

    public static String getUdigJava() {
        String jreDirectory;
        File javaFolder;
        int n;
        File jreFolder;
        String[] possibleJava = new String[]{"javaw.exe", "java.exe", "java"};
        Location installLocation = Platform.getInstallLocation();
        File installFolder = DataUtilities.urlToFile((URL)installLocation.getURL());
        if (installFolder != null && installFolder.exists() && (jreFolder = new File(installFolder, "jre/bin")).exists()) {
            String[] stringArray = possibleJava;
            n = possibleJava.length;
            int n2 = 0;
            while (n2 < n) {
                String pJava = stringArray[n2];
                File java = new File(jreFolder, pJava);
                if (java.exists()) {
                    return java.getAbsolutePath();
                }
                ++n2;
            }
        }
        if ((javaFolder = new File(jreDirectory = System.getProperty("java.home"), "jre/bin")).exists()) {
            String[] stringArray = possibleJava;
            int n3 = possibleJava.length;
            n = 0;
            while (n < n3) {
                String pJava = stringArray[n];
                File java = new File(javaFolder, pJava);
                if (java.exists()) {
                    return java.getAbsolutePath();
                }
                ++n;
            }
        }
        return "java";
    }

    public void addProcess(Process process, String id) {
        Process tmp = this.runningProcessesMap.get(id);
        if (tmp != null) {
            tmp.destroy();
        }
        this.runningProcessesMap.put(id, process);
    }

    public void killProcess(String id) {
        Process process = this.runningProcessesMap.get(id);
        if (process != null) {
            this.runningProcessesMap.remove(id);
            process.destroy();
        }
        Set<Map.Entry<String, Process>> entrySet = this.runningProcessesMap.entrySet();
        for (Map.Entry<String, Process> entry : entrySet) {
            String key;
            if (entry.getValue() != null || (key = entry.getKey()) == null) continue;
            this.runningProcessesMap.remove(key);
        }
    }

    public HashMap<String, Process> getRunningProcessesMap() {
        return this.runningProcessesMap;
    }

    public void cleanProcess(String id) {
        this.runningProcessesMap.remove(id);
    }

    private String getPath(Bundle omsBundle, String path) throws IOException {
        URL entry = omsBundle.getEntry(path);
        if (entry == null) {
            return null;
        }
        URL resolvedURL = FileLocator.resolve((URL)entry);
        File file = new File(resolvedURL.getFile());
        return file.getAbsolutePath();
    }

    public ILayer getProcessingRegionMapGraphic() {
        try {
            List mapgraphics = CatalogPlugin.getDefault().getLocalCatalog().find(MapGraphicService.SERVICE_URL, null);
            List members = ((IResolve)mapgraphics.get(0)).members(null);
            for (IResolve resolve : members) {
                if (!resolve.canResolve(ProcessingRegionMapGraphic.class)) continue;
                IMap activeMap = ApplicationGIS.getActiveMap();
                List layers = activeMap.getMapLayers();
                boolean isAlreadyLoaded = false;
                for (ILayer layer : layers) {
                    if (!layer.hasResource(ProcessingRegionMapGraphic.class)) continue;
                    isAlreadyLoaded = true;
                    this.processingRegionLayer = layer;
                }
                if (isAlreadyLoaded) break;
                List addedLayersToMap = ApplicationGIS.addLayersToMap((IMap)activeMap, Collections.singletonList((IGeoResource)resolve.resolve(IGeoResource.class, null)), (int)layers.size());
                for (ILayer l : addedLayersToMap) {
                    IGeoResource geoResource = l.getGeoResource();
                    if (!geoResource.canResolve(ProcessingRegionMapGraphic.class)) continue;
                    this.processingRegionLayer = l;
                }
            }
            return this.processingRegionLayer;
        }
        catch (IOException eek) {
            Status status = new Status(2, PLUGIN_ID, "unable to locate processing region decorator", (Throwable)eek);
            OmsBoxPlugin.getDefault().getLog().log((IStatus)status);
            return null;
        }
    }

    public boolean doIgnoreProcessingRegion() {
        return this.doIgnoreProcessingRegion;
    }

    public void setDoIgnoreProcessingRegion(boolean doIgnoreProcessingRegion) {
        this.doIgnoreProcessingRegion = doIgnoreProcessingRegion;
    }

    public String getGisbasePreference() {
        IPreferenceStore preferenceStore = OmsBoxPlugin.getDefault().getPreferenceStore();
        String savedGisbase = preferenceStore.getString(OmsBoxConstants.GRASS_ENVIRONMENT_GISBASE_KEY);
        return savedGisbase;
    }

    public void setGisbasePreference(String gisbase) {
        IPreferenceStore preferenceStore = OmsBoxPlugin.getDefault().getPreferenceStore();
        preferenceStore.setValue(OmsBoxConstants.GRASS_ENVIRONMENT_GISBASE_KEY, gisbase);
    }

    public String getShellPreference() {
        IPreferenceStore preferenceStore = OmsBoxPlugin.getDefault().getPreferenceStore();
        String savedShell = preferenceStore.getString(OmsBoxConstants.GRASS_ENVIRONMENT_SHELL_KEY);
        return savedShell;
    }

    public void setShellPreference(String shell) {
        IPreferenceStore preferenceStore = OmsBoxPlugin.getDefault().getPreferenceStore();
        preferenceStore.setValue(OmsBoxConstants.GRASS_ENVIRONMENT_SHELL_KEY, shell);
    }

    public String getMapcalcHistory() {
        IPreferenceStore preferenceStore = OmsBoxPlugin.getDefault().getPreferenceStore();
        String savedHistory = preferenceStore.getString(OmsBoxConstants.MAPCALCHISTORY_KEY);
        return savedHistory;
    }

    public void setMapcalcHistory(String mapcalcHistory) {
        IPreferenceStore preferenceStore = OmsBoxPlugin.getDefault().getPreferenceStore();
        preferenceStore.setValue(OmsBoxConstants.MAPCALCHISTORY_KEY, mapcalcHistory);
    }

    public File getConfigurationsFolder() {
        return this.getStateLocation().toFile();
    }

    public static void log(String message) {
        OmsBoxPlugin.getDefault().getLog().log((IStatus)new Status(1, PLUGIN_ID, message));
    }

    public String getWorkingFolder() {
        IPreferenceStore preferenceStore = OmsBoxPlugin.getDefault().getPreferenceStore();
        String workingFolder = preferenceStore.getString("@@@WORKINGFOLDER@@@");
        if (workingFolder.length() == 0) {
            return null;
        }
        return String.valueOf(workingFolder) + "/";
    }

    public void setWorkingFolder(String path) {
        IPreferenceStore preferenceStore = OmsBoxPlugin.getDefault().getPreferenceStore();
        preferenceStore.setValue("@@@WORKINGFOLDER@@@", path);
    }
}

