/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.feature.panel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.refractions.udig.feature.panel.FeaturePanelPageContributor;
import net.refractions.udig.feature.panel.FeaturePanelRegistry;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;

public class FeaturePanelRegistryFactory {
    private static FeaturePanelRegistryFactory INSTANCE = new FeaturePanelRegistryFactory();
    protected Map<SimpleFeatureType, CacheData> idToCacheData = new HashMap<SimpleFeatureType, CacheData>();

    public static FeaturePanelRegistryFactory getInstance() {
        return INSTANCE;
    }

    private FeaturePanelRegistryFactory() {
    }

    public FeaturePanelRegistry createRegistry(FeaturePanelPageContributor target) {
        SimpleFeatureType key = target.getSchema();
        CacheData data = this.idToCacheData.get(key);
        if (data == null) {
            data = new CacheData();
            data.registry = new FeaturePanelRegistry((FeatureType)key);
            data.references = new ArrayList(5);
            this.idToCacheData.put(key, data);
        }
        data.references.add(target);
        return data.registry;
    }

    public void disposeRegistry(FeaturePanelPageContributor target) {
        SimpleFeatureType key = target.getSchema();
        CacheData data = this.idToCacheData.get(key);
        if (data != null) {
            data.references.remove(target);
            if (data.references.isEmpty()) {
                this.idToCacheData.remove(key);
            }
        }
    }

    class CacheData {
        FeaturePanelRegistry registry;
        List references;

        CacheData() {
        }
    }
}

