/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.feature.panel;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.refractions.udig.feature.editor.FeatureEditorPlugin;
import net.refractions.udig.feature.panel.ActionProvider;
import net.refractions.udig.feature.panel.FeaturePanelListContentProvider;
import net.refractions.udig.feature.panel.FeaturePanelTabDescriptor;
import net.refractions.udig.feature.panel.TabLabelProvider;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.ui.IFeatureSite;
import net.refractions.udig.project.ui.feature.FeaturePanelEntry;
import net.refractions.udig.project.ui.feature.FeaturePanelProcessor;
import net.refractions.udig.project.ui.feature.FeatureSiteImpl;
import net.refractions.udig.project.ui.internal.ProjectUIPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.internal.views.properties.tabbed.TabbedPropertyViewPlugin;
import org.eclipse.ui.views.properties.tabbed.ISectionDescriptorProvider;
import org.eclipse.ui.views.properties.tabbed.ITypeMapper;
import org.opengis.feature.type.FeatureType;

public class FeaturePanelRegistry {
    private static final String NO_TAB_ERROR = "Schema {0} declares non-existing tab {1}";
    private static final String CONTRIBUTOR_ERROR = "Contributor {0} cannot be created.";
    private static final String TAB_ERROR = "Tab in {0} declares non-existing category {1}.";
    private static final String EXTPT_CONTRIBUTOR = "propertyContributor";
    private static final String EXTPT_TABS = "propertyTabs";
    private static final String EXTPT_SECTIONS = "propertySections";
    private static final String ELEMENT_TAB = "propertyTab";
    private static final String ELEMENT_SECTION = "propertySection";
    private static final String ELEMENT_PROPERTY_CATEGORY = "propertyCategory";
    private static final String ATT_CATEGORY = "category";
    private static final String ATT_CONTRIBUTOR_ID = "contributorId";
    private static final String ATT_TYPE_MAPPER = "typeMapper";
    private static final String ATT_LABEL_PROVIDER = "labelProvider";
    private static final String ATT_ACTION_PROVIDER = "actionProvider";
    private static final String ATT_SECTION_DESCRIPTOR_PROVIDER = "sectionDescriptorProvider";
    private static final String ATT_TAB_DESCRIPTOR_PROVIDER = "tabDescriptorProvider";
    private static final String ATT_OVERRIDABLE_TAB_LIST_CONTENT_PROVIDER = "overridableTabListContentProvider";
    private static final String TOP = "top";
    protected FeatureType schema;
    protected ILabelProvider labelProvider;
    protected ActionProvider actionProvider;
    protected ITypeMapper typeMapper;
    protected ISectionDescriptorProvider sectionDescriptorProvider;
    protected List<FeaturePanelTabDescriptor> tabDescriptors;
    protected static final List<FeaturePanelTabDescriptor> EMPTY_DESCRIPTOR_ARRAY = Collections.emptyList();

    protected FeaturePanelRegistry(FeatureType schema) {
        this.schema = schema;
        FeaturePanelProcessor featurePanelProcessor = ProjectUIPlugin.getDefault().getFeaturePanelProcessor();
        this.labelProvider = null;
        List list = featurePanelProcessor.search((Object)schema);
        for (FeaturePanelEntry entry : list) {
            ILabelProvider titleProivder = entry.getLabelProvider();
            if (titleProivder == null) continue;
            this.labelProvider = new TabLabelProvider(titleProivder);
            break;
        }
        this.actionProvider = null;
        this.typeMapper = null;
        if (schema == null) {
            this.handleConfigurationError(null, null);
            this.schema = null;
        }
    }

    private void handleConfigurationError(String message, Throwable t) {
        Status status = new Status(t == null ? 2 : 4, FeatureEditorPlugin.getDefault().getBundle().getSymbolicName(), 4, message, t);
        FeatureEditorPlugin.getDefault().getLog().log((IStatus)status);
    }

    private int getIndex(Object[] array, Object target) {
        int i = 0;
        while (i < array.length) {
            if (array[i].equals(target)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public List<FeaturePanelTabDescriptor> getTabDescriptors(IWorkbenchPart part, ISelection selection) {
        if (selection == null || selection.isEmpty()) {
            return EMPTY_DESCRIPTOR_ARRAY;
        }
        List<FeaturePanelTabDescriptor> allDescriptors = this.getAllTabDescriptors();
        List<FeaturePanelTabDescriptor> result = this.filterTabDescriptors(allDescriptors, part, selection);
        return result;
    }

    protected List<FeaturePanelTabDescriptor> filterTabDescriptors(List<FeaturePanelTabDescriptor> descriptors, IWorkbenchPart part, ISelection selection) {
        IFeatureSite site = this.toFeatureSite(selection);
        if (site == null && part.getAdapter(IMap.class) != null) {
            IMap map = (IMap)part.getAdapter(IMap.class);
            site = new FeatureSiteImpl(map);
        } else {
            site = new FeatureSiteImpl();
        }
        ArrayList<FeaturePanelTabDescriptor> result = new ArrayList<FeaturePanelTabDescriptor>();
        for (FeaturePanelTabDescriptor descriptor : descriptors) {
            FeaturePanelEntry entry = descriptor.getEntry();
            if (entry == null) continue;
            if (entry.isMatch((Object)this.schema)) {
                result.add(descriptor);
                continue;
            }
            if (!entry.isChecked(site)) continue;
            result.add(descriptor);
        }
        if (result.size() == 0) {
            return EMPTY_DESCRIPTOR_ARRAY;
        }
        return result;
    }

    private IFeatureSite toFeatureSite(ISelection selection) {
        if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
            IStructuredSelection selected = (IStructuredSelection)selection;
            for (Object item : selected) {
                if (item instanceof ILayer) {
                    return new FeatureSiteImpl((ILayer)item);
                }
                if (item instanceof IMap) {
                    return new FeatureSiteImpl((IMap)item);
                }
                if (!(item instanceof IAdaptable)) continue;
                IAdaptable adaptable = (IAdaptable)item;
                ILayer layer = (ILayer)adaptable.getAdapter(ILayer.class);
                if (layer != null) {
                    return new FeatureSiteImpl(layer);
                }
                IMap map = (IMap)adaptable.getAdapter(IMap.class);
                if (map == null) continue;
                return new FeatureSiteImpl(map);
            }
        }
        return null;
    }

    protected List<FeaturePanelTabDescriptor> getAllTabDescriptors() {
        if (this.tabDescriptors == null) {
            List<FeaturePanelTabDescriptor> temp = this.readTabDescriptors();
            temp = this.sortTabDescriptorsByAfterTab(temp);
            this.tabDescriptors = temp;
        }
        return this.tabDescriptors;
    }

    protected List<FeaturePanelTabDescriptor> readTabDescriptors() {
        ArrayList<FeaturePanelTabDescriptor> result = new ArrayList<FeaturePanelTabDescriptor>();
        FeaturePanelProcessor featurePanelProcessor = ProjectUIPlugin.getDefault().getFeaturePanelProcessor();
        List list = featurePanelProcessor.entries();
        if (list.isEmpty()) {
            return result;
        }
        for (FeaturePanelEntry entry : list) {
            FeaturePanelTabDescriptor descriptor = new FeaturePanelTabDescriptor(entry);
            result.add(descriptor);
        }
        return result;
    }

    protected List<FeaturePanelTabDescriptor> sortTabDescriptorsByAfterTab(List<FeaturePanelTabDescriptor> tabs) {
        if (tabs.size() == 0) {
            return tabs;
        }
        ArrayList<FeaturePanelTabDescriptor> sorted = new ArrayList<FeaturePanelTabDescriptor>();
        sorted.addAll(tabs);
        Collections.sort(sorted, new Comparator<FeaturePanelTabDescriptor>(){

            @Override
            public int compare(FeaturePanelTabDescriptor one, FeaturePanelTabDescriptor two) {
                if (two.getAfterTab().equals(one.getId())) {
                    return -1;
                }
                if (one.getAfterTab().equals(two.getId())) {
                    return 1;
                }
                return 0;
            }
        });
        return sorted;
    }

    public ITypeMapper getTypeMapper() {
        return this.typeMapper;
    }

    public ILabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    public ActionProvider getActionProvider() {
        return this.actionProvider;
    }

    public IStructuredContentProvider getTabListContentProvider() {
        return new FeaturePanelListContentProvider(this);
    }

    private void handleTabError(IConfigurationElement configurationElement, String category) {
        String pluginId = configurationElement.getDeclaringExtension().getNamespaceIdentifier();
        String message = MessageFormat.format(TAB_ERROR, pluginId, category);
        Status status = new Status(4, pluginId, 3, message, null);
        TabbedPropertyViewPlugin.getPlugin().getLog().log((IStatus)status);
    }
}

