/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.feature.panel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.refractions.udig.feature.editor.FeatureEditorPlugin;
import net.refractions.udig.feature.editor.IFeaturePage;
import net.refractions.udig.feature.panel.ActionProvider;
import net.refractions.udig.feature.panel.FeaturePanelComposite;
import net.refractions.udig.feature.panel.FeaturePanelList;
import net.refractions.udig.feature.panel.FeaturePanelPageContributor;
import net.refractions.udig.feature.panel.FeaturePanelRegistry;
import net.refractions.udig.feature.panel.FeaturePanelRegistryFactory;
import net.refractions.udig.feature.panel.FeaturePanelTabDescriptor;
import net.refractions.udig.feature.panel.FeaturePanelTitle;
import net.refractions.udig.feature.panel.FeaturePanelViewer;
import net.refractions.udig.feature.panel.FeaturePanelWidgetFactory;
import net.refractions.udig.feature.panel.TabLabelProvider;
import net.refractions.udig.feature.panel.TabSelectionListener;
import net.refractions.udig.project.ui.IFeaturePanel;
import net.refractions.udig.project.ui.IFeatureSite;
import net.refractions.udig.project.ui.feature.FeaturePanelEntry;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.IContributedContentsView;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.part.PageBookView;
import org.eclipse.ui.views.properties.tabbed.IOverridableTabListContentProvider;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class FeaturePanelPage
extends Page
implements IFeaturePage,
ILabelProviderListener,
ISelectionListener {
    private IFeatureSite site;
    private FeaturePanelComposite tabbedPropertyComposite;
    private FeaturePanelWidgetFactory widgetFactory;
    private FeaturePanelPageContributor contributor;
    private FeaturePanelRegistry registry;
    private FeaturePanelPageContributor selectionContributor = null;
    private SimpleFeatureType currentSchema;
    protected IStructuredContentProvider tabListContentProvider;
    private ISelection currentSelection;
    private boolean activePropertySheet;
    private FeaturePanelViewer tabbedPropertyViewer;
    private IFeaturePanel currentTab;
    private Map<FeaturePanelTabDescriptor, IFeaturePanel> descriptorToTab;
    private Map<IFeaturePanel, Composite> tabToComposite;
    private List<String> selectionQueue;
    private boolean selectionQueueLocked;
    private List<TabSelectionListener> tabSelectionListeners;
    private IWorkbenchWindow cachedWorkbenchWindow;
    private boolean hasTitleBar = true;
    private IPartListener partActivationListener = new IPartListener(){

        public void partActivated(IWorkbenchPart part) {
            FeaturePanelPage.this.handlePartActivated(part);
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
        }
    };

    public FeaturePanelPage(FeaturePanelPageContributor featurePanelPageContributor) {
        this(featurePanelPageContributor, true);
    }

    public FeaturePanelPage(FeaturePanelPageContributor contributor, boolean showTitleBar) {
        this.hasTitleBar = showTitleBar;
        this.contributor = contributor;
        this.tabToComposite = new HashMap<IFeaturePanel, Composite>();
        this.selectionQueue = new ArrayList<String>(10);
        this.tabSelectionListeners = new ArrayList<TabSelectionListener>();
        this.initContributor(contributor.getSchema());
    }

    protected void handlePartActivated(IWorkbenchPart part) {
        IContributedContentsView view;
        boolean thisActivated;
        boolean bl = thisActivated = part instanceof PageBookView && ((PageBookView)part).getCurrentPage() == this;
        if (!(thisActivated || part.equals(this.contributor) || (view = (IContributedContentsView)part.getAdapter(IContributedContentsView.class)) != null && view.getContributingPart() != null && view.getContributingPart().equals(this.contributor))) {
            if (this.activePropertySheet) {
                if (this.currentTab != null) {
                    this.currentTab.aboutToBeHidden();
                }
                this.activePropertySheet = false;
            }
            return;
        }
        if (!this.activePropertySheet && this.currentTab != null) {
            this.currentTab.aboutToBeShown();
            this.currentTab.refresh();
        }
        this.activePropertySheet = true;
    }

    public void createControl(Composite parent) {
        this.widgetFactory = new FeaturePanelWidgetFactory();
        this.tabbedPropertyComposite = new FeaturePanelComposite(parent, this.widgetFactory, this.hasTitleBar);
        this.widgetFactory.paintBordersFor(this.tabbedPropertyComposite);
        this.tabbedPropertyComposite.setLayout((Layout)new FormLayout());
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.top = new FormAttachment(0, 0);
        formData.bottom = new FormAttachment(100, 0);
        this.tabbedPropertyComposite.setLayoutData(formData);
        FeaturePanelList list = this.tabbedPropertyComposite.getList();
        this.tabbedPropertyViewer = new FeaturePanelViewer(list);
        this.tabbedPropertyViewer.setContentProvider((IContentProvider)this.tabListContentProvider);
        this.tabbedPropertyViewer.setLabelProvider((IBaseLabelProvider)new TabbedPropertySheetPageLabelProvider());
        this.tabbedPropertyViewer.addSelectionChangedListener(new SelectionChangedListener());
        this.tabbedPropertyComposite.getScrolledComposite().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                FeaturePanelPage.this.resizeScrolledComposite();
            }
        });
        this.cachedWorkbenchWindow = this.getSite().getWorkbenchWindow();
        this.cachedWorkbenchWindow.getPartService().addPartListener(this.partActivationListener);
        if (this.hasTitleBar) {
            this.registry.getLabelProvider().addListener((ILabelProviderListener)this);
        }
    }

    private void initContributor(SimpleFeatureType schema) {
        this.descriptorToTab = new HashMap<FeaturePanelTabDescriptor, IFeaturePanel>();
        if (this.currentSchema == schema) {
            this.registry = FeaturePanelRegistryFactory.getInstance().createRegistry(this.contributor);
        } else {
            this.selectionContributor = new IFeaturePanelPageContributorFromSelection(schema);
            this.registry = FeaturePanelRegistryFactory.getInstance().createRegistry(this.selectionContributor);
        }
        this.currentSchema = schema;
        this.tabListContentProvider = this.getTabListContentProvider();
        boolean bl = this.hasTitleBar = this.hasTitleBar && this.registry.getLabelProvider() != null;
        if (this.tabbedPropertyViewer != null) {
            this.tabbedPropertyViewer.setContentProvider((IContentProvider)this.tabListContentProvider);
        }
        if (this.hasTitleBar) {
            this.registry.getLabelProvider().addListener((ILabelProviderListener)this);
        }
    }

    protected IStructuredContentProvider getTabListContentProvider() {
        return this.registry.getTabListContentProvider();
    }

    private void disposeContributor() {
        if (this.currentTab != null) {
            this.currentTab.aboutToBeHidden();
            this.currentTab = null;
        }
        this.disposeTabs(this.descriptorToTab.values());
        this.descriptorToTab = new HashMap<FeaturePanelTabDescriptor, IFeaturePanel>();
        if (this.hasTitleBar && this.registry != null) {
            this.registry.getLabelProvider().removeListener((ILabelProviderListener)this);
        }
        if (this.selectionContributor != null) {
            FeaturePanelRegistryFactory.getInstance().disposeRegistry(this.selectionContributor);
            this.selectionContributor = null;
        }
    }

    public void dispose() {
        this.disposeContributor();
        if (this.widgetFactory != null) {
            this.widgetFactory.dispose();
            this.widgetFactory = null;
        }
        if (this.cachedWorkbenchWindow != null) {
            this.cachedWorkbenchWindow.getPartService().removePartListener(this.partActivationListener);
            this.cachedWorkbenchWindow = null;
        }
        if (this.registry != null) {
            this.registry = null;
        }
        this.currentSchema = null;
        this.currentSelection = null;
    }

    public Control getControl() {
        return this.tabbedPropertyComposite;
    }

    public void setActionBars(IActionBars actionBars) {
        IActionBars partActionBars = null;
        if (this.contributor instanceof IEditorPart) {
            IEditorPart editorPart = (IEditorPart)this.contributor;
            partActionBars = editorPart.getEditorSite().getActionBars();
        } else if (this.contributor instanceof IViewPart) {
            IViewPart viewPart = (IViewPart)this.contributor;
            partActionBars = viewPart.getViewSite().getActionBars();
        }
        if (partActionBars != null) {
            IAction action = partActionBars.getGlobalActionHandler(ActionFactory.UNDO.getId());
            if (action != null) {
                actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), action);
            }
            if ((action = partActionBars.getGlobalActionHandler(ActionFactory.REDO.getId())) != null) {
                actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), action);
            }
        }
    }

    public void setFocus() {
        this.getControl().setFocus();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        this.setInput(part, selection);
        this.tabbedPropertyViewer.refresh();
    }

    private void storeCurrentTabSelection(String label) {
        if (!this.selectionQueueLocked) {
            this.selectionQueue.remove(label);
            this.selectionQueue.add(0, label);
        }
    }

    public void resizeScrolledComposite() {
        ScrollBar horizontalScrollBar;
        Composite sizeReference;
        Point currentTabSize = new Point(0, 0);
        if (this.currentTab != null && (sizeReference = this.tabToComposite.get(this.currentTab)) != null) {
            currentTabSize = sizeReference.computeSize(-1, -1);
        }
        this.tabbedPropertyComposite.getScrolledComposite().setMinSize(currentTabSize);
        ScrollBar verticalScrollBar = this.tabbedPropertyComposite.getScrolledComposite().getVerticalBar();
        if (verticalScrollBar != null) {
            Rectangle clientArea = this.tabbedPropertyComposite.getScrolledComposite().getClientArea();
            int increment = clientArea.height - 5;
            verticalScrollBar.setPageIncrement(increment);
        }
        if ((horizontalScrollBar = this.tabbedPropertyComposite.getScrolledComposite().getHorizontalBar()) != null) {
            Rectangle clientArea = this.tabbedPropertyComposite.getScrolledComposite().getClientArea();
            int increment = clientArea.width - 5;
            horizontalScrollBar.setPageIncrement(increment);
        }
    }

    private void disposeTabs(Collection tabs) {
        for (IFeaturePanel tab : tabs) {
            Composite composite = this.tabToComposite.remove(tab);
            tab.dispose();
            if (composite == null) continue;
            composite.dispose();
        }
    }

    private int getLastTabSelection(IWorkbenchPart part, ISelection input) {
        List<FeaturePanelTabDescriptor> descriptors = this.registry.getTabDescriptors(part, input);
        if (!descriptors.isEmpty()) {
            for (String text : this.selectionQueue) {
                int i = 0;
                for (FeaturePanelTabDescriptor descriptor : descriptors) {
                    if (text.equals(descriptor.getLabel())) {
                        return i;
                    }
                    ++i;
                }
            }
        }
        return 0;
    }

    protected void updateTabs(List<FeaturePanelTabDescriptor> descriptors) {
        HashMap<FeaturePanelTabDescriptor, IFeaturePanel> newTabs = new HashMap<FeaturePanelTabDescriptor, IFeaturePanel>(descriptors.size() * 2);
        boolean disposingCurrentTab = this.currentTab != null;
        for (FeaturePanelTabDescriptor descriptor : descriptors) {
            IFeaturePanel tab = this.descriptorToTab.remove(descriptor);
            if (tab != null && tab.controlsHaveBeenCreated()) {
                if (tab == this.currentTab) {
                    disposingCurrentTab = false;
                }
            } else {
                tab = this.createTab(descriptor);
            }
            newTabs.put(descriptor, tab);
        }
        if (disposingCurrentTab) {
            this.currentTab.aboutToBeHidden();
            this.currentTab = null;
        }
        this.disposeTabs(this.descriptorToTab.values());
        this.descriptorToTab = newTabs;
    }

    protected IFeaturePanel createTab(FeaturePanelTabDescriptor tabDescriptor) {
        FeaturePanelEntry entry = tabDescriptor.getEntry();
        return entry.createFeaturePanel();
    }

    private Composite createTabComposite() {
        Composite result = this.widgetFactory.createComposite(this.tabbedPropertyComposite.getTabComposite(), 524288);
        result.setVisible(false);
        result.setLayout((Layout)new FillLayout());
        FormData data = new FormData();
        data.top = this.hasTitleBar ? new FormAttachment((Control)this.tabbedPropertyComposite.getTitle(), 0) : new FormAttachment(0, 0);
        data.bottom = new FormAttachment(100, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        result.setLayoutData((Object)data);
        return result;
    }

    private void setInput(IWorkbenchPart part, ISelection selection) {
        if (selection != null && selection.equals(this.currentSelection)) {
            return;
        }
        this.currentSelection = selection;
        this.validateRegistry(selection);
        List<FeaturePanelTabDescriptor> descriptors = this.registry.getTabDescriptors(part, this.currentSelection);
        if (!descriptors.isEmpty()) {
            this.updateTabs(descriptors);
            ILabelProvider header = null;
            for (FeaturePanelTabDescriptor descriptor : descriptors) {
                header = descriptor.getEntry().getLabelProvider();
            }
            if (header != null) {
                this.tabbedPropertyViewer.setLabelProvider((IBaseLabelProvider)new TabLabelProvider(header));
            } else {
                this.tabbedPropertyViewer.setLabelProvider(null);
            }
        }
        this.tabbedPropertyViewer.setInput(part, this.currentSelection);
        int lastTabSelectionIndex = this.getLastTabSelection(part, this.currentSelection);
        Object selectedTab = this.tabbedPropertyViewer.getElementAt(lastTabSelectionIndex);
        this.selectionQueueLocked = true;
        try {
            if (selectedTab == null) {
                this.tabbedPropertyViewer.setSelection(null);
            } else {
                this.tabbedPropertyViewer.setSelection((ISelection)new StructuredSelection(selectedTab));
            }
        }
        finally {
            this.selectionQueueLocked = false;
        }
        this.refreshTitleBar();
    }

    public void refresh() {
        if (this.currentTab != null) {
            this.currentTab.refresh();
        }
    }

    public IFeaturePanel getCurrentTab() {
        return this.currentTab;
    }

    private void handleTabSelection(FeaturePanelTabDescriptor tabDescriptor) {
        if (this.selectionQueueLocked) {
            return;
        }
        for (TabSelectionListener listener : this.tabSelectionListeners) {
            listener.tabSelected(tabDescriptor);
        }
    }

    public void addTabSelectionListener(TabSelectionListener listener) {
        this.tabSelectionListeners.add(listener);
    }

    public void removeTabSelectionListener(TabSelectionListener listener) {
        this.tabSelectionListeners.remove(listener);
    }

    public void overrideTabs() {
        if (this.tabListContentProvider instanceof IOverridableTabListContentProvider) {
            IOverridableTabListContentProvider overridableTabListContentProvider = (IOverridableTabListContentProvider)this.tabListContentProvider;
            overridableTabListContentProvider.overrideTabs();
        }
    }

    public FeaturePanelWidgetFactory getWidgetFactory() {
        return this.widgetFactory;
    }

    private void refreshTitleBar() {
        if (this.hasTitleBar) {
            FeaturePanelTitle title = this.tabbedPropertyComposite.getTitle();
            if (this.currentTab == null) {
                title.setTitle(null, null);
            } else {
                String text = this.registry.getLabelProvider().getText((Object)this.currentSelection);
                Image image = this.registry.getLabelProvider().getImage((Object)this.currentSelection);
                title.setTitle(text, image);
            }
        }
    }

    public void labelProviderChanged(LabelProviderChangedEvent event) {
        this.refreshTitleBar();
    }

    private FeaturePanelPageContributor getFeaturePanelPageContributor(Object object) {
        if (object instanceof FeaturePanelPageContributor) {
            return (FeaturePanelPageContributor)object;
        }
        if (object instanceof IAdaptable && ((IAdaptable)object).getAdapter(FeaturePanelPageContributor.class) != null) {
            return (FeaturePanelPageContributor)((IAdaptable)object).getAdapter(FeaturePanelPageContributor.class);
        }
        if (Platform.getAdapterManager().hasAdapter(object, FeaturePanelPageContributor.class.getName())) {
            return (FeaturePanelPageContributor)Platform.getAdapterManager().loadAdapter(object, FeaturePanelPageContributor.class.getName());
        }
        return null;
    }

    private void validateRegistry(ISelection selection) {
        SimpleFeatureType selectionSchema;
        if (selection == null) {
            return;
        }
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        if (structuredSelection.size() == 0) {
            return;
        }
        FeaturePanelPageContributor newContributor = this.getFeaturePanelPageContributor(structuredSelection.getFirstElement());
        if (newContributor == null) {
            newContributor = this.contributor;
        }
        if ((selectionSchema = newContributor.getSchema()) == null) {
            return;
        }
        if (selectionSchema.equals((Object)this.currentSchema)) {
            return;
        }
        Iterator i = structuredSelection.iterator();
        i.next();
        while (i.hasNext()) {
            newContributor = this.getFeaturePanelPageContributor(i.next());
            if (newContributor != null && newContributor.getSchema().equals((Object)selectionSchema)) continue;
            if (this.selectionContributor != null) {
                this.disposeContributor();
                this.initContributor(this.contributor.getSchema());
            }
            return;
        }
        this.disposeContributor();
        this.currentSchema = selectionSchema;
        this.initContributor(this.currentSchema);
        this.overrideActionBars();
    }

    private void overrideActionBars() {
        if (this.registry.getActionProvider() != null) {
            ActionProvider actionProvider = this.registry.getActionProvider();
            actionProvider.setActionBars(this.contributor, this.getSite().getActionBars());
        }
    }

    public FeaturePanelTabDescriptor getSelectedTab() {
        Object object;
        int selectedTab = this.tabbedPropertyViewer.getSelectionIndex();
        if (selectedTab != -1 && (object = this.tabbedPropertyViewer.getElementAt(selectedTab)) instanceof FeaturePanelTabDescriptor) {
            return (FeaturePanelTabDescriptor)object;
        }
        return null;
    }

    public List<FeaturePanelTabDescriptor> getActiveTabs() {
        List<FeaturePanelTabDescriptor> elements = this.tabbedPropertyViewer.getElements();
        if (elements != null && elements.size() > 0) {
            return elements;
        }
        return elements;
    }

    public void setSelectedTab(String id) {
        List<FeaturePanelTabDescriptor> elements = this.tabbedPropertyViewer.getElements();
        if (elements != null && elements.size() > 0) {
            for (FeaturePanelTabDescriptor tabDescriptor : elements) {
                if (tabDescriptor.getId() == null || !tabDescriptor.getId().equals(id)) continue;
                this.tabbedPropertyViewer.setSelection((ISelection)new StructuredSelection((Object)tabDescriptor), true);
            }
        }
    }

    public String getTitleText(ISelection selection) {
        if (selection == null) {
            selection = this.currentSelection;
        }
        return this.registry.getLabelProvider().getText((Object)selection);
    }

    public Image getTitleImage(ISelection selection) {
        if (selection == null) {
            selection = this.currentSelection;
        }
        return this.registry.getLabelProvider().getImage((Object)selection);
    }

    @Override
    public void editFeatureChanged(SimpleFeature feature) {
        if (feature != null) {
            StructuredSelection selection = new StructuredSelection((Object)feature);
            this.selectionChanged(null, (ISelection)selection);
        } else {
            this.selectionChanged(null, null);
        }
    }

    @Override
    public IFeatureSite getFeatureSite() {
        return this.site;
    }

    @Override
    public void setFeatureSite(IFeatureSite site) {
        this.site = site;
    }

    private class IFeaturePanelPageContributorFromSelection
    implements FeaturePanelPageContributor {
        private SimpleFeatureType schema;

        public IFeaturePanelPageContributorFromSelection(SimpleFeatureType schema) {
            this.schema = schema;
        }

        @Override
        public SimpleFeatureType getSchema() {
            return this.schema;
        }
    }

    class SelectionChangedListener
    implements ISelectionChangedListener {
        SelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            IFeaturePanel tab = null;
            FeaturePanelTabDescriptor descriptor = (FeaturePanelTabDescriptor)selection.getFirstElement();
            if (descriptor == null) {
                this.hideTab(FeaturePanelPage.this.currentTab);
            } else {
                Composite tabComposite;
                tab = (IFeaturePanel)FeaturePanelPage.this.descriptorToTab.get(descriptor);
                if (tab != FeaturePanelPage.this.currentTab) {
                    this.hideTab(FeaturePanelPage.this.currentTab);
                }
                if ((tabComposite = (Composite)FeaturePanelPage.this.tabToComposite.get(tab)) == null) {
                    tabComposite = FeaturePanelPage.this.createTabComposite();
                    tab.createPartControl(tabComposite);
                    try {
                        tab.init(FeaturePanelPage.this.site, null);
                    }
                    catch (PartInitException e) {
                        Status status = new Status(4, descriptor.getEntry().getId(), "Problem initializing feature panel", (Throwable)e);
                        FeatureEditorPlugin.getDefault().getLog().log((IStatus)status);
                    }
                    FeaturePanelPage.this.tabToComposite.put(tab, tabComposite);
                }
                FeaturePanelPage.this.storeCurrentTabSelection(descriptor.getLabel());
                if (tab != FeaturePanelPage.this.currentTab) {
                    this.showTab(tab);
                }
                tab.refresh();
            }
            FeaturePanelPage.this.tabbedPropertyComposite.getTabComposite().layout(true);
            FeaturePanelPage.this.currentTab = tab;
            FeaturePanelPage.this.resizeScrolledComposite();
            if (descriptor != null) {
                FeaturePanelPage.this.handleTabSelection(descriptor);
            }
        }

        private void showTab(IFeaturePanel target) {
            Composite tabComposite;
            if (target != null && (tabComposite = (Composite)FeaturePanelPage.this.tabToComposite.get(target)) != null) {
                tabComposite.moveAbove(null);
                target.aboutToBeShown();
                tabComposite.setVisible(true);
            }
        }

        private void hideTab(IFeaturePanel currentTab) {
            Composite tabComposite;
            if (currentTab != null && (tabComposite = (Composite)FeaturePanelPage.this.tabToComposite.get(currentTab)) != null) {
                currentTab.aboutToBeHidden();
                tabComposite.setVisible(false);
            }
        }
    }

    class TabbedPropertySheetPageLabelProvider
    extends LabelProvider {
        TabbedPropertySheetPageLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof FeaturePanelTabDescriptor) {
                return ((FeaturePanelTabDescriptor)element).getLabel();
            }
            return null;
        }
    }
}

