/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.feature.editor.field;

import net.refractions.udig.feature.editor.field.StringAttributeField;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.geotools.util.Converters;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;

public class IntegerAttributeField
extends StringAttributeField {
    private int minValidValue = 0;
    private int maxValidValue = Integer.MAX_VALUE;
    private static final int DEFAULT_TEXT_LIMIT = 10;

    protected IntegerAttributeField() {
    }

    public IntegerAttributeField(String name, String labelText, Composite parent) {
        this(name, labelText, parent, 10);
    }

    public IntegerAttributeField(String name, String labelText, Composite parent, int textLimit) {
        this.init(name, labelText);
        this.setTextLimit(textLimit);
        this.setEmptyStringAllowed(false);
        this.setErrorMessage(JFaceResources.getString((String)"IntegerAttributeField.errorMessage"));
        this.createControl(parent);
    }

    public void setValidRange(int min, int max) {
        this.minValidValue = min;
        this.maxValidValue = max;
        this.setErrorMessage(JFaceResources.format((String)"IntegerAttributeField.errorMessageRange", (Object[])new Object[]{new Integer(min), new Integer(max)}));
    }

    @Override
    public boolean checkState() {
        block4: {
            Text text = this.getTextControl();
            if (text == null) {
                return false;
            }
            String numberString = text.getText();
            try {
                int number = Integer.valueOf(numberString);
                if (number < this.minValidValue || number > this.maxValidValue) break block4;
                this.clearErrorMessage();
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                this.showErrorMessage();
                return false;
            }
        }
        this.showErrorMessage();
        return false;
    }

    @Override
    public void doLoad() {
        Object value = this.getFeature().getAttribute(this.getAttributeName());
        Integer thenumber = (Integer)Converters.convert((Object)value, Integer.class);
        this.textField.setText("" + thenumber);
        this.oldValue = "" + thenumber;
    }

    @Override
    protected void doLoadDefault() {
        if (this.textField != null) {
            SimpleFeatureType schema = this.getFeature().getFeatureType();
            AttributeDescriptor descriptor = schema.getDescriptor(this.getAttributeName());
            Object value = descriptor.getDefaultValue();
            Integer thenumber = (Integer)Converters.convert((Object)value, Integer.class);
            this.textField.setText("" + thenumber);
        }
        this.valueChanged();
    }

    @Override
    protected void doStore() {
        SimpleFeatureType schema = this.getFeature().getFeatureType();
        AttributeDescriptor descriptor = schema.getDescriptor(this.getAttributeName());
        Object value = Converters.convert((Object)this.textField, (Class)descriptor.getType().getBinding());
        this.getFeature().setAttribute(this.getAttributeName(), value);
    }

    public int getIntValue() throws NumberFormatException {
        return new Integer(this.getStringValue());
    }

    @Override
    public Text getTextControl(Composite parent) {
        if (this.textField == null) {
            this.textField = new Text(parent, 2050);
            this.textField.setFont(parent.getFont());
            this.textField.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent e) {
                    if (e.keyCode == 8) {
                        IntegerAttributeField.this.valueChanged();
                    }
                    if (e.keyCode >= 48 && e.keyCode <= 57) {
                        IntegerAttributeField.this.valueChanged();
                    }
                }
            });
            this.textField.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    IntegerAttributeField.this.valueChanged();
                }
            });
            this.textField.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    IntegerAttributeField.this.textField = null;
                }
            });
            if (this.textLimit > 0) {
                this.textField.setTextLimit(this.textLimit);
            }
        } else {
            this.checkParent((Control)this.textField, parent);
        }
        return this.textField;
    }
}

