/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.feature.editor.field;

import java.util.ArrayList;
import java.util.List;
import net.refractions.udig.feature.editor.field.AttributeField;
import net.refractions.udig.feature.panel.FeaturePanelWidgetFactory;
import net.refractions.udig.project.ui.IFeaturePanel;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IMessageManager;
import org.eclipse.ui.forms.IMessagePrefixProvider;
import org.eclipse.ui.forms.ManagedForm;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public abstract class FeaturePanel
extends IFeaturePanel
implements IPropertyChangeListener {
    protected List<AttributeField> fields = new ArrayList<AttributeField>();
    protected ScrolledForm scrolled;
    private AttributeField invalidField;
    private boolean isValid;
    private FeaturePanelWidgetFactory widgetFactory;
    private IMessageManager messages;
    private ManagedForm managedForm;
    private Form form;

    public void createPartControl(Composite parent) {
        FeaturePanelWidgetFactory factory = this.getWidgetFactory();
        this.scrolled = factory.createScrolledForm(parent);
        this.form = this.scrolled.getForm();
        this.form.setText(this.getTitle());
        factory.decorateFormHeading(this.form);
        this.managedForm = new ManagedForm((FormToolkit)factory, this.scrolled);
        this.messages = this.managedForm.getMessageManager();
        this.messages.setMessagePrefixProvider(new IMessagePrefixProvider(){

            public String getPrefix(Control control) {
                if (control instanceof Label) {
                    return ((Label)control).getText();
                }
                return null;
            }
        });
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 5;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 8;
        this.scrolled.setLayout((Layout)layout);
        this.scrolled.setFont(parent.getFont());
        this.createFieldEditors();
        this.adjustGridLayout((Composite)this.scrolled);
    }

    protected abstract void createFieldEditors();

    public Composite getParent() {
        return this.scrolled.getBody();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FeaturePanelWidgetFactory getWidgetFactory() {
        FeaturePanel featurePanel = this;
        synchronized (featurePanel) {
            if (this.widgetFactory == null) {
                this.widgetFactory = new FeaturePanelWidgetFactory();
            }
            return this.widgetFactory;
        }
    }

    protected void checkState() {
        boolean valid = true;
        this.invalidField = null;
        for (AttributeField field : this.fields) {
            boolean bl = valid = valid && field.isValid();
            if (valid) continue;
            this.invalidField = field;
            break;
        }
        this.setValid(valid);
    }

    public void setValid(boolean b) {
        boolean oldValue = this.isValid;
        this.isValid = b;
        if (oldValue != this.isValid) {
            this.getSite();
        }
    }

    private int calcNumberOfColumns() {
        int result = 0;
        if (this.fields != null) {
            for (AttributeField field : this.fields) {
                result = Math.max(result, field.getNumberOfControls());
            }
        }
        return result;
    }

    protected void adjustGridLayout(Composite parent) {
        int numColumns = this.calcNumberOfColumns();
        if (parent.getLayout() instanceof GridLayout) {
            ((GridLayout)parent.getLayout()).numColumns = numColumns;
        } else {
            GridLayout layout = new GridLayout();
            layout.numColumns = numColumns;
            layout.marginHeight = 0;
            layout.marginWidth = 8;
            parent.setLayout((Layout)layout);
        }
        if (this.fields != null) {
            for (AttributeField field : this.fields) {
                field.adjustForNumColumns(numColumns);
            }
        }
    }

    protected <F extends AttributeField> F addField(F field) {
        if (field == null) {
            throw new NullPointerException("AttributeField exepcted");
        }
        this.fields.add(field);
        return field;
    }

    public void aboutToBeShown() {
        this.messages.setAutoUpdate(true);
        for (AttributeField field : this.fields) {
            field.setPropertyChangeListener(this);
            field.setFeature(this.getSite().getEditFeature());
            field.doLoad();
        }
    }

    public void refresh() {
        for (AttributeField field : this.fields) {
            field.setFeature(this.getSite().getEditFeature());
            field.doLoad();
        }
    }

    public void aboutToBeHidden() {
        this.messages.setAutoUpdate(false);
        for (AttributeField field : this.fields) {
            field.setPropertyChangeListener(null);
        }
    }

    public void dispose() {
        for (AttributeField field : this.fields) {
            field.dispose();
            field.setPropertyChangeListener(null);
            field.setFeature(null);
        }
        super.dispose();
    }

    public void propertyChange(PropertyChangeEvent event) {
        AttributeField field = (AttributeField)event.getSource();
        if (event.getProperty().equals("attribute_field_is_valid")) {
            boolean isValid = (Boolean)event.getNewValue();
            if (isValid) {
                this.messages.removeMessage((Object)field.getAttributeName(), field.getControl());
                field.getControl().setToolTipText(null);
                this.checkState();
            } else {
                String message = String.valueOf(field.getAttributeName()) + " invalid!";
                this.messages.addMessage((Object)field.getAttributeName(), message, null, 3, field.getControl());
                field.getControl().setToolTipText(message);
                this.invalidField = field;
                this.setValid(isValid);
            }
        }
        if (event.getProperty().equals("attribute_field_value") && field.isValid()) {
            field.store();
        }
    }
}

