/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.feature.editor.field;

import java.util.Collections;
import java.util.List;
import net.refractions.udig.feature.editor.field.AttributeField;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.geotools.util.Converters;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;

public class ComboAttributeField2
extends AttributeField {
    private ComboViewer viewer;
    private List<?> options;
    private ISelectionChangedListener listener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            IStructuredSelection sel = (IStructuredSelection)event.getSelection();
            ComboAttributeField2.this.fireValueChanged("attribute_field_value", null, sel.getFirstElement());
        }
    };

    public ComboAttributeField2(String name, String labelText, List<?> values, Composite parent) {
        this.init(name, labelText);
        this.options = values;
        this.createControl(parent);
    }

    @Override
    public Control getControl() {
        if (this.viewer != null) {
            return this.viewer.getControl();
        }
        return null;
    }

    @Override
    public void adjustForNumColumns(int numColumns) {
        if (numColumns > 1) {
            Label control = this.getLabelControl();
            int left = numColumns;
            if (control != null) {
                ((GridData)control.getLayoutData()).horizontalSpan = 1;
                --left;
            }
            ((GridData)this.viewer.getCombo().getLayoutData()).horizontalSpan = left;
        } else {
            Label control = this.getLabelControl();
            if (control != null) {
                ((GridData)control.getLayoutData()).horizontalSpan = 1;
            }
            ((GridData)this.viewer.getCombo().getLayoutData()).horizontalSpan = 1;
        }
    }

    @Override
    protected void doFillIntoGrid(Composite parent, int numColumns) {
        int comboC = 1;
        if (numColumns > 1) {
            comboC = numColumns - 1;
        }
        Label control = this.getLabelControl(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = 1;
        control.setLayoutData((Object)gd);
        control = this.getComboBoxControl(parent);
        gd = new GridData();
        gd.horizontalSpan = comboC;
        gd.horizontalAlignment = 4;
        control.setLayoutData((Object)gd);
        control.setFont(parent.getFont());
    }

    @Override
    public void doLoad() {
        Object value = this.getFeature().getAttribute(this.getAttributeName());
        if (this.viewer.getInput() == null) {
            this.viewer.setInput(Collections.singletonList(value));
        }
        StructuredSelection selection = value == null ? StructuredSelection.EMPTY : new StructuredSelection(value);
        this.viewer.removeSelectionChangedListener(this.listener);
        this.viewer.setSelection((ISelection)selection, true);
        this.viewer.addSelectionChangedListener(this.listener);
    }

    @Override
    protected void doLoadDefault() {
        SimpleFeatureType schema = this.getFeature().getFeatureType();
        AttributeDescriptor descriptor = schema.getDescriptor(this.getAttributeName());
        Object value = descriptor.getDefaultValue();
        StructuredSelection selection = new StructuredSelection(value);
        this.viewer.removeSelectionChangedListener(this.listener);
        this.viewer.setSelection((ISelection)selection, true);
        this.viewer.addSelectionChangedListener(this.listener);
    }

    @Override
    protected void doStore() {
        ISelection selection = this.viewer.getSelection();
        if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
            IStructuredSelection sel = (IStructuredSelection)selection;
            Object value = sel.getFirstElement();
            this.getFeature().setAttribute(this.getAttributeName(), value);
        } else {
            SimpleFeatureType schema = this.getFeature().getFeatureType();
            AttributeDescriptor descriptor = schema.getDescriptor(this.getAttributeName());
            String text = this.viewer.getCombo().getText();
            Object value = Converters.convert((Object)text, (Class)descriptor.getType().getBinding());
            this.getFeature().setAttribute(this.getAttributeName(), value);
        }
    }

    @Override
    public int getNumberOfControls() {
        return 2;
    }

    private Combo getComboBoxControl(Composite parent) {
        if (this.viewer == null) {
            this.viewer = new ComboViewer(parent, 8);
            this.viewer.getCombo().setFont(parent.getFont());
            this.viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
            this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
            this.viewer.setInput(this.options);
            this.viewer.addSelectionChangedListener(this.listener);
        }
        return this.viewer.getCombo();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.viewer.getCombo() != null && !this.viewer.getCombo().isDisposed()) {
            this.viewer.getCombo().setEnabled(enabled);
        }
    }

    public ComboViewer getViewer() {
        return this.viewer;
    }
}

