/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.feature.editor.field;

import net.refractions.udig.feature.editor.field.AttributeField;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.geotools.util.Converters;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;

public class BooleanAttributeField
extends AttributeField {
    public static final int DEFAULT = 0;
    public static final int SEPARATE_LABEL = 1;
    private int style;
    private boolean wasSelected;
    private Button checkBox = null;
    protected final Object YES;
    protected final Object NO;

    public Button getControl() {
        return this.checkBox;
    }

    protected BooleanAttributeField() {
        this.YES = Boolean.TRUE;
        this.NO = Boolean.FALSE;
    }

    public BooleanAttributeField(String name, String labelText, int style, Composite parent) {
        this.init(name, labelText);
        this.style = style;
        this.YES = Boolean.TRUE;
        this.NO = Boolean.FALSE;
        this.createControl(parent);
    }

    public BooleanAttributeField(String name, String labelText, int style, Composite parent, Object yes, Object no) {
        this.init(name, labelText);
        this.style = style;
        this.YES = yes;
        this.NO = no;
        this.createControl(parent);
    }

    public BooleanAttributeField(String name, String label, Composite parent) {
        this(name, label, 0, parent);
    }

    @Override
    public void adjustForNumColumns(int numColumns) {
        if (this.style == 1) {
            --numColumns;
        }
        ((GridData)this.checkBox.getLayoutData()).horizontalSpan = numColumns;
    }

    @Override
    protected void doFillIntoGrid(Composite parent, int numColumns) {
        String text = this.getLabelText();
        switch (this.style) {
            case 1: {
                this.getLabelControl(parent);
                --numColumns;
                text = null;
            }
        }
        this.checkBox = this.getChangeControl(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = numColumns;
        this.checkBox.setLayoutData((Object)gd);
        if (text != null) {
            this.checkBox.setText(text);
        }
    }

    public Control getDescriptionControl(Composite parent) {
        if (this.style == 1) {
            return this.getLabelControl(parent);
        }
        return this.getChangeControl(parent);
    }

    @Override
    public void doLoad() {
        if (this.checkBox != null) {
            Object value = this.getFeature().getAttribute(this.getAttributeName());
            Boolean check = this.toBoolean(value);
            this.checkBox.setSelection(check.booleanValue());
            this.wasSelected = check;
        }
    }

    private Boolean toBoolean(Object value) {
        Object test;
        if (this.YES.equals(value)) {
            return true;
        }
        if (this.NO.equals(value)) {
            return false;
        }
        Class<?> target = this.YES.getClass();
        if (Boolean.class.isAssignableFrom(target)) {
            Boolean check = (Boolean)Converters.convert((Object)value, target);
            if (check != null) {
                return check;
            }
            if (value instanceof Number) {
                Number number = (Number)value;
                check = number.longValue() != 0L;
            }
        }
        if ((test = Converters.convert((Object)value, target)) != null && this.YES.equals(test)) {
            return true;
        }
        if (test != null && this.NO.equals(test)) {
            return false;
        }
        Object sure = Converters.convert((Object)this.YES, target);
        Object huh = Converters.convert((Object)this.NO, target);
        if (sure != null && sure.equals(value)) {
            return true;
        }
        if (huh != null && huh.equals(value)) {
            return false;
        }
        return false;
    }

    @Override
    protected void doLoadDefault() {
        if (this.checkBox != null) {
            SimpleFeatureType schema = this.getFeature().getFeatureType();
            AttributeDescriptor descriptor = schema.getDescriptor(this.getAttributeName());
            Object value = descriptor.getDefaultValue();
            Boolean check = this.toBoolean(value);
            this.checkBox.setSelection(check.booleanValue());
            this.wasSelected = check;
        }
    }

    @Override
    protected void doStore() {
        SimpleFeatureType schema = this.getFeature().getFeatureType();
        AttributeDescriptor descriptor = schema.getDescriptor(this.getAttributeName());
        Class binding = descriptor.getType().getBinding();
        boolean check = this.checkBox.getSelection();
        Object checkValue = check ? this.YES : this.NO;
        Object value = Converters.convert((Object)checkValue, (Class)binding);
        this.getFeature().setAttribute(this.getAttributeName(), value);
    }

    public boolean getBooleanValue() {
        return this.checkBox.getSelection();
    }

    protected Button getChangeControl(Composite parent) {
        if (this.checkBox == null) {
            this.checkBox = new Button(parent, 16416);
            this.checkBox.setFont(parent.getFont());
            this.checkBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    boolean isSelected = BooleanAttributeField.this.checkBox.getSelection();
                    BooleanAttributeField.this.valueChanged(BooleanAttributeField.this.wasSelected, isSelected);
                    BooleanAttributeField.this.wasSelected = isSelected;
                }
            });
            this.checkBox.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    BooleanAttributeField.this.checkBox = null;
                }
            });
        } else {
            this.checkParent((Control)this.checkBox, parent);
        }
        return this.checkBox;
    }

    @Override
    public int getNumberOfControls() {
        switch (this.style) {
            case 1: {
                return 2;
            }
        }
        return 1;
    }

    @Override
    public void setFocus() {
        if (this.checkBox != null) {
            this.checkBox.setFocus();
        }
    }

    @Override
    public void setLabelText(String text) {
        super.setLabelText(text);
        Label label = this.getLabelControl();
        if (label == null && this.checkBox != null) {
            this.checkBox.setText(text);
        }
    }

    protected void valueChanged(boolean oldValue, boolean newValue) {
        this.setPresentsDefaultValue(false);
        if (oldValue != newValue) {
            this.fireStateChanged("attribute_field_value", oldValue, newValue);
        }
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.style == 1) {
            super.setVisible(visible);
        }
        if (this.checkBox != null && !this.checkBox.isDisposed()) {
            this.checkBox.setVisible(visible);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.style == 1) {
            super.setEnabled(enabled);
        }
        if (this.checkBox != null && !this.checkBox.isDisposed()) {
            this.checkBox.setEnabled(enabled);
        }
    }

    public String getStringValue() {
        if (this.YES == Integer.valueOf(1)) {
            System.out.println("Retired");
            return "1";
        }
        System.out.println("un Retired");
        return "0";
    }
}

