/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.feature.editor.field;

import net.refractions.udig.project.ui.IFeaturePanel;
import net.refractions.udig.project.ui.IFeatureSite;
import net.refractions.udig.project.ui.feature.EditFeature;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.type.Name;

public abstract class AttributeField {
    public static final String IS_VALID = "attribute_field_is_valid";
    public static final String VALUE = "attribute_field_value";
    private EditFeature feature;
    private String attributeName;
    private Name name;
    private boolean isDefaultPresented = false;
    protected String labelText;
    private Label label;
    private IPropertyChangeListener propertyChangeListener;
    private IFeaturePanel page;

    protected AttributeField() {
    }

    protected AttributeField(String name, String labelText, Composite parent) {
        this.init(name, labelText);
        this.createControl(parent);
    }

    public abstract void adjustForNumColumns(int var1);

    protected void applyFont() {
    }

    protected void checkParent(Control control, Composite parent) {
        Assert.isTrue((control.getParent() == parent ? 1 : 0) != 0, (String)"Different parents");
    }

    protected void clearErrorMessage() {
        if (this.page == null || this.page.getSite() == null) {
            return;
        }
        IFeatureSite site = this.page.getSite();
        if (site.getActionBars() == null || site.getActionBars().getStatusLineManager() == null) {
            return;
        }
        site.getActionBars().getStatusLineManager().setErrorMessage(null);
    }

    protected void clearMessage() {
        if (this.page == null || this.page.getSite() == null) {
            return;
        }
        IFeatureSite site = this.page.getSite();
        if (site.getActionBars() == null || site.getActionBars().getStatusLineManager() == null) {
            return;
        }
        site.getActionBars().getStatusLineManager().setMessage(null);
    }

    protected void createControl(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.numColumns = this.getNumberOfControls();
        layout.marginWidth = 5;
        layout.marginHeight = 0;
        layout.makeColumnsEqualWidth = false;
        layout.horizontalSpacing = 8;
        parent.setLayout((Layout)layout);
        this.doFillIntoGrid(parent, layout.numColumns);
    }

    public void dispose() {
    }

    protected abstract void doFillIntoGrid(Composite var1, int var2);

    public abstract void doLoad();

    protected abstract void doLoadDefault();

    protected abstract void doStore();

    public void fillIntoGrid(Composite parent, int numColumns) {
        Assert.isTrue((numColumns >= this.getNumberOfControls() ? 1 : 0) != 0);
        Assert.isTrue((boolean)(parent.getLayout() instanceof GridLayout));
        this.doFillIntoGrid(parent, numColumns);
    }

    protected void fireStateChanged(String property, boolean oldValue, boolean newValue) {
        if (oldValue == newValue) {
            return;
        }
        Boolean isOld = oldValue ? Boolean.TRUE : Boolean.FALSE;
        Boolean isNew = newValue ? Boolean.TRUE : Boolean.FALSE;
        this.fireValueChanged(property, isOld, isNew);
    }

    protected void fireValueChanged(String property, Object oldValue, Object newValue) {
        if (this.propertyChangeListener == null) {
            return;
        }
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, property, oldValue, newValue);
        this.propertyChangeListener.propertyChange(event);
    }

    public String getFieldEditorFontName() {
        return "org.eclipse.jface.dialogfont";
    }

    public Label getLabelControl() {
        return this.label;
    }

    public abstract Control getControl();

    public Label getLabelControl(Composite parent) {
        if (this.label == null) {
            this.label = new Label(parent, 16384);
            this.label.setFont(parent.getFont());
            String text = this.getLabelText();
            if (text != null) {
                this.label.setText(text);
            }
            this.label.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    AttributeField.this.label = null;
                }
            });
        } else {
            this.checkParent((Control)this.label, parent);
        }
        return this.label;
    }

    public String getLabelText() {
        return this.labelText;
    }

    public abstract int getNumberOfControls();

    public String getAttributeName() {
        return this.attributeName;
    }

    protected IFeaturePanel getFeaturePanel() {
        return this.page;
    }

    public EditFeature getFeature() {
        return this.feature;
    }

    protected void init(String name, String text) {
        Assert.isNotNull((Object)name);
        Assert.isNotNull((Object)text);
        this.attributeName = name;
        this.labelText = text;
    }

    public boolean isValid() {
        return true;
    }

    public void load() {
        if (this.feature != null) {
            this.isDefaultPresented = false;
            this.doLoad();
            this.refreshValidState();
        }
    }

    public void loadDefault() {
        if (this.feature != null) {
            this.isDefaultPresented = true;
            this.doLoadDefault();
            this.refreshValidState();
        }
    }

    public boolean presentsDefaultValue() {
        return this.isDefaultPresented;
    }

    protected void refreshValidState() {
    }

    protected void refreshVisibleState() {
    }

    public void setFocus() {
    }

    public void setLabelText(String text) {
        Assert.isNotNull((Object)text);
        this.labelText = text;
        if (this.label != null) {
            this.label.setText(text);
        }
    }

    public void setAttributeName(String name) {
        this.attributeName = name;
    }

    public void setPage(IFeaturePanel featurePanel) {
        this.page = featurePanel;
    }

    public void setFeature(EditFeature feature) {
        this.feature = feature;
    }

    protected void setPresentsDefaultValue(boolean booleanValue) {
        this.isDefaultPresented = booleanValue;
    }

    public void setPropertyChangeListener(IPropertyChangeListener listener) {
        this.propertyChangeListener = listener;
    }

    protected void showErrorMessage(String msg) {
        if (this.page == null || this.page.getSite() == null) {
            return;
        }
        IFeatureSite site = this.page.getSite();
        if (site.getActionBars() == null || site.getActionBars().getStatusLineManager() == null) {
            return;
        }
        site.getActionBars().getStatusLineManager().setErrorMessage(msg);
    }

    protected void showMessage(String msg) {
        if (this.page == null && this.page.getSite() == null) {
            return;
        }
        IFeatureSite site = this.page.getSite();
        if (site.getActionBars() == null || site.getActionBars().getStatusLineManager() == null) {
            return;
        }
        site.getActionBars().getStatusLineManager().setMessage(msg);
    }

    public void store() {
        if (this.feature == null) {
            return;
        }
        if (this.isDefaultPresented) {
            SimpleFeatureBuilder builder = new SimpleFeatureBuilder(this.feature.getFeatureType());
            SimpleFeature temp = builder.buildFeature(this.feature.getID());
            this.feature.setAttributes(temp.getAttributes());
        } else {
            this.doStore();
        }
    }

    public boolean isVisible() {
        Label check = this.getLabelControl();
        return check != null && !check.isDisposed() && check.isVisible();
    }

    public void setVisible(boolean visible) {
        if (this.getLabelControl() != null && !this.getLabelControl().isDisposed()) {
            this.getLabelControl().setVisible(visible);
        }
        this.getLabelControl().setVisible(visible);
        if (this.getControl() != null && !this.getControl().isDisposed()) {
            this.getControl().setVisible(visible);
        }
    }

    public boolean isEnabled() {
        Label check = this.getLabelControl();
        return check != null && !check.isDisposed() && check.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        if (this.getLabelControl() != null && !this.getLabelControl().isDisposed()) {
            this.getLabelControl().setEnabled(enabled);
        }
        if (this.getControl() != null && !this.getControl().isDisposed()) {
            this.getControl().setEnabled(enabled);
        }
    }
}

