/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.feature.editor;

import net.refractions.udig.feature.panel.FeaturePanelPage;
import net.refractions.udig.feature.panel.FeaturePanelPageContributor;
import net.refractions.udig.internal.ui.UiPlugin;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.internal.Map;
import net.refractions.udig.project.ui.ApplicationGIS;
import net.refractions.udig.project.ui.IFeatureSite;
import net.refractions.udig.project.ui.IUDIGView;
import net.refractions.udig.project.ui.feature.FeatureSiteImpl;
import net.refractions.udig.project.ui.tool.IToolContext;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.MessagePage;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.PageSite;
import org.eclipse.ui.part.ViewPart;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class FeatureUDIGView
extends ViewPart
implements FeaturePanelPageContributor,
IUDIGView {
    public static final String ID = "net.refractions.udig.feature.editor.featureView";
    private IToolContext context;
    private FeaturePanelPage featurePage;
    private MessagePage messagePage;
    private PageBook book;
    private SimpleFeature current;
    private PageSite pageSite;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.pageSite = new PageSite(site);
    }

    public void createPartControl(Composite parent) {
        this.book = new PageBook(parent, 0);
        this.messagePage = new MessagePage();
        this.messagePage.setMessage("Please select a feature with the edit geometry tool");
        this.messagePage.init((IPageSite)this.pageSite);
        this.messagePage.createControl((Composite)this.book);
        this.featurePage = new FeaturePanelPage(this);
        this.featurePage.init((IPageSite)this.pageSite);
        this.featurePage.setFeatureSite((IFeatureSite)new FeatureSiteImpl());
        this.featurePage.createControl((Composite)this.book);
        IMap map = ApplicationGIS.getActiveMap();
        if (map != ApplicationGIS.NO_MAP) {
            try {
                this.editFeatureChanged(map.getEditManager().getEditFeature());
            }
            catch (Throwable e) {
                UiPlugin.log((String)"Default SimpleFeature Editor threw an exception", (Throwable)e);
            }
        }
        this.book.showPage(this.messagePage.getControl());
    }

    @Override
    public SimpleFeatureType getSchema() {
        if (this.current == null) {
            return null;
        }
        return this.current.getFeatureType();
    }

    public void setFocus() {
        if (this.current == null) {
            this.book.showPage(this.messagePage.getControl());
            this.messagePage.setFocus();
            this.featurePage.editFeatureChanged(null);
        } else {
            this.book.showPage(this.featurePage.getControl());
            this.featurePage.setFocus();
            if (this.current == null) {
                this.featurePage.editFeatureChanged(null);
            }
        }
    }

    public void editFeatureChanged(SimpleFeature feature) {
        this.current = feature;
        if (feature == null) {
            this.book.showPage(this.messagePage.getControl());
            return;
        }
        IMap activeMap = ApplicationGIS.getActiveMap();
        IFeatureSite site = this.featurePage.getFeatureSite();
        if (site == null) {
            site = new FeatureSiteImpl(activeMap);
            this.featurePage.setFeatureSite(site);
        } else {
            ((FeatureSiteImpl)site).setMapInternal((Map)activeMap);
            ((FeatureSiteImpl)site).setFeature(feature);
        }
        this.featurePage.editFeatureChanged(feature);
        this.featurePage.refresh();
        this.book.showPage(this.featurePage.getControl());
    }

    public IToolContext getContext() {
        return this.context;
    }

    public void setContext(IToolContext newContext) {
        this.context = newContext;
    }
}

