/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.util;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.IResolveChangeEvent;
import net.refractions.udig.catalog.IResolveDelta;
import net.refractions.udig.catalog.IResolveDeltaVisitor;

public class SearchResolveDeltaVisitor
implements IResolveDeltaVisitor {
    private IResolveDelta found;
    private List<IResolve> path;

    public SearchResolveDeltaVisitor(IResolve handle) {
        this.path = SearchResolveDeltaVisitor.path(handle);
        this.found = null;
    }

    static List<IResolve> path(IResolve handle) {
        IResolve handle2 = handle;
        LinkedList<IResolve> path = new LinkedList<IResolve>();
        while (handle2 != null) {
            path.addFirst(handle2);
            try {
                handle2 = handle2.parent(null);
            }
            catch (IOException iOException) {
                handle2 = null;
            }
        }
        return path;
    }

    public IResolveDelta getFound() {
        return this.found;
    }

    @Override
    public boolean visit(IResolveDelta delta) {
        if (delta.getKind() != IResolveDelta.Kind.NO_CHANGE && this.path.contains(delta.getResolve())) {
            this.found = delta;
        }
        return true;
    }

    public static IResolveDelta search(IResolve handle, IResolveChangeEvent event) {
        if (handle == null || event == null) {
            return null;
        }
        IResolveDelta delta = event.getDelta();
        if (delta == null) {
            return null;
        }
        SearchResolveDeltaVisitor visitor = new SearchResolveDeltaVisitor(handle);
        try {
            delta.accept(visitor);
            return visitor.getFound();
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

