/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.util;

import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import net.refractions.udig.catalog.IGeoResourceInfo;
import net.refractions.udig.catalog.IServiceInfo;
import org.eclipse.core.runtime.IProgressMonitor;
import org.geotools.data.ResourceInfo;
import org.geotools.data.ServiceInfo;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.SimpleInternationalString;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.InternationalString;
import org.opengis.util.ProgressListener;

public class GeoToolsAdapters {
    public static IGeoResourceInfo info(final ResourceInfo info) {
        return new IGeoResourceInfo(){

            @Override
            public ReferencedEnvelope getBounds() {
                return info.getBounds();
            }

            @Override
            public CoordinateReferenceSystem getCRS() {
                return info.getCRS();
            }

            @Override
            public String getDescription() {
                return info.getDescription();
            }

            @Override
            public String getName() {
                return info.getName();
            }

            @Override
            public URI getSchema() {
                return info.getSchema();
            }

            @Override
            public String getTitle() {
                return info.getTitle();
            }
        };
    }

    public static IServiceInfo info(final ServiceInfo info) {
        return new IServiceInfo(){

            @Override
            public String getAbstract() {
                return info.getDescription();
            }

            @Override
            public String getDescription() {
                return info.getDescription();
            }

            @Override
            public Set<String> getKeywords() {
                return new HashSet<String>(info.getKeywords());
            }

            @Override
            public URI getPublisher() {
                return super.getPublisher();
            }

            @Override
            public URI getSchema() {
                return info.getSchema();
            }

            @Override
            public URI getSource() {
                return info.getSource();
            }

            @Override
            public String getTitle() {
                return info.getTitle();
            }
        };
    }

    public static org.geotools.util.ProgressListener progress(final IProgressMonitor monitor) {
        if (monitor == null) {
            return null;
        }
        return new org.geotools.util.ProgressListener(){
            private String description;
            private int progress;
            private InternationalString task;

            public void complete() {
                monitor.done();
            }

            public void dispose() {
                this.description = null;
            }

            public void exceptionOccurred(Throwable arg0) {
            }

            public String getDescription() {
                return this.description;
            }

            public boolean isCanceled() {
                return monitor.isCanceled();
            }

            public void progress(float amount) {
                int current = (int)(100.0 * (double)amount);
                monitor.worked(current - this.progress);
                this.progress = current;
            }

            public void setCanceled(boolean arg0) {
                monitor.setCanceled(true);
            }

            public void setDescription(String text) {
                this.description = text;
            }

            public void started() {
                monitor.beginTask(this.description, 100);
            }

            public void warningOccurred(String arg0, String arg1, String arg2) {
            }

            public InternationalString getTask() {
                return this.task;
            }

            public void setTask(InternationalString task) {
                this.task = task;
            }

            public float getProgress() {
                return this.progress;
            }
        };
    }

    public static IProgressMonitor progress(final ProgressListener monitor) {
        if (monitor == null) {
            return null;
        }
        return new IProgressMonitor(){
            int total;
            int amount;

            public void beginTask(String name, int totalWork) {
                this.amount = 0;
                this.total = totalWork;
                monitor.setTask((InternationalString)new SimpleInternationalString(name));
                monitor.progress(this.work());
            }

            float work() {
                return (float)this.amount / (float)this.total;
            }

            public void done() {
                this.amount = this.total;
                monitor.complete();
                monitor.dispose();
            }

            public void internalWorked(double work) {
            }

            public boolean isCanceled() {
                return monitor.isCanceled();
            }

            public void setCanceled(boolean cancel) {
                monitor.setCanceled(cancel);
            }

            public void setTaskName(String name) {
                monitor.setTask((InternationalString)new SimpleInternationalString(name));
            }

            public void subTask(String name) {
                monitor.setTask((InternationalString)new SimpleInternationalString(name));
            }

            public void worked(int work) {
                this.amount += this.total;
            }
        };
    }

    public static IProgressMonitor progress(final org.geotools.util.ProgressListener monitor) {
        if (monitor == null) {
            return null;
        }
        return new IProgressMonitor(){
            int total;
            int amount;

            public void beginTask(String name, int totalWork) {
                this.amount = 0;
                this.total = totalWork;
                monitor.setDescription(name);
                monitor.progress(this.work());
            }

            float work() {
                return (float)this.amount / (float)this.total;
            }

            public void done() {
                this.amount = this.total;
                monitor.complete();
                monitor.dispose();
            }

            public void internalWorked(double work) {
            }

            public boolean isCanceled() {
                return monitor.isCanceled();
            }

            public void setCanceled(boolean cancel) {
                monitor.setCanceled(cancel);
            }

            public void setTaskName(String name) {
                monitor.setDescription(name);
            }

            public void subTask(String name) {
                monitor.setDescription(name);
            }

            public void worked(int work) {
                this.amount += this.total;
            }
        };
    }
}

