/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.refractions.udig.catalog.CatalogPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.geotools.referencing.CRS;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.InternationalString;

public class CRSUtil {
    public static CoordinateReferenceSystem findEPSGCode(CoordinateReferenceSystem crs, IProgressMonitor monitor) {
        if (!CRSUtil.extractAuthorityCodes(crs).isEmpty()) {
            return crs;
        }
        Set codes = CRS.getSupportedCodes((String)"EPSG");
        monitor.beginTask("Searching for EPSG Code", codes.size());
        for (String string : codes) {
            if (monitor.isCanceled()) {
                return null;
            }
            try {
                CoordinateReferenceSystem loaded = CRS.decode((String)string);
                if (CRS.equalsIgnoreMetadata((Object)loaded, (Object)crs)) {
                    return loaded;
                }
            }
            catch (NoSuchAuthorityCodeException noSuchAuthorityCodeException) {
            }
            catch (FactoryException factoryException) {}
            monitor.worked(1);
        }
        return null;
    }

    public static Collection<String> extractAuthorityCodes(CoordinateReferenceSystem crs) {
        Set identifiers = crs.getIdentifiers();
        HashSet<String> codes = new HashSet<String>();
        block0: for (ReferenceIdentifier identifier : identifiers) {
            InternationalString title = identifier.getAuthority().getTitle();
            if (title.toString().equalsIgnoreCase("EPSG")) {
                codes.add(identifier.toString());
                break;
            }
            Collection alternateTitles = identifier.getAuthority().getAlternateTitles();
            for (InternationalString alternateTitle : alternateTitles) {
                if (!alternateTitle.toString().equalsIgnoreCase("EPSG")) continue;
                codes.add(identifier.toString());
                continue block0;
            }
        }
        return codes;
    }

    public static boolean isCoordinateReferenceSystemImperial(CoordinateReferenceSystem crs) {
        String crs_axis_units;
        block4: {
            crs_axis_units = crs.getCoordinateSystem().getAxis(0).getUnit().toString().toLowerCase();
            if (!crs_axis_units.equals("ft") && !crs_axis_units.startsWith("foot")) break block4;
            return true;
        }
        try {
            if (!crs_axis_units.equals("m") && !crs_axis_units.equals("\u00b0")) {
                CatalogPlugin.trace("Unknown CRS units: " + crs_axis_units, null);
            }
        }
        catch (Exception e) {
            CatalogPlugin.trace("Failed to auto-detect scalebar units from CRS: " + e.toString(), null);
        }
        return false;
    }
}

