/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.util;

import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Stack;
import net.refractions.udig.catalog.util.AST;

public class ASTFactory {
    private ASTFactory() {
    }

    public static AST parse(String str) {
        if (str == null || str.trim().length() == 0) {
            return null;
        }
        List<String> tokens = ASTFactory.tokenize(str);
        Stack<AST> s = new Stack<AST>();
        ListIterator<String> li = tokens.listIterator();
        while (li.hasNext()) {
            ASTFactory.node(s, li);
        }
        if (s.size() == 1) {
            return s.pop();
        }
        if (s.size() > 1) {
            while (s.size() > 1) {
                AST p1 = s.pop();
                AST p2 = s.pop();
                s.push(new And(p1, p2));
            }
            return s.pop();
        }
        System.err.println("An internal error creating an AST may have occured");
        return null;
    }

    protected static List<String> tokenize(String pattern) {
        LinkedList<String> l = new LinkedList<String>();
        int i = 0;
        while (i < pattern.length()) {
            char c = pattern.charAt(i);
            switch (c) {
                case '(': {
                    l.add("(");
                    break;
                }
                case ')': {
                    l.add(")");
                    break;
                }
                case '+': {
                    l.add("+");
                    break;
                }
                case '-': {
                    l.add("-");
                    break;
                }
                case '!': {
                    l.add("!");
                    break;
                }
                case '\"': {
                    int j = pattern.indexOf(34, i + 1);
                    l.add(pattern.substring(i + 1, j));
                    i = j;
                    break;
                }
                case '\t': 
                case '\n': 
                case ' ': {
                    break;
                }
                case 'A': {
                    if (pattern.charAt(i + 1) != 'N' || pattern.charAt(i + 2) != 'D') break;
                    l.add("+");
                    i += 2;
                    break;
                }
                case 'O': {
                    if (pattern.charAt(i + 1) != 'R') break;
                    l.add("-");
                    ++i;
                    break;
                }
                case 'N': {
                    if (pattern.charAt(i + 1) == 'O' && pattern.charAt(i + 2) == 'T') {
                        l.add("!");
                        i += 2;
                    }
                }
                default: {
                    int j = i + 1;
                    while (j < pattern.length() && pattern.charAt(j) != '\"' && pattern.charAt(j) != '+' && pattern.charAt(j) != '-' && pattern.charAt(j) != '!' && pattern.charAt(j) != '(' && pattern.charAt(j) != ')' && pattern.charAt(j) != ' ' && pattern.charAt(j) != '\t' && pattern.charAt(j) != '\n') {
                        ++j;
                    }
                    l.add(pattern.substring(i, j));
                    i = i == j ? j : j - 1;
                }
            }
            ++i;
        }
        return l;
    }

    private static void node(Stack<AST> s, ListIterator<String> li) {
        if (li.hasNext()) {
            String token = li.next();
            char c = token.charAt(0);
            switch (c) {
                case '(': {
                    ASTFactory.node(s, li);
                    break;
                }
                case ')': {
                    break;
                }
                case '+': {
                    AST prev = s.pop();
                    ASTFactory.node(s, li);
                    AST next = s.pop();
                    s.push(new And(prev, next));
                    break;
                }
                case '-': {
                    AST prev = s.pop();
                    ASTFactory.node(s, li);
                    AST next = s.pop();
                    s.push(new Or(prev, next));
                    break;
                }
                case '!': {
                    ASTFactory.node(s, li);
                    AST next = s.pop();
                    s.push(new Not(next));
                    break;
                }
                default: {
                    s.push(new Literal(token));
                }
            }
        }
    }

    private static class And
    implements AST {
        private AST left;
        private AST right;

        private And() {
        }

        public And(AST left, AST right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public boolean accept(String datum) {
            if (datum == null) {
                return false;
            }
            return this.left != null && this.right != null && this.left.accept(datum) && this.right.accept(datum);
        }

        @Override
        public int type() {
            return 1;
        }

        @Override
        public AST getLeft() {
            return this.left;
        }

        @Override
        public AST getRight() {
            return this.right;
        }
    }

    private static class Literal
    implements AST {
        private String value;

        private Literal() {
        }

        public Literal(String value) {
            this.value = value;
        }

        @Override
        public boolean accept(String datum) {
            return this.value != null && datum != null && datum.toUpperCase().indexOf(this.value.toUpperCase()) > -1;
        }

        @Override
        public int type() {
            return 0;
        }

        @Override
        public AST getLeft() {
            return null;
        }

        @Override
        public AST getRight() {
            return null;
        }

        public String toString() {
            return this.value;
        }
    }

    private static class Not
    implements AST {
        private AST child;

        private Not() {
        }

        public Not(AST child) {
            this.child = child;
        }

        @Override
        public boolean accept(String datum) {
            if (datum == null) {
                return false;
            }
            return this.child == null || !this.child.accept(datum);
        }

        @Override
        public int type() {
            return 4;
        }

        @Override
        public AST getLeft() {
            return this.child;
        }

        @Override
        public AST getRight() {
            return null;
        }
    }

    private static class Or
    implements AST {
        private AST left;
        private AST right;

        private Or() {
        }

        public Or(AST left, AST right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public boolean accept(String datum) {
            if (datum == null) {
                return false;
            }
            return this.right != null && this.right.accept(datum) || this.left != null && this.left.accept(datum);
        }

        @Override
        public int type() {
            return 2;
        }

        @Override
        public AST getLeft() {
            return this.left;
        }

        @Override
        public AST getRight() {
            return this.right;
        }
    }
}

