/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.objectproperty;

import java.net.URL;
import java.util.concurrent.atomic.AtomicBoolean;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.IResolveChangeEvent;
import net.refractions.udig.catalog.IResolveChangeListener;
import net.refractions.udig.catalog.IResolveDelta;
import net.refractions.udig.catalog.util.SearchIDDeltaVisitor;
import net.refractions.udig.ui.operations.AbstractPropertyValue;

public class ObjectPropertyCatalogListener
implements IResolveChangeListener {
    Object evaluationObject;
    private URL resourceId;
    private AbstractPropertyValue<? extends Object> owner;
    private AtomicBoolean isEvaluating;

    public ObjectPropertyCatalogListener(Object layer, IGeoResource resource, AtomicBoolean isEvaluating, AbstractPropertyValue<? extends Object> owner) {
        this.evaluationObject = layer;
        this.resourceId = resource.getIdentifier();
        this.isEvaluating = isEvaluating;
        this.owner = owner;
    }

    @Override
    public void changed(IResolveChangeEvent event) {
        if (this.isEvaluating.get()) {
            return;
        }
        IResolveDelta found = SearchIDDeltaVisitor.search(this.resourceId, event);
        if (found != null) {
            this.owner.notifyListeners(this.evaluationObject);
        }
    }
}

