/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.moved;

import java.io.Serializable;
import java.net.URL;
import java.util.Map;
import net.refractions.udig.catalog.AbstractServiceExtention;
import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.catalog.ID;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.moved.MovedService;

public class MovedServiceExtention
extends AbstractServiceExtention {
    public static String ID_KEY = "id";
    public static String FORWARD_KEY = "forward";

    @Override
    public IService createService(URL id, Map<String, Serializable> params) {
        if (id != null) {
            CatalogPlugin.trace("Ignoring requested id=" + id + " for moved service", null);
        }
        URL identifier = (URL)params.get(ID_KEY);
        URL forward = (URL)params.get(FORWARD_KEY);
        if (identifier == null || forward == null) {
            return null;
        }
        return new MovedService(new ID(id), new ID(forward));
    }

    @Override
    public String reasonForFailure(Map<String, Serializable> params) {
        if (!params.containsKey(ID_KEY) || !params.containsKey(FORWARD_KEY)) {
            return null;
        }
        try {
            URL identifier = (URL)params.get(ID_KEY);
            URL forward = (URL)params.get(FORWARD_KEY);
            if (identifier == null || forward == null) {
                return null;
            }
        }
        catch (ClassCastException classCastException) {
            return "ID and FORWARD are required to be URLs";
        }
        return null;
    }
}

