/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.memory.internal;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.URLUtils;
import net.refractions.udig.catalog.memory.MemoryServiceExtensionImpl;
import net.refractions.udig.catalog.memory.internal.MemoryServiceImpl;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.geotools.data.memory.MemoryDataStore;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.opengis.feature.simple.SimpleFeatureType;

public class TemporaryResourceFactory
implements net.refractions.udig.catalog.TemporaryResourceFactory {
    @Override
    public IGeoResource createResource(Object param) throws IOException {
        String localPart;
        SimpleFeatureType featureType = (SimpleFeatureType)param;
        MemoryServiceImpl service = this.getMemoryService();
        MemoryDataStore ds = ((IService)service).resolve(MemoryDataStore.class, (IProgressMonitor)new NullProgressMonitor());
        List<String> typeNamesList = Arrays.asList(ds.getTypeNames());
        if (typeNamesList.contains(localPart = featureType.getName().getLocalPart())) {
            try {
                ds.updateSchema(localPart, featureType);
            }
            catch (Exception exception) {
                String name = this.checkSameName(typeNamesList, localPart);
                SimpleFeatureTypeBuilder simpleFeatureTypeBuilder = new SimpleFeatureTypeBuilder();
                simpleFeatureTypeBuilder.setName(name);
                simpleFeatureTypeBuilder.setCRS(featureType.getCoordinateReferenceSystem());
                List attributeDescriptors = featureType.getAttributeDescriptors();
                simpleFeatureTypeBuilder.addAll(attributeDescriptors);
                featureType = simpleFeatureTypeBuilder.buildFeatureType();
                ds.createSchema(featureType);
            }
        } else {
            ds.createSchema(featureType);
        }
        IGeoResource resource = null;
        for (IResolve iResolve : ((IService)service).resources((IProgressMonitor)new NullProgressMonitor())) {
            IGeoResource r;
            if (!(iResolve instanceof IGeoResource) || !(r = (IGeoResource)iResolve).resolve(SimpleFeatureType.class, (IProgressMonitor)new NullProgressMonitor()).getName().getLocalPart().equals(featureType.getName().getLocalPart())) continue;
            resource = r;
            break;
        }
        return resource;
    }

    private String checkSameName(List<String> typeNamesList, String typeName) {
        int index = 1;
        int i = 0;
        while (i < typeNamesList.size()) {
            String existingTypeName = typeNamesList.get(i);
            if ((existingTypeName = existingTypeName.trim()).equals(typeName)) {
                typeName = typeName.endsWith(")") ? typeName.trim().replaceFirst("\\([0-9]+\\)$", "(" + index++ + ")") : String.valueOf(typeName) + " (" + index++ + ")";
                i = -1;
            }
            if (index == 1000) {
                throw new RuntimeException();
            }
            ++i;
        }
        return typeName;
    }

    private MemoryServiceImpl getMemoryService() {
        MemoryServiceImpl service = null;
        try {
            List<IResolve> members = CatalogPlugin.getDefault().getLocalCatalog().members((IProgressMonitor)new NullProgressMonitor());
            for (IResolve resolve : members) {
                if (!(resolve instanceof MemoryServiceImpl) || !URLUtils.urlEquals(resolve.getIdentifier(), MemoryServiceExtensionImpl.URL, true)) continue;
                service = (MemoryServiceImpl)resolve;
                break;
            }
        }
        catch (IOException e) {
            CatalogPlugin.log("Error finding services", e);
        }
        if (service == null) {
            service = new MemoryServiceImpl(MemoryServiceExtensionImpl.URL);
            CatalogPlugin.getDefault().getLocalCatalog().add(service);
        }
        return service;
    }
}

