/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.memory.internal;

import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.IResolveChangeEvent;
import net.refractions.udig.catalog.IResolveDelta;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.IServiceInfo;
import net.refractions.udig.catalog.ITransientResolve;
import net.refractions.udig.catalog.internal.CatalogImpl;
import net.refractions.udig.catalog.internal.Messages;
import net.refractions.udig.catalog.internal.ResolveChangeEvent;
import net.refractions.udig.catalog.internal.ResolveDelta;
import net.refractions.udig.catalog.memory.ActiveMemoryDataStore;
import net.refractions.udig.catalog.memory.MemoryDSFactory;
import net.refractions.udig.catalog.memory.MemoryServiceExtensionImpl;
import net.refractions.udig.catalog.memory.internal.MemoryGeoResourceImpl;
import net.refractions.udig.catalog.memory.internal.MemoryServiceListener;
import net.refractions.udig.ui.UDIGDisplaySafeLock;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureSource;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;

public class MemoryServiceImpl
extends IService
implements ITransientResolve {
    private volatile ActiveMemoryDataStore ds;
    private volatile List<MemoryGeoResourceImpl> memberList;
    private URL id;
    public Lock rLock = new UDIGDisplaySafeLock();
    private Lock dsInstantiationLock = new UDIGDisplaySafeLock();
    private MemoryDSFactory factory;

    public MemoryServiceImpl(URL id) {
        this(id, null);
    }

    public MemoryServiceImpl(URL id, MemoryDSFactory factory) {
        this.id = id;
        this.factory = factory;
    }

    @Override
    public Map<String, Serializable> getConnectionParams() {
        Map<String, Serializable> params = new MemoryServiceExtensionImpl().createParams(this.getIdentifier());
        List<? extends IGeoResource> member = null;
        try {
            member = this.resources(null);
        }
        catch (IOException e) {
            CatalogPlugin.log("", e);
        }
        if (member != null) {
            StringBuffer buffer = null;
            for (IGeoResource iGeoResource : member) {
                try {
                    SimpleFeatureType type = (SimpleFeatureType)iGeoResource.resolve(FeatureSource.class, null).getSchema();
                    if (buffer == null) {
                        buffer = new StringBuffer();
                    } else {
                        buffer.append("_MEMBER_");
                    }
                    buffer.append(type.getName().getLocalPart());
                    buffer.append("_SPLIT_");
                    buffer.append(DataUtilities.spec((FeatureType)type));
                }
                catch (IOException e) {
                    CatalogPlugin.log("", e);
                }
            }
            if (buffer != null) {
                params.put("MEMBER_PARAM_KEY", (Serializable)((Object)buffer.toString()));
            }
        }
        return params;
    }

    @Override
    public <T> boolean canResolve(Class<T> adaptee) {
        if (adaptee == null) {
            return false;
        }
        return adaptee.isAssignableFrom(ActiveMemoryDataStore.class) || adaptee.isAssignableFrom(ITransientResolve.class) || super.canResolve(adaptee);
    }

    @Override
    public <T> T resolve(Class<T> adaptee, IProgressMonitor monitor) throws IOException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (adaptee == null) {
            throw new NullPointerException("No adaptor specified");
        }
        if (adaptee.isAssignableFrom(ITransientResolve.class)) {
            return adaptee.cast(this);
        }
        if (adaptee.isAssignableFrom(ActiveMemoryDataStore.class)) {
            return adaptee.cast((Object)this.getDS());
        }
        return super.resolve(adaptee, monitor);
    }

    @Override
    public ScratchServiceInfo getInfo(IProgressMonitor monitor) throws IOException {
        return (ScratchServiceInfo)super.getInfo(monitor);
    }

    @Override
    protected synchronized IServiceInfo createInfo(IProgressMonitor monitor) throws IOException {
        return new ScratchServiceInfo();
    }

    @Override
    public List<? extends IGeoResource> resources(IProgressMonitor monitor) throws IOException {
        ActiveMemoryDataStore ds = this.getDS();
        String[] types = ds.getTypeNames();
        if (this.memberList == null) {
            this.rLock.lock();
            try {
                if (this.memberList == null) {
                    this.memberList = new ArrayList<MemoryGeoResourceImpl>();
                    String[] stringArray = types;
                    int n = types.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String type = stringArray[n2];
                        if (!this.found(type)) {
                            this.memberList.add(new MemoryGeoResourceImpl(type, this));
                        }
                        ++n2;
                    }
                }
            }
            finally {
                this.rLock.unlock();
            }
        }
        return this.memberList;
    }

    private boolean found(String type) {
        for (IGeoResource iGeoResource : this.memberList) {
            if (!type.equals(iGeoResource.getIdentifier().getRef())) continue;
            return true;
        }
        return false;
    }

    @Override
    public IResolve.Status getStatus() {
        if (this.isDisposed) {
            return IResolve.Status.DISPOSED;
        }
        return IResolve.Status.CONNECTED;
    }

    @Override
    public Throwable getMessage() {
        return null;
    }

    @Override
    public URL getIdentifier() {
        return this.id;
    }

    ActiveMemoryDataStore getDS() {
        if (this.ds == null) {
            boolean changed = false;
            this.dsInstantiationLock.lock();
            try {
                if (this.ds == null) {
                    this.ds = this.createNewDS();
                    changed = true;
                    this.ds.addListener(new MemoryServiceListener(){

                        @Override
                        public void schemaChanged() {
                            MemoryServiceImpl.this.memberList = null;
                            ResolveDelta delta = new ResolveDelta((IResolve)MemoryServiceImpl.this, IResolveDelta.Kind.CHANGED);
                            ((CatalogImpl)CatalogPlugin.getDefault().getLocalCatalog()).fire(new ResolveChangeEvent(MemoryServiceImpl.this, IResolveChangeEvent.Type.POST_CHANGE, delta));
                        }
                    });
                }
            }
            finally {
                this.dsInstantiationLock.unlock();
            }
            if (changed) {
                ResolveDelta delta = new ResolveDelta((IResolve)this, IResolveDelta.Kind.CHANGED);
                ((CatalogImpl)CatalogPlugin.getDefault().getLocalCatalog()).fire(new ResolveChangeEvent(this, IResolveChangeEvent.Type.POST_CHANGE, delta));
            }
        }
        return this.ds;
    }

    private ActiveMemoryDataStore createNewDS() {
        if (this.factory != null) {
            ActiveMemoryDataStore ds = this.factory.createNewDS();
            if (ds != null) {
                return ds;
            }
            CatalogPlugin.log("MemoryDSFactory '" + this.factory.getClass() + "' returned invalid ActiveMemoryDataStore", null);
        }
        return new ActiveMemoryDataStore();
    }

    @Override
    public void dispose(IProgressMonitor monitor) {
        super.dispose(monitor);
        if (this.memberList != null) {
            this.memberList = null;
        }
    }

    static class ScratchServiceInfo
    extends IServiceInfo {
        ScratchServiceInfo() {
        }

        @Override
        public String getTitle() {
            return Messages.catalog_memory_service_title;
        }

        @Override
        public String getDescription() {
            return this.getTitle();
        }
    }
}

