/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.memory.internal;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.IGeoResourceInfo;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.ITransientResolve;
import net.refractions.udig.catalog.memory.internal.MemoryServiceImpl;
import org.eclipse.core.runtime.IProgressMonitor;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureStore;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class MemoryGeoResourceImpl
extends IGeoResource
implements ITransientResolve {
    private MemoryServiceImpl parent;
    String type;
    private volatile IResolve.Status status;
    private volatile Throwable message;

    public MemoryGeoResourceImpl(String type, MemoryServiceImpl parent) {
        this.service = parent;
        this.type = type;
        this.parent = parent;
    }

    @Override
    public <T> T resolve(Class<T> adaptee, IProgressMonitor monitor) throws IOException {
        if (adaptee == null) {
            return null;
        }
        if (adaptee.isAssignableFrom(ITransientResolve.class)) {
            return adaptee.cast(this);
        }
        if (adaptee.isAssignableFrom(IService.class)) {
            return adaptee.cast(this.parent);
        }
        if (adaptee.isAssignableFrom(IGeoResource.class)) {
            return adaptee.cast(this);
        }
        if (adaptee.isAssignableFrom(IGeoResourceInfo.class)) {
            return adaptee.cast(this.createInfo(monitor));
        }
        if (adaptee.isAssignableFrom(SimpleFeatureStore.class)) {
            return adaptee.cast(this.parent.getDS().getFeatureSource(this.type));
        }
        if (adaptee.isAssignableFrom(SimpleFeatureSource.class)) {
            return adaptee.cast(this.parent.getDS().getFeatureSource(this.type));
        }
        if (adaptee.isAssignableFrom(SimpleFeatureType.class)) {
            return adaptee.cast(this.parent.getDS().getSchema(this.type));
        }
        return super.resolve(adaptee, monitor);
    }

    @Override
    public <T> boolean canResolve(Class<T> adaptee) {
        if (adaptee == null) {
            return false;
        }
        return adaptee.isAssignableFrom(ITransientResolve.class) || adaptee.isAssignableFrom(IService.class) || adaptee.isAssignableFrom(IGeoResource.class) || adaptee.isAssignableFrom(IGeoResourceInfo.class) || adaptee.isAssignableFrom(SimpleFeatureStore.class) || adaptee.isAssignableFrom(SimpleFeatureSource.class) || adaptee.isAssignableFrom(FeatureStore.class) || adaptee.isAssignableFrom(FeatureSource.class) || adaptee.isAssignableFrom(SimpleFeatureType.class) || super.canResolve(adaptee);
    }

    @Override
    public IResolve.Status getStatus() {
        if (this.status == null) {
            return this.parent.getStatus();
        }
        return this.status;
    }

    @Override
    public Throwable getMessage() {
        if (this.message == null) {
            return this.parent.getMessage();
        }
        return this.message;
    }

    @Override
    public URL getIdentifier() {
        try {
            return new URL(String.valueOf(this.parent.getIdentifier().toString()) + "#" + this.type);
        }
        catch (MalformedURLException malformedURLException) {
            return this.parent.getIdentifier();
        }
    }

    @Override
    public ScratchResourceInfo getInfo(IProgressMonitor monitor) throws IOException {
        return (ScratchResourceInfo)super.getInfo(monitor);
    }

    @Override
    protected ScratchResourceInfo createInfo(IProgressMonitor monitor) throws IOException {
        this.parent.rLock.lock();
        try {
            ScratchResourceInfo scratchResourceInfo = new ScratchResourceInfo();
            return scratchResourceInfo;
        }
        finally {
            this.parent.rLock.unlock();
        }
    }

    class ScratchResourceInfo
    extends IGeoResourceInfo {
        SimpleFeatureType ft = null;
        FeatureSource<SimpleFeatureType, SimpleFeature> source;

        ScratchResourceInfo() throws IOException {
            try {
                this.source = MemoryGeoResourceImpl.this.parent.getDS().getFeatureSource(MemoryGeoResourceImpl.this.type);
                this.ft = (SimpleFeatureType)this.source.getSchema();
            }
            catch (Exception e) {
                MemoryGeoResourceImpl.this.status = IResolve.Status.BROKEN;
                MemoryGeoResourceImpl.this.message = new Exception("Error obtaining the feature type: " + MemoryGeoResourceImpl.this.type).initCause(e);
                this.bounds = new ReferencedEnvelope(new Envelope(), this.getCRS());
            }
            this.keywords = new String[]{MemoryGeoResourceImpl.this.type, this.ft.getName().getNamespaceURI()};
        }

        @Override
        public CoordinateReferenceSystem getCRS() {
            GeometryDescriptor defaultGeometry = this.ft.getGeometryDescriptor();
            if (defaultGeometry != null) {
                return defaultGeometry.getCoordinateReferenceSystem();
            }
            return null;
        }

        @Override
        public String getName() {
            return this.ft.getName().getLocalPart();
        }

        @Override
        public URI getSchema() {
            try {
                return new URI(this.ft.getName().getNamespaceURI());
            }
            catch (URISyntaxException uRISyntaxException) {
                return null;
            }
        }

        @Override
        public String getTitle() {
            return this.ft.getName().getLocalPart();
        }

        @Override
        public ReferencedEnvelope getBounds() {
            try {
                ReferencedEnvelope bounds = this.source.getBounds();
                if (bounds == null) {
                    return new ReferencedEnvelope(new Envelope(), (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
                }
                if (bounds instanceof ReferencedEnvelope) {
                    return bounds;
                }
                return new ReferencedEnvelope((Envelope)bounds, this.getCRS());
            }
            catch (IOException iOException) {
                return new ReferencedEnvelope(new Envelope(), (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            }
        }
    }
}

