/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.memory;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.catalog.ICatalogInfo;
import net.refractions.udig.catalog.ID;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.IGeoResourceInfo;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.ISearch;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.IServiceInfo;
import net.refractions.udig.catalog.URLUtils;
import net.refractions.udig.catalog.internal.Messages;
import net.refractions.udig.catalog.util.AST;
import net.refractions.udig.catalog.util.ASTFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.swt.widgets.Display;
import org.geotools.geometry.jts.ReferencedEnvelope;

public class MemoryCatalog
extends ISearch {
    ICatalogInfo info;
    List<IService> services;
    private ID id;
    private String title;

    public MemoryCatalog(ID id, String title, List<IService> services) {
        this.id = id;
        this.title = title;
        this.services = services;
    }

    @Override
    public <T> boolean canResolve(Class<T> adaptee) {
        return false;
    }

    @Override
    public IResolve.Status getStatus() {
        return IResolve.Status.CONNECTED;
    }

    @Override
    public Throwable getMessage() {
        return null;
    }

    @Override
    public URL getIdentifier() {
        return this.id.toURL();
    }

    @Override
    public ID getID() {
        return this.id;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public <T> T resolve(Class<T> adaptee, IProgressMonitor monitor) throws IOException {
        if (adaptee == null) {
            return null;
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            if (adaptee.isInstance(this)) {
                T t = adaptee.cast(this);
                return t;
            }
            if (adaptee.isInstance(this.info)) {
                T t = adaptee.cast(this.info);
                return t;
            }
        }
        finally {
            monitor.worked(1);
            monitor.done();
        }
        return null;
    }

    @Override
    public List<IResolve> find(ID resourceId, IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        URL query = resourceId.toURL();
        LinkedHashSet<IResolve> found = new LinkedHashSet<IResolve>();
        monitor.beginTask("find " + resourceId, this.services.size());
        for (IService service : this.services) {
            service.getID();
            URL identifier = service.getIdentifier();
            if (URLUtils.urlEquals(query, identifier, true)) {
                if (query.getRef() == null && URLUtils.urlEquals(query, identifier, false)) {
                    found.add(service);
                } else {
                    IResolve res = this.getChildById(service, resourceId, monitor);
                    if (res != null) {
                        found.add(res);
                    }
                }
            }
            monitor.worked(1);
        }
        monitor.done();
        return new ArrayList<IResolve>(found);
    }

    @Override
    public <T extends IResolve> T getById(Class<T> type, ID id, IProgressMonitor monitor) {
        return null;
    }

    IResolve getChildById(IResolve handle, ID id, IProgressMonitor monitor) {
        List<IResolve> children;
        block6: {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            if (id.equals(handle.getID())) {
                return handle;
            }
            children = handle.members(monitor);
            if (children != null && !children.isEmpty()) break block6;
            return null;
        }
        try {
            for (IResolve child : children) {
                IResolve found = this.getChildById(child, id, null);
                if (found == null) continue;
                return found;
            }
        }
        catch (IOException e) {
            CatalogPlugin.log("Could not search children of " + handle.getIdentifier(), e);
        }
        return null;
    }

    @Override
    public List<IResolve> search(String pattern, Envelope bbox, IProgressMonitor monitor) throws IOException {
        if (CatalogPlugin.getDefault().isDebugging() && Display.getCurrent() != null) {
            throw new IllegalStateException("search called from display thread");
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        LinkedList<IResolve> result = new LinkedList<IResolve>();
        if (!(pattern != null && pattern.trim().length() != 0 || bbox != null && !bbox.isNull())) {
            return result;
        }
        AST ast = ASTFactory.parse(pattern);
        if (ast == null) {
            return result;
        }
        HashSet<IService> searchScope = new HashSet<IService>();
        searchScope.addAll(this.services);
        try {
            monitor.beginTask(Messages.CatalogImpl_finding, searchScope.size() * 10);
            for (IService service : searchScope) {
                List<? extends IGeoResource> members;
                SubProgressMonitor submonitor;
                ID serviceID;
                block17: {
                    serviceID = service.getID();
                    if (MemoryCatalog.check(service, ast)) {
                        result.add(service);
                    }
                    submonitor = new SubProgressMonitor(monitor, 10);
                    members = service.resources((IProgressMonitor)submonitor);
                    if (members != null) break block17;
                    submonitor.done();
                    continue;
                }
                try {
                    try {
                        for (IGeoResource iGeoResource : members) {
                            ID resoruceID = iGeoResource.getID();
                            try {
                                if (!MemoryCatalog.check(iGeoResource, ast, bbox)) continue;
                                result.add(iGeoResource);
                            }
                            catch (Throwable t) {
                                CatalogPlugin.log("Could not search in resource:" + resoruceID, t);
                            }
                        }
                    }
                    catch (IOException e) {
                        CatalogPlugin.log("Could not search in service:" + serviceID, e);
                        submonitor.done();
                    }
                }
                catch (Throwable throwable) {
                    submonitor.done();
                    throw throwable;
                }
                submonitor.done();
                Thread.yield();
            }
            LinkedList<IResolve> linkedList = result;
            return linkedList;
        }
        finally {
            monitor.done();
        }
    }

    protected static boolean check(IService service, AST pattern) {
        IServiceInfo info;
        if (pattern == null) {
            return false;
        }
        try {
            info = service == null ? null : service.getInfo(null);
        }
        catch (IOException e) {
            info = null;
            CatalogPlugin.log(null, e);
        }
        boolean t = false;
        if (info != null) {
            if (info.getTitle() != null) {
                t = pattern.accept(info.getTitle());
            }
            if (!t && info.getKeywords() != null) {
                String[] keys = info.getKeywords().toArray(new String[0]);
                int i = 0;
                while (!t && i < keys.length) {
                    if (keys[i] != null) {
                        t = pattern.accept(keys[i]);
                    }
                    ++i;
                }
            }
            if (!t && info.getSchema() != null) {
                t = pattern.accept(info.getSchema().toString());
            }
            if (!t && info.getAbstract() != null) {
                t = pattern.accept(info.getAbstract());
            }
            if (!t && info.getDescription() != null) {
                t = pattern.accept(info.getDescription());
            }
        }
        return t;
    }

    protected static boolean check(IGeoResource resource, AST pattern) {
        IGeoResourceInfo info;
        if (pattern == null) {
            return true;
        }
        try {
            info = resource == null ? null : resource.getInfo(null);
        }
        catch (IOException e) {
            CatalogPlugin.log(null, e);
            info = null;
        }
        if (info == null) {
            return false;
        }
        if (pattern.accept(info.getTitle())) {
            return true;
        }
        if (pattern.accept(info.getName())) {
            return true;
        }
        if (info.getKeywords() != null) {
            for (String key : info.getKeywords()) {
                if (!pattern.accept(key)) continue;
                return true;
            }
        }
        if (info.getSchema() != null && pattern.accept(info.getSchema().toString())) {
            return true;
        }
        return pattern.accept(info.getDescription());
    }

    protected static boolean check(IGeoResource resource, AST pattern, Envelope bbox) {
        ReferencedEnvelope bounds;
        block5: {
            if (!MemoryCatalog.check(resource, pattern)) {
                return false;
            }
            if (bbox == null || bbox.isNull()) {
                return true;
            }
            try {
                bounds = resource.getInfo(null).getBounds();
                if (bounds != null) break block5;
                return true;
            }
            catch (Throwable e) {
                CatalogPlugin.log(null, e);
                return false;
            }
        }
        return bbox.intersects((Envelope)bounds);
    }
}

