/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal;

import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.IServiceFactory;
import net.refractions.udig.catalog.ServiceExtension;
import net.refractions.udig.catalog.internal.CatalogImpl;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;

public class ServiceFactoryImpl
extends IServiceFactory {
    @Override
    public List<IService> aquire(URL id, Map<String, Serializable> params) {
        return this.createService(params);
    }

    @Override
    public List<IService> aquire(Map<String, Serializable> params) {
        return this.createService(params);
    }

    @Override
    public List<IService> acquire(Map<String, Serializable> params) {
        return this.createService(params);
    }

    @Override
    public List<IService> aquire(URL target) {
        return this.createService(target);
    }

    @Override
    public List<IService> acquire(URL target) {
        return this.createService(target);
    }

    @Override
    public List<IService> acquire(URL id, Map<String, Serializable> params) {
        return this.createService(params);
    }

    private boolean isGeneric(ServiceExtension serviceExtension) {
        String name = serviceExtension.getClass().getName();
        return name.toLowerCase().contains("geotools");
    }

    @Override
    public List<IService> createService(URL targetUrl) {
        HashMap<ServiceExtension, Map<String, Serializable>> available = new HashMap<ServiceExtension, Map<String, Serializable>>();
        ArrayList<ServiceExtension> generic = new ArrayList<ServiceExtension>();
        for (ServiceExtension serviceExtension : CatalogPlugin.getDefault().getServiceExtensions()) {
            if (this.isGeneric(serviceExtension)) {
                generic.add(serviceExtension);
                continue;
            }
            try {
                Map<String, Serializable> defaultParams = serviceExtension.createParams(targetUrl);
                if (defaultParams == null) continue;
                available.put(serviceExtension, defaultParams);
            }
            catch (Throwable t) {
                if (!CatalogPlugin.getDefault().isDebugging()) continue;
                String name = serviceExtension.getClass().getName();
                Status warning = new Status(2, "net.refractions.udig.catalog", String.valueOf(name) + " could not create params " + targetUrl, t);
                CatalogPlugin.getDefault().getLog().log((IStatus)warning);
            }
        }
        LinkedList<IService> candidates = new LinkedList<IService>();
        if (!available.isEmpty()) {
            for (Map.Entry candidateEntry : available.entrySet()) {
                String extentionIdentifier = ((ServiceExtension)candidateEntry.getKey()).getClass().getName();
                ServiceExtension serviceExtension = (ServiceExtension)candidateEntry.getKey();
                Map connectionParameters = (Map)candidateEntry.getValue();
                try {
                    IService sevice = serviceExtension.createService(null, connectionParameters);
                    CatalogImpl.runInterceptor(sevice, "serviceCreated");
                    candidates.add(sevice);
                }
                catch (Throwable deadService) {
                    CatalogPlugin.log(String.valueOf(extentionIdentifier) + " could not create service", deadService);
                }
            }
        }
        if (candidates.isEmpty() && !generic.isEmpty()) {
            for (ServiceExtension serviceExtension : generic) {
                try {
                    Map<String, Serializable> connectionParameters = serviceExtension.createParams(targetUrl);
                    if (connectionParameters == null) continue;
                    IService service = serviceExtension.createService(null, connectionParameters);
                    CatalogImpl.runInterceptor(service, "serviceCreated");
                    candidates.add(service);
                }
                catch (Throwable deadService) {
                    CatalogPlugin.log(String.valueOf(serviceExtension.getClass().getName()) + " could not create service", deadService);
                }
            }
        }
        return candidates;
    }

    @Override
    public List<IService> createService(Map<String, Serializable> connectionParameters) {
        IService service;
        String name;
        LinkedList<IService> services = new LinkedList<IService>();
        for (ServiceExtension serviceExtension : CatalogPlugin.getDefault().getServiceExtensions()) {
            name = serviceExtension.getClass().getName();
            if (this.isGeneric(serviceExtension)) continue;
            try {
                service = serviceExtension.createService(null, connectionParameters);
                if (service == null) continue;
                CatalogImpl.runInterceptor(service, "serviceCreated");
                services.add(service);
            }
            catch (Throwable deadService) {
                CatalogPlugin.log(String.valueOf(name) + " could not create service", deadService);
            }
        }
        if (services.isEmpty()) {
            for (ServiceExtension serviceExtension : CatalogPlugin.getDefault().getServiceExtensions()) {
                name = serviceExtension.getClass().getName();
                if (!this.isGeneric(serviceExtension)) continue;
                try {
                    service = serviceExtension.createService(null, connectionParameters);
                    if (service == null) continue;
                    CatalogImpl.runInterceptor(service, "serviceCreated");
                    services.add(service);
                }
                catch (Throwable deadService) {
                    deadService.printStackTrace();
                    CatalogPlugin.trace(String.valueOf(name) + " could not create service", deadService);
                }
            }
        }
        return services;
    }

    @Override
    public void dispose(List<IService> list, IProgressMonitor monitor) {
        if (list == null) {
            return;
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask("dispose", list.size() * 10);
        for (IService service : list) {
            try {
                service.dispose((IProgressMonitor)new SubProgressMonitor(monitor, 10));
            }
            catch (Throwable t) {
                CatalogPlugin.trace("Dispose " + service, t);
            }
        }
        monitor.done();
    }
}

