/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal;

import com.vividsolutions.jts.geom.Envelope;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.catalog.ICatalog;
import net.refractions.udig.catalog.ICatalogInfo;
import net.refractions.udig.catalog.ID;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.IGeoResourceInfo;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.IResolveChangeEvent;
import net.refractions.udig.catalog.IResolveChangeListener;
import net.refractions.udig.catalog.IResolveDelta;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.IServiceFactory;
import net.refractions.udig.catalog.IServiceInfo;
import net.refractions.udig.catalog.ServiceParameterPersister;
import net.refractions.udig.catalog.TemporaryResourceFactory;
import net.refractions.udig.catalog.URLUtils;
import net.refractions.udig.catalog.interceptor.GeoResourceInterceptor;
import net.refractions.udig.catalog.interceptor.ServiceInterceptor;
import net.refractions.udig.catalog.internal.CatalogInfoImpl;
import net.refractions.udig.catalog.internal.Messages;
import net.refractions.udig.catalog.internal.ResolveChangeEvent;
import net.refractions.udig.catalog.internal.ResolveDelta;
import net.refractions.udig.catalog.moved.MovedService;
import net.refractions.udig.catalog.util.AST;
import net.refractions.udig.catalog.util.ASTFactory;
import net.refractions.udig.catalog.util.IFriend;
import net.refractions.udig.core.WeakHashSet;
import net.refractions.udig.core.internal.ExtensionPointList;
import net.refractions.udig.core.internal.ExtensionPointProcessor;
import net.refractions.udig.core.internal.ExtensionPointUtil;
import net.refractions.udig.ui.PlatformGIS;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IExportedPreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class CatalogImpl
extends ICatalog {
    private static final String TEMPORARY_RESOURCE_EXT_ID = "net.refractions.udig.catalog.temporaryResource";
    private final Set<IService> services = new CopyOnWriteArraySet<IService>();
    private ICatalogInfo metadata;
    private final Set<IResolveChangeListener> catalogListeners;
    private String[] descriptors;

    public CatalogImpl() {
        CatalogInfoImpl metadata = new CatalogInfoImpl();
        metadata.setTitle(Messages.CatalogImpl_localCatalog_title);
        try {
            metadata.setSource(new URL("http://localhost"));
        }
        catch (MalformedURLException malformedURLException) {}
        this.metadata = metadata;
        this.catalogListeners = Collections.synchronizedSet(new WeakHashSet());
    }

    public CatalogImpl(ICatalogInfo metadata) {
        this();
        this.metadata = metadata;
    }

    @Override
    public void addCatalogListener(IResolveChangeListener listener) {
        this.catalogListeners.add(listener);
    }

    @Override
    public void addListener(IResolveChangeListener listener) {
        this.catalogListeners.add(listener);
    }

    @Override
    public void removeCatalogListener(IResolveChangeListener listener) {
        this.catalogListeners.remove(listener);
    }

    @Override
    public void removeListener(IResolveChangeListener listener) {
        this.catalogListeners.remove(listener);
    }

    @Override
    public IService add(IService service) throws UnsupportedOperationException {
        if (service == null || service.getIdentifier() == null) {
            throw new NullPointerException("Cannot have a null id");
        }
        ID id = service.getID();
        IService found = this.getById(IService.class, id, (IProgressMonitor)new NullProgressMonitor());
        if (found != null) {
            try {
                service.dispose((IProgressMonitor)new NullProgressMonitor());
            }
            catch (Throwable t) {
                CatalogPlugin.trace("dispose " + id, t);
            }
            return found;
        }
        this.services.add(service);
        CatalogImpl.runInterceptor(service, "serviceAdded");
        ResolveDelta deltaAdded = new ResolveDelta((IResolve)service, IResolveDelta.Kind.ADDED);
        ResolveDelta deltaChanged = new ResolveDelta((IResolve)this, Collections.singletonList(deltaAdded));
        this.fire(new ResolveChangeEvent(this, IResolveChangeEvent.Type.POST_CHANGE, deltaChanged));
        return service;
    }

    @Override
    public void remove(IService entry) throws UnsupportedOperationException {
        if (entry == null || entry.getIdentifier() == null) {
            throw new NullPointerException("Cannot have a null id");
        }
        ResolveDelta deltaRemoved = new ResolveDelta((IResolve)entry, IResolveDelta.Kind.REMOVED);
        ResolveDelta deltaChanged = new ResolveDelta((IResolve)this, Collections.singletonList(deltaRemoved));
        this.fire(new ResolveChangeEvent(this, IResolveChangeEvent.Type.PRE_DELETE, deltaChanged));
        this.services.remove(entry);
        CatalogImpl.runInterceptor(entry, "serviceRemoved");
        this.fire(new ResolveChangeEvent(this, IResolveChangeEvent.Type.POST_CHANGE, deltaRemoved));
    }

    @Override
    public void replace(ID id, IService replacement) throws UnsupportedOperationException {
        if (replacement == null || replacement.getIdentifier() == null || id == null) {
            throw new NullPointerException("Cannot have a null id");
        }
        final IService service = this.getServiceById(id);
        ArrayList<IResolveDelta> changes = new ArrayList<IResolveDelta>();
        ArrayList<IResolveDelta> childChanges = new ArrayList<IResolveDelta>();
        try {
            List<? extends IGeoResource> newChildren = replacement.resources(null);
            List<? extends IGeoResource> oldChildren = service.resources(null);
            if (oldChildren != null) {
                block2: for (IGeoResource iGeoResource : oldChildren) {
                    String oldName = iGeoResource.getIdentifier().toString();
                    for (IGeoResource iGeoResource2 : newChildren) {
                        String name = iGeoResource2.getIdentifier().toString();
                        if (!oldName.equals(name)) continue;
                        childChanges.add(new ResolveDelta((IResolve)iGeoResource2, iGeoResource, IResolveDelta.NO_CHILDREN));
                        continue block2;
                    }
                }
            }
        }
        catch (IOException iOException) {}
        changes.add(new ResolveDelta((IResolve)service, replacement, childChanges));
        ResolveDelta deltas = new ResolveDelta((IResolve)this, changes);
        ResolveChangeEvent event = new ResolveChangeEvent(this, IResolveChangeEvent.Type.PRE_DELETE, deltas);
        this.fire(event);
        this.services.remove(service);
        CatalogImpl.runInterceptor(service, "serviceRemoved");
        PlatformGIS.run((IRunnableWithProgress)new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    service.dispose(monitor);
                }
                catch (Throwable e) {
                    CatalogPlugin.log("error disposing of: " + service.getIdentifier(), e);
                }
            }
        });
        this.services.add(replacement);
        CatalogImpl.runInterceptor(replacement, "serviceAdded");
        event = new ResolveChangeEvent(this, IResolveChangeEvent.Type.POST_CHANGE, deltas);
        if (!id.equals(replacement.getIdentifier())) {
            MovedService movedService = new MovedService(id, replacement.getID());
            this.services.add(movedService);
            CatalogImpl.runInterceptor(movedService, "serviceAdded");
        }
        this.fire(event);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public IService acquire(URL url, IProgressMonitor monitor) throws IOException {
        possible = new ArrayList<IService>();
        createdService = null;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask("acquire", 100);
        monitor.subTask("acquire services");
        monitor.worked(10);
        possible = this.constructServices(url, monitor);
        if (possible.isEmpty()) {
            throw new IOException("Unable to connect to any service supporting " + url);
        }
        createdService = possible.get(0);
        this.add(createdService);
        var7_5 = createdService;
        members = this.checkMembers(possible);
        ** for (service : members)
lbl-1000:
        // 1 sources

        {
            if (service.equals(createdService)) continue;
            service.dispose((IProgressMonitor)new SubProgressMonitor(monitor, 10));
            continue;
        }
lbl22:
        // 1 sources

        monitor.done();
        return var7_5;
        {
            catch (Throwable t) {
                try {
                    CatalogPlugin.trace("trouble connecting to " + createdService.getID(), t);
                }
                catch (Throwable var6_16) {}
                finally {
                    members = this.checkMembers(possible);
                    ** for (service : members)
                }
            }
        }
lbl-1000:
        // 1 sources

        {
            if (service.equals(createdService)) continue;
            service.dispose((IProgressMonitor)new SubProgressMonitor(monitor, 10));
            continue;
        }
lbl35:
        // 1 sources

        monitor.done();
        return null;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public IService acquire(Map<String, Serializable> connectionParameters, IProgressMonitor monitor) throws IOException {
        possible = new ArrayList<IService>();
        createdService = null;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask("acquire", 100);
        monitor.subTask("acquire services");
        possible = this.constructServices(connectionParameters, monitor);
        if (possible.isEmpty()) {
            throw new IOException("Unable to connect to any service ");
        }
        createdService = possible.get(0);
        this.add(createdService);
        var7_5 = createdService;
        members = this.checkMembers(possible);
        ** for (service : members)
lbl-1000:
        // 1 sources

        {
            if (service.equals(createdService)) continue;
            service.dispose((IProgressMonitor)new SubProgressMonitor(monitor, 10));
            continue;
        }
lbl21:
        // 1 sources

        monitor.done();
        return var7_5;
        {
            catch (Throwable t) {
                try {
                    CatalogPlugin.trace("trouble connecting to " + createdService.getID(), t);
                }
                catch (Throwable var6_16) {}
                finally {
                    members = this.checkMembers(possible);
                    ** for (service : members)
                }
            }
        }
lbl-1000:
        // 1 sources

        {
            if (service.equals(createdService)) continue;
            service.dispose((IProgressMonitor)new SubProgressMonitor(monitor, 10));
            continue;
        }
lbl34:
        // 1 sources

        monitor.done();
        return null;
    }

    @Override
    public List<IResolve> find(ID id, IProgressMonitor monitor) {
        URL identifier;
        URL query = id.toURL();
        LinkedHashSet<IResolve> found = new LinkedHashSet<IResolve>();
        for (IService service : this.services) {
            if (service.getStatus() != IResolve.Status.CONNECTED) continue;
            identifier = service.getIdentifier();
            boolean matchParentURL = URLUtils.urlEquals(query, identifier, true);
            boolean matchParentID = service.getID().equals(id, true);
            if (!matchParentURL && !matchParentID) continue;
            if (this.matchedService(query, identifier)) {
                found.add(service);
                found.addAll(this.friends(service));
                continue;
            }
            IResolve res = this.getChildById(service, id, true, monitor);
            if (res == null) continue;
            found.add(res);
            found.addAll(this.friends(res));
        }
        for (IService service : this.services) {
            if (service.getStatus() == IResolve.Status.CONNECTED || !URLUtils.urlEquals(query, identifier = service.getIdentifier(), true) || service.getStatus() != IResolve.Status.NOTCONNECTED) continue;
            if (this.matchedService(query, identifier)) {
                found.add(service);
                found.addAll(this.friends(service));
                continue;
            }
            IResolve res = this.getChildById(service, id, true, monitor);
            if (res == null) continue;
            found.add(res);
            found.addAll(this.friends(res));
        }
        for (IService service : this.services) {
            if (service.getStatus() == IResolve.Status.CONNECTED || service.getStatus() == IResolve.Status.NOTCONNECTED || !URLUtils.urlEquals(query, identifier = service.getIdentifier(), true)) continue;
            if (this.matchedService(query, identifier)) {
                found.add(service);
                found.addAll(this.friends(service));
                continue;
            }
            IResolve res = this.getChildById(service, id, true, monitor);
            if (res == null) continue;
            found.add(res);
            found.addAll(this.friends(res));
        }
        return new ArrayList<IResolve>(found);
    }

    @Override
    public List<IResolve> find(URL query, IProgressMonitor monitor) {
        return this.find(new ID(query), monitor);
    }

    private boolean matchedService(URL query, URL identifier) {
        return query.getRef() == null && URLUtils.urlEquals(query, identifier, false);
    }

    public List<IResolve> friends(final IResolve handle) {
        final ArrayList<IResolve> friends = new ArrayList<IResolve>();
        ExtensionPointUtil.process((Plugin)CatalogPlugin.getDefault(), (String)"net.refractions.udig.catalog.friendly", (ExtensionPointProcessor)new ExtensionPointProcessor(){

            public void process(IExtension extension, IConfigurationElement element) throws Exception {
                try {
                    String uri;
                    String target = element.getAttribute("target");
                    String contain = element.getAttribute("contain");
                    if (target != null && target.equals(target.getClass().toString())) {
                        return;
                    }
                    if (contain != null && !(uri = handle.getIdentifier().toExternalForm()).contains(contain)) {
                        return;
                    }
                    IFriend friendly = (IFriend)element.createExecutableExtension("class");
                    friends.addAll(friendly.friendly(handle, null));
                }
                catch (Throwable t) {
                    CatalogPlugin.log(t.getLocalizedMessage(), t);
                }
            }
        });
        return friends;
    }

    private IService getServiceById(ID id) {
        if (id == null) {
            return null;
        }
        for (IService service : this.services) {
            if (!id.equals(service.getID())) continue;
            return service;
        }
        return null;
    }

    @Override
    public <T extends IResolve> T getById(Class<T> type, ID id, IProgressMonitor monitor) {
        IProgressMonitor monitor2 = monitor;
        if (monitor2 == null) {
            monitor2 = new NullProgressMonitor();
        }
        if (id == null) {
            return null;
        }
        if (IService.class.isAssignableFrom(type)) {
            monitor2.beginTask(Messages.CatalogImpl_monitorTask, 1);
            IService service = this.getServiceById(id);
            monitor2.done();
            return (T)((IResolve)type.cast(service));
        }
        URL url = id.toURL();
        if (IResolve.class.isAssignableFrom(type)) {
            for (IService service : this.services) {
                IResolve child;
                if (!URLUtils.urlEquals(url, service.getIdentifier(), true) || (child = this.getChildById(service, id, false, monitor2)) == null) continue;
                return (T)((IResolve)type.cast(child));
            }
        }
        return null;
    }

    public IResolve getChildById(IResolve handle, ID id, boolean roughMatch, IProgressMonitor monitor) {
        List<IResolve> children;
        IProgressMonitor monitor2;
        block6: {
            URL url2;
            URL url1;
            monitor2 = monitor;
            if (monitor2 == null) {
                monitor2 = new NullProgressMonitor();
            }
            if (roughMatch ? new ID(url1 = id.toURL()).equals(new ID(url2 = handle.getIdentifier())) : id.equals(handle.getID())) {
                return handle;
            }
            children = handle.members(monitor2);
            if (children != null && !children.isEmpty()) break block6;
            return null;
        }
        try {
            monitor2.beginTask(Messages.CatalogImpl_monitorTask2, children.size());
            for (IResolve child : children) {
                IResolve found = this.getChildById(child, id, roughMatch, null);
                if (found == null) continue;
                return found;
            }
        }
        catch (IOException e) {
            CatalogPlugin.log("Could not search children of " + handle.getIdentifier(), e);
        }
        return null;
    }

    @Override
    public synchronized List<IResolve> search(String pattern, Envelope bbox, IProgressMonitor monitor2) {
        if (CatalogPlugin.getDefault().isDebugging() && Display.getCurrent() != null) {
            throw new IllegalStateException("search called from display thread");
        }
        IProgressMonitor monitor = monitor2;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if ((pattern == null || "".equals(pattern.trim())) && (bbox == null || bbox.isNull())) {
            return new LinkedList<IResolve>();
        }
        LinkedList<IResolve> result = new LinkedList<IResolve>();
        AST ast = ASTFactory.parse(pattern);
        if (ast == null) {
            return result;
        }
        HashSet<IService> searchScope = new HashSet<IService>();
        searchScope.addAll(this.services);
        try {
            monitor.beginTask(Messages.CatalogImpl_finding, searchScope.size() * 10);
            for (IService service : searchScope) {
                List<? extends IGeoResource> members;
                SubProgressMonitor submonitor;
                ID serviceID;
                block17: {
                    serviceID = service.getID();
                    if (CatalogImpl.check(service, ast)) {
                        result.add(service);
                    }
                    submonitor = new SubProgressMonitor(monitor, 10);
                    members = service.resources((IProgressMonitor)submonitor);
                    if (members != null) break block17;
                    submonitor.done();
                    continue;
                }
                try {
                    try {
                        for (IGeoResource iGeoResource : members) {
                            ID resoruceID = iGeoResource.getID();
                            try {
                                if (!CatalogImpl.check(iGeoResource, ast, bbox)) continue;
                                result.add(iGeoResource);
                            }
                            catch (Throwable t) {
                                CatalogPlugin.log("Could not search in resource:" + resoruceID, t);
                            }
                        }
                    }
                    catch (IOException e) {
                        CatalogPlugin.log("Could not search in service:" + serviceID, e);
                        submonitor.done();
                    }
                }
                catch (Throwable throwable) {
                    submonitor.done();
                    throw throwable;
                }
                submonitor.done();
                Thread.yield();
            }
            LinkedList<IResolve> linkedList = result;
            return linkedList;
        }
        finally {
            monitor.done();
        }
    }

    protected static boolean check(IService service, AST pattern) {
        IServiceInfo info;
        if (pattern == null) {
            return false;
        }
        try {
            info = service == null ? null : service.getInfo(null);
        }
        catch (IOException e) {
            info = null;
            CatalogPlugin.log(null, e);
        }
        boolean t = false;
        if (info != null) {
            if (info.getTitle() != null) {
                t = pattern.accept(info.getTitle());
            }
            if (!t && info.getKeywords() != null) {
                String[] keys = info.getKeywords().toArray(new String[0]);
                int i = 0;
                while (!t && i < keys.length) {
                    if (keys[i] != null) {
                        t = pattern.accept(keys[i]);
                    }
                    ++i;
                }
            }
            if (!t && info.getSchema() != null) {
                t = pattern.accept(info.getSchema().toString());
            }
            if (!t && info.getAbstract() != null) {
                t = pattern.accept(info.getAbstract());
            }
            if (!t && info.getDescription() != null) {
                t = pattern.accept(info.getDescription());
            }
        }
        return t;
    }

    protected static boolean check(IGeoResource resource, AST pattern) {
        IGeoResourceInfo info;
        if (pattern == null) {
            return true;
        }
        try {
            info = resource == null ? null : resource.getInfo(null);
        }
        catch (IOException e) {
            CatalogPlugin.log(null, e);
            info = null;
        }
        if (info == null) {
            return false;
        }
        if (pattern.accept(info.getTitle())) {
            return true;
        }
        if (pattern.accept(info.getName())) {
            return true;
        }
        if (info.getKeywords() != null) {
            for (String key : info.getKeywords()) {
                if (!pattern.accept(key)) continue;
                return true;
            }
        }
        if (info.getSchema() != null && pattern.accept(info.getSchema().toString())) {
            return true;
        }
        return pattern.accept(info.getDescription());
    }

    protected static boolean check(IGeoResource resource, AST pattern, Envelope bbox) {
        ReferencedEnvelope bounds;
        block5: {
            if (!CatalogImpl.check(resource, pattern)) {
                return false;
            }
            if (bbox == null || bbox.isNull()) {
                return true;
            }
            try {
                bounds = resource.getInfo(null).getBounds();
                if (bounds != null) break block5;
                return true;
            }
            catch (Throwable e) {
                CatalogPlugin.log(null, e);
                return false;
            }
        }
        bounds = bounds.transform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, true);
        return bbox.intersects((Envelope)bounds);
    }

    public void fire(IResolveChangeEvent event) {
        if (this.catalogListeners.size() == 0) {
            return;
        }
        HashSet<IResolveChangeListener> copy = this.getListenersCopy();
        for (IResolveChangeListener listener : copy) {
            try {
                listener.changed(event);
            }
            catch (Throwable die) {
                CatalogPlugin.log("Catalog event could not be delivered to " + listener.getClass().getSimpleName() + ":" + listener.toString(), die);
                die.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashSet<IResolveChangeListener> getListenersCopy() {
        HashSet<IResolveChangeListener> copy;
        Set<IResolveChangeListener> set = this.catalogListeners;
        synchronized (set) {
            copy = new HashSet<IResolveChangeListener>(this.catalogListeners);
        }
        return copy;
    }

    @Override
    public <T> T resolve(Class<T> adaptee, IProgressMonitor monitor2) {
        Object monitor = monitor2 == null ? new NullProgressMonitor() : monitor2;
        try {
            if (adaptee == null) {
                return null;
            }
            monitor.beginTask(String.valueOf(Messages.CatalogImpl_resolving) + adaptee.getSimpleName(), 2);
            monitor.worked(1);
            if (adaptee.isAssignableFrom(CatalogImpl.class)) {
                T t = adaptee.cast(this);
                return t;
            }
            if (adaptee.isAssignableFrom(CatalogInfoImpl.class)) {
                T t = adaptee.cast(this.metadata);
                return t;
            }
            if (adaptee.isAssignableFrom(this.services.getClass())) {
                T t = adaptee.cast(this.services);
                return t;
            }
            if (adaptee.isAssignableFrom(List.class)) {
                T t = adaptee.cast(new LinkedList<IService>(this.services));
                return t;
            }
            if (adaptee.isAssignableFrom(this.catalogListeners.getClass())) {
                T t = adaptee.cast(this.getListenersCopy());
                return t;
            }
        }
        finally {
            monitor.worked(1);
            monitor.done();
        }
        return null;
    }

    @Override
    public <T> boolean canResolve(Class<T> adaptee) {
        T value = this.resolve(adaptee, null);
        return value != null;
    }

    @Override
    public List<IResolve> members(IProgressMonitor monitor2) {
        IProgressMonitor monitor = monitor2;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(Messages.CatalogImpl_finding, 1);
        monitor.done();
        return new LinkedList<IResolve>(this.services);
    }

    @Override
    public String getTitle() {
        return this.metadata.getTitle();
    }

    @Override
    public IResolve.Status getStatus() {
        return IResolve.Status.CONNECTED;
    }

    @Override
    public Throwable getMessage() {
        return null;
    }

    @Override
    public URL getIdentifier() {
        return this.metadata.getSource();
    }

    @Override
    public ID getID() {
        return new ID(this.getIdentifier());
    }

    @Override
    public IGeoResource createTemporaryResource(Object descriptor) {
        List list = ExtensionPointList.getExtensionPointList((String)TEMPORARY_RESOURCE_EXT_ID);
        for (IConfigurationElement element : list) {
            try {
                String attribute = element.getAttribute("descriptorClass");
                Class<?> c = descriptor.getClass().getClassLoader().loadClass(attribute);
                if (!c.isAssignableFrom(descriptor.getClass())) continue;
                TemporaryResourceFactory fac = (TemporaryResourceFactory)element.createExecutableExtension("factory");
                return fac.createResource(descriptor);
            }
            catch (ClassNotFoundException e) {
                CatalogPlugin.trace("Trying to match classes", e);
            }
            catch (Exception e) {
                throw (RuntimeException)new RuntimeException().initCause(e);
            }
        }
        throw new IllegalArgumentException(descriptor.getClass() + " is not a legal descriptor type.  If must be one of " + String.valueOf(this.getTemporaryDescriptorClasses()));
    }

    @Override
    public synchronized String[] getTemporaryDescriptorClasses() {
        if (this.descriptors == null) {
            List list = ExtensionPointList.getExtensionPointList((String)TEMPORARY_RESOURCE_EXT_ID);
            ArrayList<String> temp = new ArrayList<String>();
            for (IConfigurationElement element : list) {
                try {
                    String desc = element.getAttribute("descriptorClass");
                    if (desc == null) continue;
                    temp.add(desc);
                }
                catch (Exception e) {
                    CatalogPlugin.log("", e);
                }
            }
            this.descriptors = temp.toArray(new String[temp.size()]);
        }
        int i = 0;
        if (this.descriptors != null) {
            i = this.descriptors.length;
        }
        String[] k = new String[i];
        if (this.descriptors != null) {
            System.arraycopy(this.descriptors, 0, k, 0, k.length);
        }
        return k;
    }

    public void loadFromFile(File catalogLocation, IServiceFactory factory) {
        try {
            FileInputStream input = new FileInputStream(catalogLocation);
            IPreferencesService preferencesService = Platform.getPreferencesService();
            IExportedPreferences paramsNode = preferencesService.readPreferences((InputStream)input);
            ServiceParameterPersister persister = new ServiceParameterPersister(this, factory, catalogLocation);
            Preferences parameterNode = this.findParameterNode(paramsNode);
            persister.restore(parameterNode);
        }
        catch (Throwable e) {
            CatalogPlugin.trace("Unable to restore catalog:" + e, e);
            try {
                this.loadFromFileOld(factory, e);
                CatalogPlugin.trace("Restored from old catalog format", null);
            }
            catch (Throwable throwable) {
                CatalogPlugin.log("Unable to restore from old catalog format", e);
            }
        }
    }

    public void loadFromFileOld(IServiceFactory factory, Throwable e) {
        IPreferencesService prefs = Platform.getPreferencesService();
        IEclipsePreferences root = prefs.getRootNode();
        Preferences node = root.node("instance").node("net.refractions.udig.catalog.services");
        ServiceParameterPersister persister = new ServiceParameterPersister(this, factory);
        persister.restore(node);
    }

    private Preferences findParameterNode(IExportedPreferences paramsNode) throws BackingStoreException {
        String[] name = paramsNode.childrenNames();
        Preferences plugin = paramsNode.node(name[0]);
        name = plugin.childrenNames();
        return plugin.node(name[0]);
    }

    public void saveToFile(File catalogLocation, IServiceFactory factory, IProgressMonitor monitor) {
        try {
            Preferences toSave = Platform.getPreferencesService().getRootNode().node("net.refractions.udig.catalog").node("LOCAL_CATALOG_SERVICES");
            if (this.services != null) {
                ServiceParameterPersister persister = new ServiceParameterPersister(this, factory, catalogLocation.getParentFile());
                persister.store(monitor, toSave, this.services);
            }
            FileOutputStream out = new FileOutputStream(catalogLocation);
            Platform.getPreferencesService().exportPreferences((IEclipsePreferences)toSave, (OutputStream)out, null);
            toSave.clear();
        }
        catch (Throwable t) {
            CatalogPlugin.log("Error saving services for the local catalog", t);
        }
    }

    public static void runInterceptor(IService service, String activity) {
        if (!("serviceAdded".equals(activity) || "serviceRemoved".equals(activity) || "serviceCreated".equals(activity))) {
            return;
        }
        List interceptors = ExtensionPointList.getExtensionPointList((String)"net.refractions.udig.catalog.serviceInterceptor");
        for (IConfigurationElement element : interceptors) {
            if (!activity.equals(element.getName())) continue;
            try {
                ServiceInterceptor interceptor = (ServiceInterceptor)element.createExecutableExtension("class");
                interceptor.run(service);
            }
            catch (Exception e) {
                CatalogPlugin.trace(String.valueOf(activity) + " " + element.getAttribute("class") + ":" + e, e);
            }
        }
    }

    public static void runInterceptor(IGeoResource resource, String activity) {
        if (!"resourceAdded".equals(activity) && !"resourceRemoved".equals(activity)) {
            return;
        }
        List interceptors = ExtensionPointList.getExtensionPointList((String)"net.refractions.udig.catalog.serviceInterceptor");
        for (IConfigurationElement element : interceptors) {
            if (!activity.equals(element.getName())) continue;
            try {
                GeoResourceInterceptor interceptor = (GeoResourceInterceptor)element.createExecutableExtension("class");
                interceptor.run(resource);
            }
            catch (Exception e) {
                CatalogPlugin.trace(String.valueOf(activity) + " " + element.getAttribute("class") + ":" + e, e);
            }
        }
    }

    private List<IService> prioritise(List<IService> services, IProgressMonitor monitor) {
        if (services.size() < 2) {
            return services;
        }
        SubProgressMonitor monitor2 = new SubProgressMonitor(monitor, 60);
        class IServiceComparator
        implements Comparator<IService> {
            private final /* synthetic */ IProgressMonitor val$monitor2;

            IServiceComparator(IProgressMonitor iProgressMonitor) {
                this.val$monitor2 = iProgressMonitor;
            }

            @Override
            public int compare(IService o1, IService o2) {
                double metric2;
                double metric1;
                block4: {
                    try {
                        IServiceInfo info1 = o1.getInfo((IProgressMonitor)new SubProgressMonitor(this.val$monitor2, 1));
                        IServiceInfo info2 = o2.getInfo((IProgressMonitor)new SubProgressMonitor(this.val$monitor2, 1));
                        metric1 = info1.getMetric();
                        metric2 = info2.getMetric();
                        if (!(metric1 > metric2)) break block4;
                        return 1;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        return 0;
                    }
                }
                if (metric1 < metric2) {
                    return -1;
                }
                return 0;
            }
        }
        IServiceComparator comparator = new IServiceComparator((IProgressMonitor)monitor2);
        Collections.sort(services, comparator);
        return services;
    }

    @Override
    public List<IService> checkMembers(List<IService> constructServiceList) {
        ArrayList<IService> catalogServices = new ArrayList<IService>();
        for (IService service : constructServiceList) {
            ID id = service.getID();
            IService found = this.getById(IService.class, id, (IProgressMonitor)new NullProgressMonitor());
            if (found == null) continue;
            catalogServices.add(service);
        }
        return catalogServices;
    }

    @Override
    public List<IService> checkNonMembers(List<IService> constructServiceList) {
        ArrayList<IService> catalogServices = new ArrayList<IService>();
        for (IService service : constructServiceList) {
            ID id = service.getID();
            IService found = this.getById(IService.class, id, (IProgressMonitor)new NullProgressMonitor());
            if (found != null) continue;
            catalogServices.add(service);
        }
        return catalogServices;
    }

    @Override
    public List<IService> constructServices(URL url, IProgressMonitor monitor) throws IOException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (url == null) {
            return null;
        }
        int urlProcessCount = 0;
        ArrayList<IService> availableServices = new ArrayList<IService>();
        IServiceFactory factory = CatalogPlugin.getDefault().getServiceFactory();
        monitor.beginTask("Check", 1);
        monitor.subTask("Check available services");
        try {
            List<IService> possible = factory.createService(url);
            monitor.worked(urlProcessCount);
            SubProgressMonitor monitor3 = new SubProgressMonitor(monitor, 60);
            monitor3.beginTask("connect", possible.size() * 10);
            for (IService service : possible) {
                if (service == null) continue;
                monitor3.subTask("connect " + service.getID());
                try {
                    IServiceInfo info = service.getInfo((IProgressMonitor)new SubProgressMonitor((IProgressMonitor)monitor3, 10));
                    if (info == null) {
                        CatalogPlugin.trace("unable to connect to " + service.getID(), null);
                        continue;
                    }
                    availableServices.add(service);
                }
                catch (Throwable t) {
                    CatalogPlugin.trace("trouble connecting to " + service.getID(), t);
                }
            }
            monitor3.done();
        }
        finally {
            monitor.done();
        }
        return this.prioritise(availableServices, monitor);
    }

    @Override
    public List<IService> constructServices(Map<String, Serializable> params, IProgressMonitor monitor) throws IOException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        ArrayList<IService> availableServices = new ArrayList<IService>();
        IServiceFactory factory = CatalogPlugin.getDefault().getServiceFactory();
        IOException eek = null;
        try {
            if (params != null && !params.isEmpty()) {
                List<IService> createdServices = factory.createService(params);
                HashSet<IService> results = new HashSet<IService>(createdServices);
                if (results.isEmpty()) {
                    List<IService> list = createdServices;
                    return list;
                }
                for (IService service : results) {
                    try {
                        IServiceInfo info = service.getInfo((IProgressMonitor)new SubProgressMonitor(monitor, 10));
                        if (info == null) {
                            CatalogPlugin.trace("unable to connect to " + service.getID(), null);
                            continue;
                        }
                        availableServices.add(service);
                    }
                    catch (Throwable t) {
                        if (t instanceof IOException) {
                            eek = (IOException)t;
                            continue;
                        }
                        t.printStackTrace();
                    }
                }
            }
        }
        finally {
            monitor.done();
        }
        if (eek != null) {
            throw eek;
        }
        return this.prioritise(availableServices, monitor);
    }
}

