/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal;

import net.refractions.udig.catalog.IResolve;
import org.eclipse.core.expressions.PropertyTester;
import org.geotools.data.DataStore;
import org.geotools.data.ows.Layer;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.data.wms.WebMapServer;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.style.Style;

public class CanResolvePropertyTester
extends PropertyTester {
    private static final String PROPERTY_FEATURESOURCE = "featureSource";
    private static final String PROPERTY_FEATURESTORE = "featureStore";
    private static final String PROPERTY_DATASTORE = "dataSource";
    private static final String PROPERTY_WMS = "wms";
    private static final String PROPERTY_WMS_LAYER = "wmsLayer";
    private static final String PROPERTY_SCHEMA = "schema";
    private static final String PROPERTY_STYLE = "style";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        IResolve resolve = (IResolve)receiver;
        if (resolve == null) {
            return false;
        }
        if (PROPERTY_FEATURESOURCE.equals(property)) {
            return resolve.canResolve(SimpleFeatureSource.class);
        }
        if (PROPERTY_FEATURESTORE.equals(property)) {
            return resolve.canResolve(SimpleFeatureStore.class);
        }
        if (PROPERTY_DATASTORE.equals(property)) {
            return resolve.canResolve(DataStore.class);
        }
        if (PROPERTY_WMS.equals(property)) {
            return resolve.canResolve(WebMapServer.class);
        }
        if (PROPERTY_WMS_LAYER.equals(property)) {
            return resolve.canResolve(Layer.class);
        }
        if (PROPERTY_SCHEMA.equals(property)) {
            return resolve.canResolve(SimpleFeatureType.class);
        }
        if (PROPERTY_STYLE.equals(property)) {
            return resolve.canResolve(Style.class);
        }
        return false;
    }
}

